/*!**************************************************************************

    module      : Log_ActionSetFileState.cpp
    -------------------------------------------------------------------------

    responsible : UweH

    special area: Logging
    description : defines a class to handle load begin

    last changed: 2002-08-09

    -------------------------------------------------------------------------

    copyright:    (c) 2000-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end




*****************************************************************************/

/*===========================================================================*
*  INCLUDES                                                                  *
*============================================================================*/

#include "Logging/Log_ActionSetFileState.hpp"
#include "Logging/Log_ActionFileHandling.hpp"
#include "ggg00.h"
#include "hbd01.h"

/*===========================================================================*
*  FUNCTIONS                                                                 *
*============================================================================*/

//---------------------------------------------------------------------------

void Log_ActionSetFileState::ExecuteAction
            ( tgg00_TransContext &TransContext,
              tgg00_FileId       *pCommandFileId,
              bool                readonly ) const
{
    SAPDBTRACE_METHOD_DEBUG ("Log_ActionSetFileState::ExecuteAction", LogAction_Trace, 5);
    
    if ( TransContext.trError_gg00 != e_ok )
        return; 
    
    tgg00_FileId  RedoFileId;
    tgg00_FileId *pExecuteFileId; 

    pExecuteFileId = Log_GetFileId (m_head.filename, RedoFileId, pCommandFileId);

    //b01fset_write_state (TransContext, *pExecuteFileId, m_head.readonly); NOOP

    if ( NULL == pCommandFileId
         &&
         (e_file_not_found == TransContext.trError_gg00
         ||
         e_file_unloaded == TransContext.trError_gg00) )
     {
         TransContext.trError_gg00 = e_ok;
     }
}

/*===========================================================================*
*  END OF CODE                                                               *
*============================================================================*/
