/*!
  @file           IFRConversion_CharAsciiConverter.cpp
  @author         D039759
  @ingroup        IFR_DataConv
  @brief
  @see

\if EMIT_LICENCE



    ========== licence begin  GPL
    Copyright (c) 2001-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end







\endif
*/
#include "SAPDB/Interfaces/Runtime/IFR_Common.h"
#include "SAPDB/Interfaces/Runtime/Conversion/IFRConversion_CharAsciiConverter.h"

#define DBUG_CLINK_METHOD_ENTER(x,y) DBUG_CONTEXT_METHOD_ENTER(x, y, &clink)

//----------------------------------------------------------------------
IFRConversion_CharAsciiConverter::IFRConversion_CharAsciiConverter(IFR_ShortInfo &shortinfo, 
                                                                   SAPDBMem_IRawAllocator& allocator, 
                                                                   IFR_Connection& connection)
:IFRConversion_ByteCharDataConverter(shortinfo, allocator, connection.chopBlanks(), true)
{
    m_flags.binary_as_encoded = connection.translateBinaryAsEncoded() ? 1 : 0;
}

//----------------------------------------------------------------------
IFRConversion_CharAsciiConverter::~IFRConversion_CharAsciiConverter()
{
}

//----------------------------------------------------------------------
IFR_Retcode
IFRConversion_CharAsciiConverter::appendBinaryInput(IFRPacket_DataPart& datapart,
                                                    char               *data,
                                                    IFR_Length            datalength,
                                                    IFR_Length*           lengthindicator,
                                                    IFR_ConnectionItem & clink,
                                                    IFR_Length         &offset,
                                                    IFRConversion_Putval *putval)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_CharAsciiConverter, appendBinaryInput);
    if(m_flags.binary_as_encoded) {
        DBUG_RETURN(IFRConversion_ByteCharDataConverter::appendBinaryInput(datapart, data, datalength, lengthindicator, clink, offset, putval));
    } else {
        clink.error().setRuntimeError(IFR_ERR_BINARY_TO_ENCODED_UNSUPPORTED_I, (IFR_Int4)getIndex());
        DBUG_RETURN(IFR_NOT_OK);
    }
}

//----------------------------------------------------------------------
IFR_Retcode 
IFRConversion_CharAsciiConverter::appendBinaryOutput(IFRPacket_DataPart&   datapart,
                                                     char                 *data,
                                                     IFR_Length            datalength,
                                                     IFR_Length*           lengthindicator,
                                                     IFR_ConnectionItem   &clink,
                                                     IFR_Length&           dataoffset,
                                                     IFR_Length&           offset,
                                                     IFRConversion_Getval *getval)
{
    DBUG_CLINK_METHOD_ENTER(IFRConversion_CharAsciiConverter, appendBinaryOutput);
    if(m_flags.binary_as_encoded) {
        DBUG_RETURN(IFRConversion_ByteCharDataConverter::appendBinaryOutput(datapart, 
                                                                            data,
                                                                            datalength,
                                                                            lengthindicator,
                                                                            clink,
                                                                            dataoffset,
                                                                            offset,
                                                                            getval));
    } else {
        clink.error().setRuntimeError(IFR_ERR_BINARY_TO_ENCODED_UNSUPPORTED_I, (IFR_Int4)getIndex());
        DBUG_RETURN(IFR_NOT_OK);
    }
}


