/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.resolvers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractResolveMojo;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactsFilter;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;

public class ResolvePluginsMojo
extends AbstractResolveMojo {
    private List remotePluginRepositories;
    private boolean excludeTransitive;

    public void execute() throws MojoExecutionException {
        try {
            Set plugins = this.resolvePluginArtifacts();
            Iterator i = plugins.iterator();
            while (i.hasNext()) {
                Artifact plugin = (Artifact)i.next();
                if (!this.silent) {
                    this.getLog().info((CharSequence)("Plugin Resolved: " + DependencyUtil.getFormattedFileName(plugin, false)));
                }
                if (this.excludeTransitive) continue;
                Set transitiveDependencies = this.resolveArtifactDependencies(plugin);
                if (this.silent) continue;
                Iterator transIter = transitiveDependencies.iterator();
                while (transIter.hasNext()) {
                    this.getLog().info((CharSequence)("    Plugin Dependency Resolved: " + DependencyUtil.getFormattedFileName((Artifact)transIter.next(), false)));
                }
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Nested:", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Nested:", (Exception)((Object)e));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Nested:", (Exception)((Object)e));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException("Nested:", (Exception)((Object)e));
        }
    }

    protected Set resolvePluginArtifacts() throws ArtifactResolutionException, ArtifactNotFoundException {
        Set plugins = this.project.getPluginArtifacts();
        Set reports = this.project.getReportArtifacts();
        HashSet artifacts = new HashSet();
        artifacts.addAll(reports);
        artifacts.addAll(plugins);
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.resolver.resolve(artifact, this.remotePluginRepositories, this.local);
        }
        return artifacts;
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }
}

