/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.dependency.AnalyzeDepMgt;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public class AnalyzeMojo
extends AbstractMojo {
    private MavenProject project;
    private boolean failBuild = false;
    private boolean displayUsed = false;
    private ProjectDependencyAnalyzer analyzer;
    private boolean ignoreDirect = true;
    private boolean ignoreNonCompile = true;
    private boolean outputXML = true;
    private boolean scriptableOutput = false;
    private String scriptableFlag;
    private File baseDir;
    protected File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping pom project");
            return;
        }
        if (this.outputDirectory == null || !this.outputDirectory.exists()) {
            this.getLog().info((CharSequence)"Skipping project with no Target directory");
            return;
        }
        boolean result = this.checkDependencies();
        if (result && this.failBuild) {
            throw new MojoExecutionException("Found Dependency errors.");
        }
        AnalyzeDepMgt adm = new AnalyzeDepMgt();
        adm.setLog(this.getLog());
        adm.setProject(this.project);
        adm.setFailBuild(this.failBuild);
        adm.setPluginContext(this.getPluginContext());
        adm.setIgnoreDirect(this.ignoreDirect);
        adm.execute();
    }

    private boolean checkDependencies() throws MojoExecutionException {
        boolean result = false;
        try {
            ProjectDependencyAnalysis analysis = this.analyzer.analyze(this.project);
            if (this.displayUsed) {
                this.getLog().info((CharSequence)"Used declared dependencies:");
                this.logArtifacts(analysis.getUsedDeclaredArtifacts(), false);
            }
            this.getLog().info((CharSequence)"Used undeclared dependencies:");
            Set usedUndeclared = analysis.getUsedUndeclaredArtifacts();
            this.logArtifacts(usedUndeclared, true);
            this.getLog().info((CharSequence)"Unused declared dependencies:");
            Set unusedDeclared = analysis.getUnusedDeclaredArtifacts();
            if (this.ignoreNonCompile) {
                Iterator iter = unusedDeclared.iterator();
                while (iter.hasNext()) {
                    Artifact artifact = (Artifact)iter.next();
                    if (artifact.getScope().equals("compile")) continue;
                    iter.remove();
                }
            }
            this.logArtifacts(unusedDeclared, false);
            if (this.outputXML) {
                this.writeDependencyXML(usedUndeclared);
            }
            if (this.scriptableOutput) {
                this.writeScriptableOutput(usedUndeclared);
            }
            if (usedUndeclared != null && !usedUndeclared.isEmpty() || unusedDeclared != null && !unusedDeclared.isEmpty()) {
                this.getLog().warn((CharSequence)"Potential problems discovered.");
                result = true;
            }
        }
        catch (ProjectDependencyAnalyzerException exception) {
            throw new MojoExecutionException("Cannot analyze dependencies", (Exception)((Object)exception));
        }
        return result;
    }

    private void logArtifacts(Set artifacts, boolean warn) {
        if (artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"   None");
        } else {
            Iterator iterator = artifacts.iterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                artifact.isSnapshot();
                if (warn) {
                    this.getLog().warn((CharSequence)("   " + artifact));
                    continue;
                }
                this.getLog().info((CharSequence)("   " + artifact));
            }
        }
    }

    private void writeDependencyXML(Set artifacts) {
        if (!artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Add the following to your pom to correct the missing dependencies: ");
            StringWriter out = new StringWriter();
            PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)out);
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                artifact.isSnapshot();
                writer.startElement("dependency");
                writer.startElement("groupId");
                writer.writeText(artifact.getGroupId());
                writer.endElement();
                writer.startElement("artifactId");
                writer.writeText(artifact.getArtifactId());
                writer.endElement();
                writer.startElement("version");
                writer.writeText(artifact.getBaseVersion());
                writer.endElement();
                if (!"compile".equals(artifact.getScope())) {
                    writer.startElement("scope");
                    writer.writeText(artifact.getScope());
                    writer.endElement();
                }
                writer.endElement();
            }
            this.getLog().info((CharSequence)("\n" + out.getBuffer()));
        }
    }

    public void writeScriptableOutput(Set artifacts) {
        if (!artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Missing dependencies: ");
            String pomFile = this.baseDir.getAbsolutePath() + File.separatorChar + "pom.xml";
            StringBuffer buf = new StringBuffer();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                artifact.isSnapshot();
                buf.append(this.scriptableFlag + ":" + pomFile + ":" + artifact.getDependencyConflictId() + ":" + artifact.getClassifier() + ":" + artifact.getBaseVersion() + ":" + artifact.getScope() + "\n");
            }
            this.getLog().info((CharSequence)("\n" + buf));
        }
    }
}

