(**************************************************************************)
(*       ___                                                              *)
(*      ||M||                                                             *)
(*      ||A||       A project by Andrea Asperti                           *)
(*      ||T||                                                             *)
(*      ||I||       Developers:                                           *)
(*      ||T||         The HELM team.                                      *)
(*      ||A||         http://helm.cs.unibo.it                             *)
(*      \   /                                                             *)
(*       \ /        This file is distributed under the terms of the       *)
(*        v         GNU General Public License Version 2                  *)
(*                                                                        *)
(**************************************************************************)

include "logic/connectives.ma".
include "properties/relations.ma".

(*
notation "hvbox(a break = \sub \ID b)" non associative with precedence 45
for @{ 'eqID $a $b }.

notation > "hvbox(a break =_\ID b)" non associative with precedence 45
for @{ cic:/matita/logic/equality/eq.ind#xpointer(1/1) ? $a $b }.

interpretation "ID eq" 'eqID x y = (cic:/matita/logic/equality/eq.ind#xpointer(1/1) ? x y).
*)

nrecord setoid : Type[1] ≝
 { carr:> Type[0];
   eq: equivalence_relation carr
 }.

interpretation "setoid eq" 'eq t x y = (eq_rel ? (eq t) x y).

notation > "hvbox(a break =_0 b)" non associative with precedence 45
for @{ eq_rel ? (eq ?) $a $b }.

interpretation "setoid symmetry" 'invert r = (sym ???? r).
notation ".= r" with precedence 50 for @{'trans $r}.
interpretation "trans" 'trans r = (trans ????? r).

nrecord unary_morphism (A,B: setoid) : Type[0] ≝
 { fun1:1> A → B;
   prop1: ∀a,a'. eq ? a a' → eq ? (fun1 a) (fun1 a')
 }.

nrecord binary_morphism (A,B,C:setoid) : Type[0] ≝
 { fun2:2> A → B → C;
   prop2: ∀a,a',b,b'. eq ? a a' → eq ? b b' → eq ? (fun2 a b) (fun2 a' b')
 }.

notation "† c" with precedence 90 for @{'prop1 $c }.
notation "l ‡ r" with precedence 90 for @{'prop2 $l $r }.
notation "#" with precedence 90 for @{'refl}.
interpretation "prop1" 'prop1 c  = (prop1 ????? c).
interpretation "prop2" 'prop2 l r = (prop2 ???????? l r).
interpretation "refl" 'refl = (refl ???).
