// -*- c++ -*-
#ifndef INCLUDED_MATH3D_MROT_H
#define INCLUDED_MATH3D_MROT_H
/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mrot.h,v 1.4 2000/10/09 12:17:54 jeh Exp $
 */

#ifndef INCLUDED_MATH3D_M3D_H
#include <math3d/m3d.h>
#endif

namespace Math3d {
  
  class MQuat;

/**
 * Rotation (axis/angle) class.
 */
  class _CCMATH3D MRot {
    private:
      M3d d_axis;
      double d_angle;
    public:
      MRot();
      MRot(const M3d& axis, double angle);
      MRot(const MQuat& quat);
      MRot(const MRot& rot);
      const MRot& operator=(const MRot& rot);
      
      void set(double x, double y, double z, double angle);
      void set(const M3d& axis, double angle);
      void set(const MQuat& quat);
      void copy(const MRot& rot);

      const M3d& axis() const {return(d_axis);}
      double angle() const {return(d_angle);}
      MQuat quat() const;
      
      bool operator==(const MRot& q) const;
      bool operator!=(const MRot& q) const;
      bool cmp(const MRot& rot, double epsilon=EPSILON) const;
  };

}
#endif // INCLUDED_MATH3D_MROT_H


