/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

/*
  $Id: base_client.c,v 1.22 2002/03/08 01:17:08 mallum Exp $
*/


#include "base_client.h"


/* Sets what the client wants */
Client* base_client_new(wm *w, Window win)
{
   XWindowAttributes attr;
   long icccm_mask;
   char *tmp_name = NULL;
   client *p;
   client *c = NULL;
   int i = 0, max = 0;
   
   c = malloc(sizeof(client));
   
   c->type = mainwin; /* start off with common case */
   

   XFetchName(w->dpy, win, &c->name);
   if (c->name == NULL) {
       XStoreName(w->dpy, win, "<unnamed>");
       XFetchName(w->dpy, win, &c->name);
       if (c->name == NULL) c->name = "<unnamed>";
   }

   /* If window name already exists, rename, adding <%i> to it */
   if (w->head_client)
   {
      START_CLIENT_LOOP(w,p);
      dbg("checking %s, %s", p->name, c->name); 
      if (strncmp(p->name, c->name, strlen(c->name)) == 0)
	 {
	    if (strcmp(p->name, c->name) == 0)
	    {
	       if (!max) max = 1;
	    } else {
	       i = atoi(p->name+strlen(c->name)+2);
	       if (i > max) max = i;
	    }
	 }
      END_CLIENT_LOOP(w,p);

      if (max)
      {
	 tmp_name = malloc(sizeof(char) * (strlen(c->name) + 7));
	 sprintf(tmp_name, "%s <%i>", c->name, ++max);
	 XStoreName(w->dpy, win, tmp_name);
	 XFetchName(w->dpy, win, &c->name);
      }
   }
   
   XGetWindowAttributes(w->dpy, win, &attr);
  
   c->window = win;
   c->ignore_unmap = 0;

   c->shaded = 0; 	    /* togo - use iconic / normal states instead */
   c->x = 0;
   c->y = 0;
  
   c->cmap = attr.colormap;

   /* Get size hints */
   c->size = XAllocSizeHints();
   if ( !XGetWMNormalHints(w->dpy, c->window, c->size, &icccm_mask) )
   {
      c->width = attr.width;
      c->height = attr.height;
   } else {
      if (c->size->flags &  PMinSize) {
	 c->width  = c->size->min_width;
	 c->height = c->size->min_height;
      }
      else if (c->size->flags & PBaseSize) {
	 c->width  = c->size->base_width;
	 c->height = c->size->base_height;
      } else {
	 c->width = attr.width;
	 c->height = attr.height;
      }
   }

   /* Set up the 'methods' - expect to be overidden */
   base_client_set_funcs(c);
   
   c->wm = w;

   /* Add the client to the circular list */
   if (w->head_client == NULL)
   {
      c->next = c;
      c->prev = c;
   }
   else
   {
      if (w->main_client)
      {
	 c->prev = w->main_client;
	 c->next = w->main_client->next;
      } else {
	 c->prev = w->head_client;
	 c->next = w->head_client->next;
      }	    
      c->prev->next = c;
      c->next->prev = c;
   }
   w->head_client = c;

   c->backing = (Pixmap)NULL;

   return c;
}

void
base_client_set_funcs(Client *c)
{
   c->configure    = &base_client_configure;
   c->reparent     = &base_client_reparent;
   c->redraw       = &base_client_redraw;
   c->button_press = &base_client_button_press;
   c->get_coverage = &base_client_get_coverage;
   c->move_resize  = &base_client_move_resize;
   c->hide         = &base_client_hide;
   c->show         = &base_client_show;
   c->destroy      = &base_client_destroy;
}

/* This will set the window attributes to what _we_ want */
void
base_client_configure(Client *c)
{
   ;
}

/* Frame the window if needed */
void
base_client_reparent(Client *c)
{
   ;
}


/* redraw the clients frame */
void
base_client_redraw(Client *c, Bool use_cache)
{
   ;
}


/* button press on frame */
void
base_client_button_press(Client *c, XButtonEvent *e)
{
   ;
}


/* move and resize the window */
void
base_client_move_resize(Client *c)
{
   if (c->backing != (Pixmap)NULL)
   {
      XFreePixmap(c->wm->dpy, c->backing);
      c->backing = (Pixmap)NULL;
   }
}


/* return the 'area' covered by the window. Including the frame
   Would return 0 for an unmapped window
*/
void
base_client_get_coverage(Client *c, int *x, int *y, int *w, int *h)
{
   
   ;
}

void
base_client_hide(Client *c)
{
   client *t;

   /* lower any transients 
   for(t = c->prev; t != c; t = t->prev)
      if (t->type == dialog && t->trans == c->window && t->mapped)
	 XMapRaised(c->wm->dpy, t->frame);
   */
   for(t = c->prev; t != c; t = t->prev)
   {
      /* lower any transients */
      if (t->type == dialog && t->trans == c && t->mapped)
	 t->hide(t);
   } 
}

void
base_client_show(Client *c)
{
   client *t;

   dbg("base show(): checking for transients etc..");
   for(t = c->prev; t != c; t = t->prev)
   {
      switch (t->type)
      {
	 case dialog:    /* raise any transients */
	    dbg("found a transient %s %i", t->name, t->mapped);
	    if ((t->trans == c) && t->mapped)
	    {
	       dbg("TRANSIENT: raising %s", t->name);
	       t->show(t);
	    }
	    /* raise any toolbar transients */
	    else if (c->type != toolbar
		     && t->trans->type == toolbar
		     && client_get_state(t->trans) == NormalState)
	       t->show(t);
	    break;
	 case detached: /* detatched always on top */
	    t->show(t);
	 case toolbar:
	 case override:
	 case docked:
	 case menu:
	 case mainwin:
	    break;
      }
   }
}

void /* cb for this needed, or let wm handle it */
base_client_destroy(Client *c)
{
   /* Free its memory + remove from list */

   client *t;

   /* destroy any transients */
   for(t = c->prev; t != c; t = t->prev)
      if (t->type == dialog && t->trans == c)
	 t->destroy(t);
   
   XUnmapWindow(c->wm->dpy, c->window);

   dbg("base_client destroy called");
    
    /* remove from circular list */
    if (c->prev != c)
    {
       if (c->wm->head_client == c) 
	  c->wm->head_client = c->next;
       if (c->prev != NULL) c->prev->next = c->next;
       if (c->next != NULL) c->next->prev = c->prev;
    } else {
       c->wm->head_client = NULL;
       if (c->type == mainwin) c->wm->main_client = NULL;
    }
    
#ifdef USE_XFT
    // XftDrawDestroy(c->xftdraw); /* TODO: why does this segfault ? */
#endif
    if (c->type != menu)
       XRemoveFromSaveSet(c->wm->dpy, c->window);

    if (c->backing != (Pixmap)NULL) XFreePixmap(c->wm->dpy, c->backing);
    if (c->frame != c->window) XDestroyWindow(c->wm->dpy, c->frame);
    if (c->name) XFree(c->name);
    if (c->size) XFree(c->size);

    free(c);
}



