/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _MAS_DPI_H
#define _MAS_DPI_H

/***********************************************************************
 * mas_dpi.h
 *
 * Device Programmer's Interface
 *
 * These symbols are exported to MAS device libraries.
 *
 ***********************************************************************/

#include "mas/mas_constants.h"
#include "mas/mas_types.h"
#include "mas/mas_error.h"
#include "mas/mas_misc.h"
#include "mas/mas_common.h"


#define MASD_GET_STATE(x,y)  masd_get_state(x, (void**)&y);
#define MASD_INIT_STATE(x,y)  y = MAS_NEW(y); \
                              if ( y == 0 ) return mas_error(MERR_MEMORY); \
                              masd_set_state(x, y);


struct masd_dynport
{
    char   name[MAX_PORT_NAME_LENGTH];
    struct masd_dynport* next;
    struct masd_dynport* prev;
};

struct masd_dynport_pool
{
    int32 ports;
    int32 ctr;
    struct masd_dynport* head;
};


extern struct mas_pc *masd_get_pc(void);
extern int32 masd_get_data  ( int32 portnum, struct mas_data** data );
extern int32 masd_post_data ( int32 portnum, struct mas_data* data );
extern int32 masd_get_port_by_name  ( int32 device_instance, char* name,
				      int32* retval_portnum ); 
extern int32 masd_get_cmatrix_from_name(int32 device_instance, 
					char* cmatrix_name, 
					struct mas_characteristic_matrix** 
					retval_cmatrix );
extern int32 masd_set_port_name(int32 portnum, char* name);
extern int32 masd_set_port_type(int32 portnum, int16 type);
extern int32 masd_set_port_cmatrix(int32 portnum, struct mas_characteristic_matrix* cmatrix);
extern int32 masd_get_port_name(int32 portnum, char **retval_name);
extern int32 masd_get_port_type(int32 portnum, int16 *type);
extern int32 masd_get_port_cmatrix(int32 portnum, struct mas_characteristic_matrix **cmatrix);
extern int32 masd_reaction_queue_action(int32 reaction_portnum, 
					int32 target_device_instance, 
					const char* action_name, 
					void* predicate, int32 predicate_len,
					uint32 secs, uint32 frac, 
					int time_is_rel,
					int priority, uint32 period, 
					int32 num_port_dependencies, 
					int32* port_dependencies);
extern int32 masd_reaction_queue_action_simple(int32 reaction_portnum,
					       int32 target_device_instance,
					       char* action_name, 
					       void* predicate, 
					       int32 predicate_len );
extern int32 masd_reaction_queue_event( int32 reaction_portnum, 
					struct mas_event* event );
extern int32 masd_reaction_queue_action_simple_dep(int32 reaction_portnum,
						   int32 target_device_instance,
						   char* action_name,
						   void* predicate, 
						   int32 predicate_len,
						   int32 num_port_dependencies,
						   int32* port_dependencies );
extern int32 masd_reaction_queue_response(int32 reaction_portnum, 
					  void* response, 
					  int32 response_len);
extern int32 masd_reaction_queue_periodic(int32 reaction_portnum, int32 target_device_instance, const char* action_name, void* predicate, int32 predicate_len, int priority, uint32 period, int32 clkid );
extern int32 masd_get_state( int32 device_instance, void** retval_state );
extern int32 masd_set_state( int32 device_instance, void* state );
extern int32 masd_init_dynport_pool( struct masd_dynport_pool* dp_pool, int32 device_instance, int32 reactioon, int32 num );
extern int32 masd_set_dynport_pool_size( struct masd_dynport_pool* dp_pool, int32 device_instance, int32 reaction, int32 num );
extern int32 masd_get_dynport( struct masd_dynport_pool* dp_pool, int32 device_instance, int32 reaction, int32* retval_portnum);
extern int32 masd_cleanup_dynport_pool( struct masd_dynport_pool* dp_pool, int32 device_instance, int32 reaction );
extern int32 masd_recycle_dynport( struct masd_dynport_pool* dp_pool, int32 device_instance, int32 reaction, int32 portnum );
extern int32 masd_get_data_characteristic (int32 portnum, 
					   struct mas_data_characteristic** dc );
extern int32 masd_set_data_characteristic (int32 portnum,
                                           struct mas_data_characteristic* dc );
extern int32 masd_get_device_by_name(char* name, int32*
				     retval_device_instance);
extern int32 masd_get_pre( void* predicate, int32* retport_r, char** key_r, struct mas_package* arg_r );
extern int32 masd_get_post( int32 reaction, int32 retport, char* key, struct mas_package* arg,  struct mas_package* r_package );
extern int32 masd_set_pre( void* predicate, char** key_r, struct mas_package* arg_r );
extern int32 masd_set_post( char* key, struct mas_package* arg );
extern int32 masd_mc_val( int id, uint32* retval );
extern int32 masd_mc_match_rate( int rate );
extern int32 masd_mc_rate( int id, double* retrate );
extern int32 masd_sch_action_delta( int32 *delta_ts );
extern int32 masd_error_response( int32 reaction, int32 err );
extern int32 masd_signal_action( int signum, int handle, int32 di, char *action );

#endif /* _MAS_DPI_H */
