/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _MC_H
#define _MC_H

#define MC_RATE_WINDOW_MINUTES   5
#define MC_UPDATE_RATE_PERIOD_MS 5000
#define MC_RATE_WINDOW ( MC_RATE_WINDOW_MINUTES * 60 / ( MC_UPDATE_RATE_PERIOD_MS/1000 ) )
#define MC_RC_WINDOW   ( MC_RATE_WINDOW / 10 )
#define MAS_MC_SYSCLK  0   /* by definition */
#define HALF_UINT32_MAX 2147483647U
#define MC_DEFAULT_VALID_SDEV 1.0E+7
#define MC_MAX_VALID_SDEV     1.0E+6

struct mas_mc_cb
{
    struct mas_mc_clknode* clocks;
    int32 next_clock_id;
};

struct mas_mc_clknode
{
    int32 id;
    double rate; /* the estimated rate of the clock, taken as
                    "correct" values of s.win_rate */
    char name[MAX_MC_CLK_NAME_LENGTH]; /* brief name */
    int32 device_instance; /* device_instance of mas_mc_update action
                            * that updates this clock */

    struct mas_stats s; /* clock statistics - used for rate estimate */
    struct mas_stats rc; /* rate convergence statistics - used to look
                          * at rate of convergence */ 
    
    uint32 base_val;
    uint32 base_ts_us;
    uint32 val;    /* synthetic value, computed from win_rate */
/*     uint32 prev_val; */
    uint32 ts_us;  /* timestamp of val */
    
    struct mas_mc_clkval* p_clkval; /* previous valid clkval */
    struct mas_mc_clkval* clkval;   /* current clock value */

    struct mas_mc_clknode* prev; /* other clocks in list */
    struct mas_mc_clknode* next;
};

extern struct mas_mc_cb* mas_mc_init( void );
extern void mas_mc_exit( void );
extern int32 mas_mc_action_handler( struct mas_mc_cb* cb, struct mas_event* event );
extern int32 mas_mc_get_val( struct mas_mc_cb* cb, int32 id, uint32* retval );
extern int32 mas_mc_get_id( struct mas_mc_cb* cb, char* name, int32 device_instance );
extern void mas_mc_print_clocks( struct mas_mc_cb* cb );
extern int32 mas_mc_convert( struct mas_mc_cb* cb, int32 from_id, uint32 from_ts, int32 to_id, uint32* to_ts );
extern int32 mas_mc_match_rate( struct mas_mc_cb* cb, int rate );
extern int32 mas_mc_get_rate( struct mas_mc_cb* cb, int id, double* retrate );
extern char** mas_mc_actions( void );

#endif /* _MC_H */


