/* Placed in the public domain 2001 by Sam Trenholme */

/* Routine which prepares the launch of a detached thread which will
   recursivly look for the DNS name in question
   Input:  id of query, socket of query, sockaddr struct of query,
           js_string with host name they are looking for
   Output: JS_ERROR on error, JS_SUCCESS on success
*/

int launch_thread(int id, int sock,
        struct sockaddr_in client, js_string *query);

/* Populate the main assosciative array (the one where the raw UDP query is
   the key and the value is the answer) with the data from the various
   csv1 files.
   Input: A pointer to the hash to populate, a pointer to the string to
          put an error message in
   Ouput: JS_ERROR on error, -2 on non-fatal error,
          JS_SUCCESS on success
   Global vars used: The kvars and dvars
 */

int populate_main(mhash *maintable, js_string *error);

/* Check to see if the IP in question is a ddip (e.g.
   "<03>127<01>0<01>0<03>1<00>"), and, if so, convert it in to
   a bare A record
   input: Pointer to js_string object with the query
   output: JS_ERROR on fatal error, 0 on non-ddip query,
           JS_SUCCESS if it was a ddip
*/

int ddip_check(int id, int sock, struct sockaddr *from, js_string *query);

/* Convert a domain-name query in to its lower-case equivalent
   Input: Pointer to the js string object with the query
   Output: JS_ERROR on error, JS_SUCCESS on sucess, 0 on
           success if no change was made to the string */

int fold_case(js_string *js);

/* Given a js_string object containing a raw UDP dname followed by a
   16-bit big-endian record type, and the desired new record number for
   that data type, convert the record type to the new number.
   Input: js_string object with raw UDP data, the desired new record type
   Output: JS_ERROR on error, JS_SUCCESS on success */

int change_rtype(js_string *js, int newtype);

/* Add a resource record to the big hash of RRs.
   Input: Pointer to the main table
          Binary form of query (dname followed by two-byte type)
          Answer to query
          Ttl for query in question
          Zone this record is in (to determine whether to flag it as
                                  authoritative or a "glue" record)
          We will do the following to determine if the data is
          authoritative:
          1) If the query is the same as the zone name (for all records)
             then the data is authoritative
          2) If the query is <single label>.<zone.name> (for example:
             If the zone is example.com, then anything.example.com
             fits, but some.thing.example.com does not fit), then
             the data is data for all RR types except NS and SOA.
          3) If this data is authoritative, overwrite any non-authoritative
             data in the database.  If it is authoritative, and authoritative
             data is there, do nothing.

   Output: JS_ERROR on error, JS_SUCCESS on success
*/

int add_rr_to_bighash(mhash *bighash,
                      js_string *query, js_string *data, uint32 ttl,
                      js_string *zone);

/* Make pointers in MX, NS, and CNAME records so we can have A records in the
   AR section (AN section with CNAMEs)
   Input: A pointer to the hash to populate, a pointer to the string to
          put an error message input an error message in
   Output: JS_ERROR on error, -2 on non-fatal error, JS_SUCCESS on success
 */

int add_an(mhash *bighash, js_string *error);

/* Give the RR type and a pointer to a js_string object we will put
   data in, make the corresponding A query for the data in question
   Input:  The query type this is (as an int), a pointer to the
           js string with the answer, a pointer to a js string
           which we will place the corresponding A record in question
   Output: JS_ERROR on fatal error, otherwise JS_SUCCESS
*/

int answer_ip_query(int qtype, js_string *qu, js_string *ar);

/* Given a js_string object containing a raw UDP dname followed by a
   16-bit big-endian record type, get the query type for the string in
   question.
   Input: js_string object with raw UDP data
   Output: JS_ERROR on error, record type (0-65535) on success */

int get_rtype(js_string *js);

/* Given a query, a record type to query, and whether we have
 * already found a record in question, do an ANY lookup for
 * the query in question */

int starwhitis_seek_any(js_string *query, int rr_type, int found,
                        q_header *head, rr **w, int *a,
                        js_string *most, js_string *ns, js_string *ar);

