--------------------------------------------------------------------------------
# Introduction

The GATB-CORE project provides a library providing services for genome assembly.

All the needed material is contained in the current directory in order to 
generate the wanted artifacts:  

* dynamic and static libraries holding the services component

* unit tests of the component

* wrappers for the components in other languages like java, python, ... (to be done)

Since the compilation is based on CMake, a common way to build all the artifacts is :

	mkdir build ; cd build ; cmake .. ; make

By default, the library is compiled for supporting 4 ranges of kmers : 

* k1 : for kmerSize < k1  (default value 32)         
* k2 : for k1 <= kmerSize < k2 (default value 64)
* k3 : for k2 <= kmerSize < k3 (default value 96)
* k4 : for k3 <= kmerSize < k4 (default value 128)

You can customize these values through cmake, for instance:

    cmake -Dk1=64 -Dk2=96 -Dk3=128 -Dk4=162 ..

The documentation can be generated by "make doc" and is available at _build/html/index.html_

and the unit tests can be launched by "make test"  (note: you will need to have cppunit for this).
	
--------------------------------------------------------------------------------
# Dependencies

The following third parties should be already installed:

* cmake (mandatory)
* doxygen
* cppunit

--------------------------------------------------------------------------------
# Directory content

* __README__:                  this file

* __CMakeList.txt__:           global cmake file

* __doc__:                 
    * __design__      design documentation for the component
    * __doxygen__     pages for doxygen

* __examples__:       snippets showing how to use the library                 

* __src__:            source code for the component

* __test__:           tests directory
    * __src__         source code for unit tests
    * __db__          FASTA databases for unit tests

* __thirdparty__:    third parties    

--------------------------------------------------------------------------------
# Details for 'src' directory content

It contains several sub directories, each one corresponding to one software package.

A package may be composed of sub packages; the directory hierarchy should represent
this packages tree structure.

For one atomic package (or sub package), we should have:

* directory 'api'       API of the package  

* directory 'impl'      several implementations of the API

--------------------------------------------------------------------------------
# How to quickly create a project based on gatb-core ?

If you want to test gatb-core by creating a new project, you can use the following script:
    sh scripts/NewProject/NewProject.sh  arg1  arg2
where arg1 is the name of the project and arg2 is the directory where the project will be created.

By default, the following part will be included in the project:
    * a README file explaining how to compile the project
    * a 'src' directory holding a default main function
    * a 'thirdparty' holding all the material for building GATB-CORE

The directory where the project is created has no link to any external resources. You can therefore
move it anywhere you want.

Such a project can be a start for building applications based on GATB-CORE. 

----------------------------------------------------------------------------------
# Notes for GATB-core developers

to compile in debug mode, type:

 mkdir build ; cd build && cmake -Ddebug=1 .. && make -j
