#ifndef _SOUNDS_H
#define _SOUNDS_H

#define CHANNEL_BONUS 0
#define CHANNEL_AMBIANT 1
#define CHANNEL_MISC 2
#define CHANNEL_WARNINGS 3

/* MISC SOUNDS */
enum  {
  ARMAGGEDON_PICKED,
  SHOCKWAVE_PICKED,
  HIGHSPEED_PICKED,
  STOPTIME_PICKED,

  S_PLAYER_DIES,
  S_SHMOLLUX_EATEN,
  S_TELEPORT,
  
  S_YOU_WIN,
  S_GAME_OVER,

  S_PROXIMITY_WARNING,

  S_ONE_MINUTE,
  S_COUNTDOWN,

  NUM_MISC_SOUNDS
};

enum
{
  MENU_SOUND_OK,
  MENU_SOUND_BACK,
  MENU_SOUND_ARROW,
  MENU_SOUND_LAUNCH,
  MENU_SOUND_SELECT_SUBMENU,

  NUM_MENU_SOUNDS
};

int load_misc_sounds();
int load_menu_sounds();
int cleanup_menu_sounds();
void play_misc_sound(int which);
void play_menu_sound(int which);
void halt_sounds_on_all_channels();
void play_time_warning_sound(int which);

/* MUSIC */
int load_music();
void play_music();
void stop_music();
void pause_toggle_music();
void cleanup_music();

#endif
