/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>
#include <GL/glu.h>
#include <stdio.h>
#include "geom_bonus.h"

// 8 Verticies
// 4 Texture Coordinates
// 6 Normals
// 12 Triangles

static char face_indicies[12][9] = {

  {0, 2, 3, 0, 0, 0, 0, 1, 2}, {3, 1, 0, 0, 0, 0, 2, 3, 0}, {4, 5, 7, 1, 1,
                                                             1, 3, 0, 1},
  {7, 6, 4, 1, 1, 1, 1, 2, 3}, {0, 1, 5, 2, 2, 2, 3, 0, 1}, {5, 4, 0, 2, 2, 2,
                                                             1, 2, 3},
  {1, 3, 7, 3, 3, 3, 3, 0, 1}, {7, 5, 1, 3, 3, 3, 1, 2, 3}, {3, 2, 6, 4, 4, 4,
                                                             3, 0, 1},
  {6, 7, 3, 4, 4, 4, 1, 2, 3}, {2, 0, 4, 5, 5, 5, 3, 0, 1}, {4, 6, 2, 5, 5, 5,
                                                             1, 2, 3}
};
static GLfloat vertices[8][3] = {

  {-0.275f, -0.275f, -0.275f}, {0.275f, -0.275f, -0.275f}, {-0.275f, 0.275f,
                                                            -0.275f},
  {0.275f, 0.275f, -0.275f}, {-0.275f, -0.275f, 0.275f}, {0.275f, -0.275f,
                                                          0.275f},
  {-0.275f, 0.275f, 0.275f}, {0.275f, 0.275f, 0.275f}
};
static GLfloat normals[6][3] = {
  {0.0f, 0.0f, -1.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, -1.0f, 0.0f},
  {1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}
};
static GLfloat textures[4][2] = {
  {1.0f, 1.0f}, {1.0f, 2.0f}, {0.0f, 2.0f},
  {0.0f, 1.0f}
};

GLint genListeCube()
{
  unsigned int i = 0;
  int j = 0;

  GLint lid = 0;

  lid = glGenLists(1);
  glNewList(lid, GL_COMPILE);

  glBegin(GL_TRIANGLES);
  for (i = 0; i < sizeof(face_indicies) / sizeof(face_indicies[0]); i++)
  {
    for (j = 0; j < 3; j++)
    {
      int vi = face_indicies[i][j];
      int ni = face_indicies[i][j + 3]; // Normal index
      int ti = face_indicies[i][j + 6]; // Texture index

      glNormal3f(normals[ni][0], normals[ni][1], normals[ni][2]);
      glTexCoord2f(textures[ti][0], textures[ti][1]);
      glVertex3f(vertices[vi][0], vertices[vi][1], vertices[vi][2]);
    }
  }
  glEnd();

  glEndList();
  return lid;
}
