/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "mn-sylpheed-mailbox-backend.h"

#include "mn-sylpheed-mailbox-backend-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 29 "mn-sylpheed-mailbox-backend.gob"

#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <glib/gi18n.h>
#include <eel/eel.h>
#include "mn-mailbox-private.h"
#include "mn-reentrant-mailbox-private.h"
#include "mn-vfs-mailbox-backend-private.h"
#include "mn-vfs.h"
#include "mn-util.h"
#include "mn-message-mime.h"

/* taken from procmsg.h in the Sylpheed sources */
#define SYLPHEED_MSG_NEW		(1U << 0)
#define SYLPHEED_MSG_UNREAD		(1U << 1)

/* taken from defs.h in the Sylpheed sources */
#define SYLPHEED_MARK_FILE		".sylpheed_mark"
#define SYLPHEED_MARK_VERSION		2

typedef struct
{
  int		num;
  guint32	flags;
} MarkEntry;

typedef enum
{
  MN_SYLPHEED_MESSAGE_EXISTS		= 1 << 0,
  MN_SYLPHEED_MESSAGE_NEW		= 1 << 1,
  MN_SYLPHEED_MESSAGE_UNREAD		= 1 << 2
} MNSylpheedMessageFlags;

static GStaticMutex timeouts_mutex = G_STATIC_MUTEX_INIT;

#line 63 "mn-sylpheed-mailbox-backend.c"
/* self casting macros */
#define SELF(x) MN_SYLPHEED_MAILBOX_BACKEND(x)
#define SELF_CONST(x) MN_SYLPHEED_MAILBOX_BACKEND_CONST(x)
#define IS_SELF(x) MN_IS_SYLPHEED_MAILBOX_BACKEND(x)
#define TYPE_SELF MN_TYPE_SYLPHEED_MAILBOX_BACKEND
#define SELF_CLASS(x) MN_SYLPHEED_MAILBOX_BACKEND_CLASS(x)

#define SELF_GET_CLASS(x) MN_SYLPHEED_MAILBOX_BACKEND_GET_CLASS(x)

/* self typedefs */
typedef MNSylpheedMailboxBackend Self;
typedef MNSylpheedMailboxBackendClass SelfClass;

/* here are local prototypes */
static void mn_sylpheed_mailbox_backend_init (MNSylpheedMailboxBackend * o) G_GNUC_UNUSED;
static void mn_sylpheed_mailbox_backend_class_init (MNSylpheedMailboxBackendClass * class) G_GNUC_UNUSED;
static GObject * ___2_mn_sylpheed_mailbox_backend_constructor (GType type, unsigned int n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void ___3_mn_sylpheed_mailbox_backend_finalize (GObject * object) G_GNUC_UNUSED;
static void ___4_mn_sylpheed_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend, const char * info_uri, GnomeVFSMonitorEventType event_type) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_monitor_timeout_cb (gpointer data) G_GNUC_UNUSED;
static gboolean ___6_mn_sylpheed_mailbox_backend_is (MNVFSMailboxBackend * dummy, MNVFSMailbox * mailbox) G_GNUC_UNUSED;
static void ___7_mn_sylpheed_mailbox_backend_check (MNVFSMailboxBackend * backend, unsigned long check_id) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_read_local_mark_file (const char * filename, gsize * size, char ** contents, GError ** err) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_read_remote_mark_file (GnomeVFSURI * uri, gsize * size, char ** contents, GError ** err) G_GNUC_UNUSED;
static gboolean mn_sylpheed_mailbox_backend_read_mark_file (MNSylpheedMailboxBackend * self, gsize * size, char ** contents, GError ** err) G_GNUC_UNUSED;
static GHashTable * mn_sylpheed_mailbox_backend_get_message_flags (MNSylpheedMailboxBackend * self, GError ** err) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNVFSMailboxBackendClass *parent_class = NULL;

/* Short form macros */
#define self_monitor_timeout_cb mn_sylpheed_mailbox_backend_monitor_timeout_cb
#define self_read_local_mark_file mn_sylpheed_mailbox_backend_read_local_mark_file
#define self_read_remote_mark_file mn_sylpheed_mailbox_backend_read_remote_mark_file
#define self_read_mark_file mn_sylpheed_mailbox_backend_read_mark_file
#define self_get_message_flags mn_sylpheed_mailbox_backend_get_message_flags
GType
mn_sylpheed_mailbox_backend_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNSylpheedMailboxBackendClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_sylpheed_mailbox_backend_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNSylpheedMailboxBackend),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_sylpheed_mailbox_backend_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_VFS_MAILBOX_BACKEND, "MNSylpheedMailboxBackend", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNSylpheedMailboxBackend *)g_object_new(mn_sylpheed_mailbox_backend_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNSylpheedMailboxBackend * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNSylpheedMailboxBackend *
GET_NEW_VARG (const char *first, ...)
{
	MNSylpheedMailboxBackend *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNSylpheedMailboxBackend *)g_object_new_valist (mn_sylpheed_mailbox_backend_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::finalize"
	MNSylpheedMailboxBackend *self G_GNUC_UNUSED = MN_SYLPHEED_MAILBOX_BACKEND (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 95 "mn-sylpheed-mailbox-backend.gob"
	___3_mn_sylpheed_mailbox_backend_finalize(obj_self);
#line 151 "mn-sylpheed-mailbox-backend.c"
}
#undef __GOB_FUNCTION__

static void 
mn_sylpheed_mailbox_backend_init (MNSylpheedMailboxBackend * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,MN_TYPE_SYLPHEED_MAILBOX_BACKEND,MNSylpheedMailboxBackendPrivate);
}
#undef __GOB_FUNCTION__
#line 73 "mn-sylpheed-mailbox-backend.gob"
static void 
mn_sylpheed_mailbox_backend_class_init (MNSylpheedMailboxBackendClass * class G_GNUC_UNUSED)
#line 165 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;
	MNVFSMailboxBackendClass *mn_vfs_mailbox_backend_class = (MNVFSMailboxBackendClass *)class;

	g_type_class_add_private(class,sizeof(MNSylpheedMailboxBackendPrivate));

	parent_class = g_type_class_ref (MN_TYPE_VFS_MAILBOX_BACKEND);

#line 78 "mn-sylpheed-mailbox-backend.gob"
	g_object_class->constructor = ___2_mn_sylpheed_mailbox_backend_constructor;
#line 95 "mn-sylpheed-mailbox-backend.gob"
	g_object_class->finalize = ___finalize;
#line 110 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->monitor_cb = ___4_mn_sylpheed_mailbox_backend_monitor_cb;
#line 173 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->is = ___6_mn_sylpheed_mailbox_backend_is;
#line 186 "mn-sylpheed-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->check = ___7_mn_sylpheed_mailbox_backend_check;
#line 185 "mn-sylpheed-mailbox-backend.c"
 {
#line 74 "mn-sylpheed-mailbox-backend.gob"

    MN_VFS_MAILBOX_BACKEND_CLASS(class)->format = "Sylpheed";
  
#line 191 "mn-sylpheed-mailbox-backend.c"
 }
}
#undef __GOB_FUNCTION__



#line 78 "mn-sylpheed-mailbox-backend.gob"
static GObject * 
___2_mn_sylpheed_mailbox_backend_constructor (GType type G_GNUC_UNUSED, unsigned int n_construct_properties, GObjectConstructParam * construct_params)
#line 201 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::constructor"
{
#line 80 "mn-sylpheed-mailbox-backend.gob"
	
    GObject *object;
    Self *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

#if WITH_SYLPHEED_LOCKING
    if (gnome_vfs_uri_is_local(MN_VFS_MAILBOX_BACKEND(self)->mailbox->vfs_uri))
      selfp->can_lock_mark_file = TRUE;
#endif

    return object;
  }}
#line 224 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 95 "mn-sylpheed-mailbox-backend.gob"
static void 
___3_mn_sylpheed_mailbox_backend_finalize (GObject * object G_GNUC_UNUSED)
#line 231 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::finalize"
{
#line 97 "mn-sylpheed-mailbox-backend.gob"
	
    Self *self = SELF(object);

    g_static_mutex_lock(&timeouts_mutex);

    if (selfp->monitor_timeout_source)
      mn_locked_g_source_remove(selfp->monitor_timeout_source);

    g_static_mutex_unlock(&timeouts_mutex);

    PARENT_HANDLER(object);
  }}
#line 251 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 110 "mn-sylpheed-mailbox-backend.gob"
static void 
___4_mn_sylpheed_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend G_GNUC_UNUSED, const char * info_uri, GnomeVFSMonitorEventType event_type)
#line 258 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___info_uri,___event_type) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb)(___backend,___info_uri,___event_type); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::monitor_cb"
{
#line 114 "mn-sylpheed-mailbox-backend.gob"
	
    if (event_type == GNOME_VFS_MONITOR_EVENT_CHANGED
	|| event_type == GNOME_VFS_MONITOR_EVENT_DELETED
	|| event_type == GNOME_VFS_MONITOR_EVENT_CREATED)
      {
	char *filename;

	filename = eel_uri_get_basename(info_uri);
	if (filename)
	  {
	    if (! strcmp(filename, SYLPHEED_MARK_FILE))
	      {
		Self *self = SELF(backend);

		if (selfp->can_lock_mark_file)
		  mn_reentrant_mailbox_queue_check(MN_REENTRANT_MAILBOX(backend->mailbox));
		else
		  {
		    /*
		     * We cannot lock the mark file. To avoid races,
		     * delay the check.
		     */

		    /*
		     * We do not need to lock timeouts_mutex, because
		     * this function and monitor_timeout_cb() are
		     * always run in the same thread (from the GLib
		     * main loop).
		     */
		    if (selfp->monitor_timeout_source)
		      mn_locked_g_source_remove(selfp->monitor_timeout_source);

		    selfp->monitor_timeout_source = mn_g_timeout_add_locked(3000,
									    self_monitor_timeout_cb,
									    self,
									    (MNLockFunc) mn_g_static_mutex_lock,
									    (MNUnlockFunc) mn_g_static_mutex_unlock,
									    &timeouts_mutex);
		  }
	      }
	    else if (mn_str_isnumeric(filename))
	      mn_reentrant_mailbox_queue_check(MN_REENTRANT_MAILBOX(backend->mailbox));

	    g_free(filename);
	  }
      }
  }}
#line 313 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 162 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_monitor_timeout_cb (gpointer data)
#line 320 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::monitor_timeout_cb"
{
#line 164 "mn-sylpheed-mailbox-backend.gob"
	
    Self *self = data;

    mn_reentrant_mailbox_queue_check(MN_REENTRANT_MAILBOX(MN_VFS_MAILBOX_BACKEND(self)->mailbox));

    selfp->monitor_timeout_source = NULL;
    return FALSE;		/* remove source */
  }}
#line 333 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 173 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
___6_mn_sylpheed_mailbox_backend_is (MNVFSMailboxBackend * dummy G_GNUC_UNUSED, MNVFSMailbox * mailbox)
#line 339 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___dummy,___mailbox) \
	((MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)? \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)(___dummy,___mailbox): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::is"
{
#line 175 "mn-sylpheed-mailbox-backend.gob"
	
    gboolean is = FALSE;
    GnomeVFSURI *markfile_uri;

    markfile_uri = gnome_vfs_uri_append_file_name(mailbox->vfs_uri, SYLPHEED_MARK_FILE);
    is = mn_vfs_test(markfile_uri, G_FILE_TEST_IS_REGULAR);
    gnome_vfs_uri_unref(markfile_uri);

    return is;
  }}
#line 358 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 186 "mn-sylpheed-mailbox-backend.gob"
static void 
___7_mn_sylpheed_mailbox_backend_check (MNVFSMailboxBackend * backend G_GNUC_UNUSED, unsigned long check_id)
#line 365 "mn-sylpheed-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___check_id) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check)(___backend,___check_id); }
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::check"
{
#line 188 "mn-sylpheed-mailbox-backend.gob"
	
    GError *err = NULL;
    GnomeVFSResult result;
    GnomeVFSResult close_result;
    GnomeVFSDirectoryHandle *handle;
    GnomeVFSFileInfo *file_info;
    GHashTable *message_flags;
    GSList *messages = NULL;

    mn_vfs_mailbox_backend_monitor(backend, check_id, backend->mailbox->uri, GNOME_VFS_MONITOR_DIRECTORY);

    message_flags = self_get_message_flags(SELF(backend), &err);
    if (! message_flags)
      {
	GDK_THREADS_ENTER();

	if (! mn_reentrant_mailbox_check_aborted_unlocked(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to read %s: %s"), SYLPHEED_MARK_FILE, err->message);
	g_error_free(err);

	gdk_flush();
	GDK_THREADS_LEAVE();

	return;
      }

    if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      goto finish;

    result = gnome_vfs_directory_open_from_uri(&handle, backend->mailbox->vfs_uri, GNOME_VFS_FILE_INFO_FOLLOW_LINKS);
    if (result != GNOME_VFS_OK)
      {
	GDK_THREADS_ENTER();

	if (! mn_reentrant_mailbox_check_aborted_unlocked(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to open folder: %s"), gnome_vfs_result_to_string(result));

	gdk_flush();
	GDK_THREADS_LEAVE();

	goto end;
      }

    file_info = gnome_vfs_file_info_new();
    while ((result = gnome_vfs_directory_read_next(handle, file_info)) == GNOME_VFS_OK)
      if (mn_str_isnumeric(file_info->name))
	{
	  int num = atoi(file_info->name);
	  MNSylpheedMessageFlags msflags = GPOINTER_TO_INT(g_hash_table_lookup(message_flags, GINT_TO_POINTER(num)));

	  if ((msflags & MN_SYLPHEED_MESSAGE_EXISTS) == 0
	      || (msflags & MN_SYLPHEED_MESSAGE_NEW) != 0
	      || (msflags & MN_SYLPHEED_MESSAGE_UNREAD) != 0)
	    {
	      MNMessageFlags flags = 0;
	      GnomeVFSURI *message_uri;

	      if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
		break;

	      if ((msflags & MN_SYLPHEED_MESSAGE_EXISTS) == 0
		  || (msflags & MN_SYLPHEED_MESSAGE_NEW) != 0)
		flags |= MN_MESSAGE_NEW;

	      /*
	       * We set handle_status to FALSE, since Sylpheed has its
	       * own way (mark file) of differencing seen/unseen
	       * messages.
	       */

	      message_uri = gnome_vfs_uri_append_file_name(backend->mailbox->vfs_uri, file_info->name);
	      messages = g_slist_prepend(messages, mn_message_new_from_uri(MN_MAILBOX(backend->mailbox), message_uri, flags, FALSE));
	      gnome_vfs_uri_unref(message_uri);
	    }
	}
    gnome_vfs_file_info_unref(file_info);
    close_result = gnome_vfs_directory_close(handle);

  finish:
    GDK_THREADS_ENTER();

    if (! mn_reentrant_mailbox_check_aborted_unlocked(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      {
	if (result == GNOME_VFS_ERROR_EOF || result == GNOME_VFS_OK)
	  {
	    if (close_result == GNOME_VFS_OK)
	      mn_mailbox_set_messages(MN_MAILBOX(backend->mailbox), messages);
	    else
	      mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("unable to close folder: %s"), gnome_vfs_result_to_string(close_result));
	  }
	else
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), _("error while reading folder: %s"), gnome_vfs_result_to_string(result));
      }

    mn_g_object_slist_free(messages);

    gdk_flush();
    GDK_THREADS_LEAVE();

  end:
    g_hash_table_destroy(message_flags);
  }}
#line 475 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 291 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_read_local_mark_file (const char * filename, gsize * size, char ** contents, GError ** err)
#line 482 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_local_mark_file"
#line 291 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (filename != NULL, (gboolean )0);
#line 291 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (size != NULL, (gboolean )0);
#line 291 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (contents != NULL, (gboolean )0);
#line 491 "mn-sylpheed-mailbox-backend.c"
{
#line 296 "mn-sylpheed-mailbox-backend.gob"
	
    int fd;
    struct flock lock;
    GIOChannel *channel;
    GError *tmp_err = NULL;
    gboolean status = FALSE;

    fd = open(filename, O_RDONLY);
    if (fd < 0)
      {
	g_set_error(err, 0, 0, "%s", g_strerror(errno));
	return FALSE;
      }

    /*
     * Even if --enable-sylpheed-locking was not used and we are here
     * after the 3 seconds delay, it does not hurt to obtain a lock,
     * in case the user has a patched Sylpheed but did not use
     * --enable-sylpheed-locking.
     */

    memset(&lock, 0, sizeof(lock));
    lock.l_start = 0;		/* from l_whence */
    lock.l_len = 0;		/* to end of file */
    lock.l_type = F_RDLCK;	/* read lock */
    lock.l_whence = SEEK_SET;	/* from start of file */

    /* ignore lock failures */
    fcntl(fd, F_SETLKW, &lock);

    channel = g_io_channel_unix_new(fd);
    if (g_io_channel_set_encoding(channel, NULL, &tmp_err) == G_IO_STATUS_NORMAL)
      {
	if (g_io_channel_read_to_end(channel, contents, size, err) == G_IO_STATUS_NORMAL)
	  status = TRUE;
      }
    else
      {
	g_set_error(err, 0, 0, "unable to set encoding: %s", tmp_err->message);
	g_error_free(tmp_err);
      }

    g_io_channel_shutdown(channel, FALSE, NULL);
    g_io_channel_unref(channel);

    return status;
  }}
#line 541 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 344 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_read_remote_mark_file (GnomeVFSURI * uri, gsize * size, char ** contents, GError ** err)
#line 547 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_remote_mark_file"
#line 344 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (uri != NULL, (gboolean )0);
#line 344 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (size != NULL, (gboolean )0);
#line 344 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (contents != NULL, (gboolean )0);
#line 556 "mn-sylpheed-mailbox-backend.c"
{
#line 349 "mn-sylpheed-mailbox-backend.gob"
	
    GnomeVFSResult result;
    int _size;

    result = mn_vfs_read_entire_file_uri(uri, &_size, contents);
    if (result == GNOME_VFS_OK)
      {
	*size = _size;
	return TRUE;
      }
    else
      {
	g_set_error(err, 0, 0, "%s", gnome_vfs_result_to_string(result));
	return FALSE;
      }
  }}
#line 575 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 366 "mn-sylpheed-mailbox-backend.gob"
static gboolean 
mn_sylpheed_mailbox_backend_read_mark_file (MNSylpheedMailboxBackend * self, gsize * size, char ** contents, GError ** err)
#line 581 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::read_mark_file"
#line 366 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 366 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (MN_IS_SYLPHEED_MAILBOX_BACKEND (self), (gboolean )0);
#line 366 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (size != NULL, (gboolean )0);
#line 366 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (contents != NULL, (gboolean )0);
#line 592 "mn-sylpheed-mailbox-backend.c"
{
#line 371 "mn-sylpheed-mailbox-backend.gob"
	
    GnomeVFSURI *markfile_uri;
    char *filename;
    gboolean status;

    markfile_uri = gnome_vfs_uri_append_file_name(MN_VFS_MAILBOX_BACKEND(self)->mailbox->vfs_uri, SYLPHEED_MARK_FILE);

    filename = mn_vfs_get_local_path(markfile_uri);
    if (filename)
      {
	status = self_read_local_mark_file(filename, size, contents, err);
	g_free(filename);
      }
    else
      status = self_read_remote_mark_file(markfile_uri, size, contents, err);

    gnome_vfs_uri_unref(markfile_uri);

    return status;
  }}
#line 615 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 392 "mn-sylpheed-mailbox-backend.gob"
static GHashTable * 
mn_sylpheed_mailbox_backend_get_message_flags (MNSylpheedMailboxBackend * self, GError ** err)
#line 621 "mn-sylpheed-mailbox-backend.c"
{
#define __GOB_FUNCTION__ "MN:Sylpheed:Mailbox:Backend::get_message_flags"
#line 392 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (self != NULL, (GHashTable * )0);
#line 392 "mn-sylpheed-mailbox-backend.gob"
	g_return_val_if_fail (MN_IS_SYLPHEED_MAILBOX_BACKEND (self), (GHashTable * )0);
#line 628 "mn-sylpheed-mailbox-backend.c"
{
#line 394 "mn-sylpheed-mailbox-backend.gob"
	
    GHashTable *message_flags = NULL;
    gsize bytes_left;
    char *buf;

    if (self_read_mark_file(self, &bytes_left, &buf, err))
      {
	if (bytes_left >= sizeof(int))
	  {
	    int version = *((int *) buf);

	    if (version == SYLPHEED_MARK_VERSION)
	      {
		MarkEntry *entry;

		entry = (MarkEntry *) (buf + sizeof(int));
		bytes_left -= sizeof(int);

		message_flags = g_hash_table_new(g_direct_hash, g_direct_equal);

		while (bytes_left > 0)
		  {
		    MNSylpheedMessageFlags flags = MN_SYLPHEED_MESSAGE_EXISTS;

		    if (bytes_left < sizeof(MarkEntry))
		      {
			g_set_error(err, 0, 0, _("unexpected end of file"));
			g_hash_table_destroy(message_flags);
			message_flags = NULL;
			break;
		      }

		    if ((entry->flags & SYLPHEED_MSG_NEW) != 0)
		      flags |= MN_SYLPHEED_MESSAGE_NEW;
		    if ((entry->flags & SYLPHEED_MSG_UNREAD) != 0)
		      flags |= MN_SYLPHEED_MESSAGE_UNREAD;

		    g_hash_table_insert(message_flags, GINT_TO_POINTER(entry->num), GINT_TO_POINTER(flags));

		    entry++;
		    bytes_left -= sizeof(MarkEntry);
		  }
	      }
	    else
	      g_set_error(err, 0, 0, _("incompatible file version \"%i\""), version);
	  }
	else
	  g_set_error(err, 0, 0, _("file version missing"));

	g_free(buf);
      }

    return message_flags;
  }}
#line 685 "mn-sylpheed-mailbox-backend.c"
#undef __GOB_FUNCTION__
