/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include "mn-mailbox-view.h"

#include "mn-mailbox-view-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 25 "mn-mailbox-view.gob"

#include "config.h"
#include <string.h>
#include <glib/gi18n.h>
#include <gdk/gdkkeysyms.h>
#include "mn-util.h"
#include "mn-shell.h"
#include "mn-stock.h"
#include "mn-mailbox-properties-dialog.h"
#include "mn-conf.h"
#include "mn-mailbox.h"
#include "nautilus-cell-renderer-pixbuf-emblem.h"

enum
{
  COLUMN_MAILBOX,
  COLUMN_ICON,
  COLUMN_EMBLEM,
  COLUMN_PIXBUF,
  COLUMN_LABEL,
  COLUMN_RAW_LABEL,
  N_COLUMNS
};

enum
{
  TARGET_MAILBOXES,
  TARGET_GNOME_COPIED_FILES,
  N_TARGETS
};

typedef struct
{
  gboolean has_polled;
  gboolean has_selection;
} SensitivityInfo;

static struct
{
  char		*name;
  GdkAtom	atom;
} clipboard_info[N_TARGETS] = {
  { "x-special/mail-notification-mailboxes" },
  { "x-special/gnome-copied-files" }
};

static GtkClipboard *global_clipboard;

#line 73 "mn-mailbox-view.c"
/* self casting macros */
#define SELF(x) MN_MAILBOX_VIEW(x)
#define SELF_CONST(x) MN_MAILBOX_VIEW_CONST(x)
#define IS_SELF(x) MN_IS_MAILBOX_VIEW(x)
#define TYPE_SELF MN_TYPE_MAILBOX_VIEW
#define SELF_CLASS(x) MN_MAILBOX_VIEW_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILBOX_VIEW_GET_CLASS(x)

/* self typedefs */
typedef MNMailboxView Self;
typedef MNMailboxViewClass SelfClass;

/* here are local prototypes */
static void ___real_mn_mailbox_view_activate_update (MNMailboxView * self);
static void mn_mailbox_view_activate_update_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data) G_GNUC_UNUSED;
static void ___real_mn_mailbox_view_activate_properties (MNMailboxView * self);
static void mn_mailbox_view_activate_properties_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data) G_GNUC_UNUSED;
static void ___real_mn_mailbox_view_activate_add (MNMailboxView * self);
static void ___real_mn_mailbox_view_activate_remove (MNMailboxView * self);
static void ___real_mn_mailbox_view_activate_cut (MNMailboxView * self);
static void ___real_mn_mailbox_view_activate_copy (MNMailboxView * self);
static void ___real_mn_mailbox_view_activate_paste (MNMailboxView * self);
static void mn_mailbox_view_class_init (MNMailboxViewClass * class) G_GNUC_UNUSED;
static void mn_mailbox_view_init (MNMailboxView * self) G_GNUC_UNUSED;
static int mn_mailbox_view_sort_cb (GtkTreeModel * model, GtkTreeIter * a, GtkTreeIter * b, gpointer user_data) G_GNUC_UNUSED;
static gboolean mn_mailbox_view_search_equal_cb (GtkTreeModel * model, int column, const char * key, GtkTreeIter * iter, gpointer search_data) G_GNUC_UNUSED;
static void mn_mailbox_view_append (MNMailboxView * self, MNMailbox * mailbox) G_GNUC_UNUSED;
static void mn_mailbox_view_mailbox_added_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailbox_view_mailbox_notify_h (MNMailboxes * mailboxes, MNMailbox * mailbox, GParamSpec * pspec, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailbox_view_mailbox_removed_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailbox_view_update_iter (MNMailboxView * self, GtkTreeIter * iter, MNMailbox * mailbox) G_GNUC_UNUSED;
static gboolean mn_mailbox_view_find_mailbox (MNMailboxView * self, MNMailbox * mailbox, GtkTreeIter * iter) G_GNUC_UNUSED;
static void mn_mailbox_view_update_sensitivity (MNMailboxView * self) G_GNUC_UNUSED;
static void mn_mailbox_view_update_sensitivity_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data) G_GNUC_UNUSED;
static void mn_mailbox_view_remove_mailbox (MNMailboxView * self) G_GNUC_UNUSED;
static void mn_mailbox_view_remove_mailbox_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data) G_GNUC_UNUSED;
static void mn_mailbox_view_copy_mailbox (MNMailboxView * self) G_GNUC_UNUSED;
static void mn_mailbox_view_copy_mailbox_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data) G_GNUC_UNUSED;
static void mn_mailbox_view_get_clipboard_cb (GtkClipboard * clipboard, GtkSelectionData * selection_data, unsigned int info, gpointer user_data_or_owner) G_GNUC_UNUSED;
static void mn_mailbox_view_clear_clipboard_cb (GtkClipboard * clipboard, gpointer user_data_or_owner) G_GNUC_UNUSED;
static void mn_mailbox_view_select_all (MNMailboxView * self) G_GNUC_UNUSED;
static void mn_mailbox_view_properties_add_response_h (GtkDialog * dialog, int response, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailbox_view_properties_edit_response_h (GtkDialog * dialog, int response, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailbox_view_popup_menu (MNMailboxView * self, unsigned int button, guint32 activate_time) G_GNUC_UNUSED;
static void mn_mailbox_view_popup_menu_targets_received_cb (GtkClipboard * clipboard, GdkAtom * atoms, int n_atoms, gpointer data) G_GNUC_UNUSED;
static gboolean mn_mailbox_view_popup_menu_h (GtkWidget * widget, gpointer user_data) G_GNUC_UNUSED;
static gboolean mn_mailbox_view_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data) G_GNUC_UNUSED;
static void mn_mailbox_view_row_activated_h (GtkTreeView * treeview, GtkTreePath * path, GtkTreeViewColumn * column, gpointer user_data) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__activate_update(object,func,data)	mn_mailbox_view_connect__activate_update((object),(func),(data))
#define self_connect_after__activate_update(object,func,data)	mn_mailbox_view_connect_after__activate_update((object),(func),(data))
#define self_connect_data__activate_update(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_update((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_properties(object,func,data)	mn_mailbox_view_connect__activate_properties((object),(func),(data))
#define self_connect_after__activate_properties(object,func,data)	mn_mailbox_view_connect_after__activate_properties((object),(func),(data))
#define self_connect_data__activate_properties(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_properties((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_add(object,func,data)	mn_mailbox_view_connect__activate_add((object),(func),(data))
#define self_connect_after__activate_add(object,func,data)	mn_mailbox_view_connect_after__activate_add((object),(func),(data))
#define self_connect_data__activate_add(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_add((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_remove(object,func,data)	mn_mailbox_view_connect__activate_remove((object),(func),(data))
#define self_connect_after__activate_remove(object,func,data)	mn_mailbox_view_connect_after__activate_remove((object),(func),(data))
#define self_connect_data__activate_remove(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_remove((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_cut(object,func,data)	mn_mailbox_view_connect__activate_cut((object),(func),(data))
#define self_connect_after__activate_cut(object,func,data)	mn_mailbox_view_connect_after__activate_cut((object),(func),(data))
#define self_connect_data__activate_cut(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_cut((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_copy(object,func,data)	mn_mailbox_view_connect__activate_copy((object),(func),(data))
#define self_connect_after__activate_copy(object,func,data)	mn_mailbox_view_connect_after__activate_copy((object),(func),(data))
#define self_connect_data__activate_copy(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_copy((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_paste(object,func,data)	mn_mailbox_view_connect__activate_paste((object),(func),(data))
#define self_connect_after__activate_paste(object,func,data)	mn_mailbox_view_connect_after__activate_paste((object),(func),(data))
#define self_connect_data__activate_paste(object,func,data,destroy_data,flags)	mn_mailbox_view_connect_data__activate_paste((object),(func),(data),(destroy_data),(flags))

enum {
	ACTIVATE_UPDATE_SIGNAL,
	ACTIVATE_PROPERTIES_SIGNAL,
	ACTIVATE_ADD_SIGNAL,
	ACTIVATE_REMOVE_SIGNAL,
	ACTIVATE_CUT_SIGNAL,
	ACTIVATE_COPY_SIGNAL,
	ACTIVATE_PASTE_SIGNAL,
	LAST_SIGNAL
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkTreeViewClass *parent_class = NULL;

/* Short form macros */
#define self_activate_update mn_mailbox_view_activate_update
#define self_activate_update_cb mn_mailbox_view_activate_update_cb
#define self_activate_properties mn_mailbox_view_activate_properties
#define self_activate_properties_cb mn_mailbox_view_activate_properties_cb
#define self_activate_add mn_mailbox_view_activate_add
#define self_activate_remove mn_mailbox_view_activate_remove
#define self_activate_cut mn_mailbox_view_activate_cut
#define self_activate_copy mn_mailbox_view_activate_copy
#define self_activate_paste mn_mailbox_view_activate_paste
#define self_sort_cb mn_mailbox_view_sort_cb
#define self_search_equal_cb mn_mailbox_view_search_equal_cb
#define self_append mn_mailbox_view_append
#define self_mailbox_added_h mn_mailbox_view_mailbox_added_h
#define self_mailbox_notify_h mn_mailbox_view_mailbox_notify_h
#define self_mailbox_removed_h mn_mailbox_view_mailbox_removed_h
#define self_update_iter mn_mailbox_view_update_iter
#define self_find_mailbox mn_mailbox_view_find_mailbox
#define self_update_sensitivity mn_mailbox_view_update_sensitivity
#define self_update_sensitivity_cb mn_mailbox_view_update_sensitivity_cb
#define self_remove_mailbox mn_mailbox_view_remove_mailbox
#define self_remove_mailbox_cb mn_mailbox_view_remove_mailbox_cb
#define self_copy_mailbox mn_mailbox_view_copy_mailbox
#define self_copy_mailbox_cb mn_mailbox_view_copy_mailbox_cb
#define self_get_clipboard_cb mn_mailbox_view_get_clipboard_cb
#define self_clear_clipboard_cb mn_mailbox_view_clear_clipboard_cb
#define self_select_all mn_mailbox_view_select_all
#define self_properties_add_response_h mn_mailbox_view_properties_add_response_h
#define self_properties_edit_response_h mn_mailbox_view_properties_edit_response_h
#define self_popup_menu mn_mailbox_view_popup_menu
#define self_popup_menu_targets_received_cb mn_mailbox_view_popup_menu_targets_received_cb
#define self_popup_menu_h mn_mailbox_view_popup_menu_h
#define self_button_press_event_h mn_mailbox_view_button_press_event_h
#define self_row_activated_h mn_mailbox_view_row_activated_h
#define self_new mn_mailbox_view_new
GType
mn_mailbox_view_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMailboxViewClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mailbox_view_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMailboxView),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mailbox_view_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_TREE_VIEW, "MNMailboxView", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMailboxView *)g_object_new(mn_mailbox_view_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMailboxView * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMailboxView *
GET_NEW_VARG (const char *first, ...)
{
	MNMailboxView *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMailboxView *)g_object_new_valist (mn_mailbox_view_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::finalize"
	MNMailboxView *self G_GNUC_UNUSED = MN_MAILBOX_VIEW (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 76 "mn-mailbox-view.gob"
	if(self->_priv->menu) { gtk_widget_destroy ((gpointer) self->_priv->menu); self->_priv->menu = NULL; }
#line 253 "mn-mailbox-view.c"
}
#undef __GOB_FUNCTION__

#line 261 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_class_init (MNMailboxViewClass * class G_GNUC_UNUSED)
#line 260 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;

	g_type_class_add_private(class,sizeof(MNMailboxViewPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_TREE_VIEW);

	object_signals[ACTIVATE_UPDATE_SIGNAL] =
		g_signal_new ("activate_update",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_update),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_PROPERTIES_SIGNAL] =
		g_signal_new ("activate_properties",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_properties),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_ADD_SIGNAL] =
		g_signal_new ("activate_add",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_add),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_REMOVE_SIGNAL] =
		g_signal_new ("activate_remove",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_remove),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_CUT_SIGNAL] =
		g_signal_new ("activate_cut",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_cut),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_COPY_SIGNAL] =
		g_signal_new ("activate_copy",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_copy),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_PASTE_SIGNAL] =
		g_signal_new ("activate_paste",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (MNMailboxViewClass, activate_paste),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

#line 84 "mn-mailbox-view.gob"
	class->activate_update = ___real_mn_mailbox_view_activate_update;
#line 106 "mn-mailbox-view.gob"
	class->activate_properties = ___real_mn_mailbox_view_activate_properties;
#line 146 "mn-mailbox-view.gob"
	class->activate_add = ___real_mn_mailbox_view_activate_add;
#line 161 "mn-mailbox-view.gob"
	class->activate_remove = ___real_mn_mailbox_view_activate_remove;
#line 167 "mn-mailbox-view.gob"
	class->activate_cut = ___real_mn_mailbox_view_activate_cut;
#line 174 "mn-mailbox-view.gob"
	class->activate_copy = ___real_mn_mailbox_view_activate_copy;
#line 180 "mn-mailbox-view.gob"
	class->activate_paste = ___real_mn_mailbox_view_activate_paste;
#line 340 "mn-mailbox-view.c"
	g_object_class->finalize = ___finalize;
 {
#line 262 "mn-mailbox-view.gob"

    GtkBindingSet *binding_set;
    int i;

    global_clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);

    for (i = 0; i < N_TARGETS; i++)
      clipboard_info[i].atom = gdk_atom_intern(clipboard_info[i].name, FALSE);

    binding_set = gtk_binding_set_by_class(class);

    /* Delete removes a row */
    gtk_binding_entry_add_signal(binding_set, GDK_Delete, 0, "activate-remove", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Delete, 0, "activate-remove", 0);

    /* HIG 2.0 cut/copy/paste shortcuts */
    gtk_binding_entry_add_signal(binding_set, GDK_x, GDK_CONTROL_MASK, "activate-cut", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_c, GDK_CONTROL_MASK, "activate-copy", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_v, GDK_CONTROL_MASK, "activate-paste", 0);

    /* cut/copy/paste shortcuts taken from gtkentry.c */
    gtk_binding_entry_add_signal(binding_set, GDK_Delete, GDK_SHIFT_MASK, "activate-cut", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_Insert, GDK_CONTROL_MASK, "activate-copy", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_Insert, GDK_SHIFT_MASK, "activate-paste", 0);

    /* HIG 2.0 properties */
    gtk_binding_entry_add_signal(binding_set, GDK_Return, GDK_MOD1_MASK, "activate-properties", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_ISO_Enter, GDK_MOD1_MASK, "activate-properties", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Enter, GDK_MOD1_MASK, "activate-properties", 0);
  
#line 374 "mn-mailbox-view.c"
 }
}
#undef __GOB_FUNCTION__
#line 293 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_init (MNMailboxView * self G_GNUC_UNUSED)
#line 381 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_MAILBOX_VIEW,MNMailboxViewPrivate);
#line 76 "mn-mailbox-view.gob"
	self->_priv->menu = gtk_menu_new();
#line 387 "mn-mailbox-view.c"
 {
#line 294 "mn-mailbox-view.gob"

    GtkMenuShell *shell;
    GtkWidget *add_item;
    GtkWidget *select_all_item;
    GtkListStore *store;
    GtkTreeViewColumn *column;
    GtkCellRenderer *renderer;
    GtkTreeSelection *selection;
    GList *l;

    /* popup menu */

    shell = GTK_MENU_SHELL(selfp->menu);

    /* ordered according to chapter 4 of the HIG */

    selfp->properties_item = mn_menu_shell_append(shell, GTK_STOCK_PROPERTIES, NULL);
    /* translators: header capitalization */
    selfp->update_item = mn_menu_shell_append(shell, GTK_STOCK_REFRESH, _("_Update"));
    mn_menu_shell_append(shell, NULL, NULL);
    add_item = mn_menu_shell_append(shell, GTK_STOCK_ADD, NULL);
    selfp->remove_item = mn_menu_shell_append(shell, GTK_STOCK_REMOVE, NULL);
    mn_menu_shell_append(shell, NULL, NULL);
    selfp->cut_item = mn_menu_shell_append(shell, GTK_STOCK_CUT, NULL);
    selfp->copy_item = mn_menu_shell_append(shell, GTK_STOCK_COPY, NULL);
    selfp->paste_item = mn_menu_shell_append(shell, GTK_STOCK_PASTE, NULL);
    mn_menu_shell_append(shell, NULL, NULL);
    select_all_item = mn_menu_shell_append(shell, MN_STOCK_SELECT_ALL, NULL);

    g_signal_connect_swapped(selfp->properties_item, "activate", G_CALLBACK(self_activate_properties), self);
    g_signal_connect_swapped(selfp->update_item, "activate", G_CALLBACK(self_activate_update), self);
    g_signal_connect_swapped(add_item, "activate", G_CALLBACK(self_activate_add), self);
    g_signal_connect_swapped(selfp->remove_item, "activate", G_CALLBACK(self_activate_remove), self);
    g_signal_connect_swapped(selfp->cut_item, "activate", G_CALLBACK(self_activate_cut), self);
    g_signal_connect_swapped(selfp->copy_item, "activate", G_CALLBACK(self_activate_copy), self);
    g_signal_connect_swapped(selfp->paste_item, "activate", G_CALLBACK(self_activate_paste), self);
    g_signal_connect_swapped(select_all_item, "activate", G_CALLBACK(self_select_all), self);

    /* store */

    store = gtk_list_store_new(N_COLUMNS,
			       MN_TYPE_MAILBOX,
			       G_TYPE_STRING,
			       GDK_TYPE_PIXBUF,
			       GDK_TYPE_PIXBUF,
			       G_TYPE_STRING,
			       G_TYPE_STRING);

    gtk_tree_sortable_set_default_sort_func(GTK_TREE_SORTABLE(store),
					    self_sort_cb,
					    NULL,
					    NULL);
    gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(store),
					 GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,
					 GTK_SORT_ASCENDING);

    gtk_tree_view_set_model(GTK_TREE_VIEW(self), GTK_TREE_MODEL(store));
    g_object_unref(store);

    column = gtk_tree_view_column_new();

    renderer = nautilus_cell_renderer_pixbuf_emblem_new();
    g_object_set(renderer, "stock-size", GTK_ICON_SIZE_LARGE_TOOLBAR, NULL);
    gtk_tree_view_column_pack_start(column, renderer, FALSE);
    gtk_tree_view_column_set_attributes(column, renderer,
					"stock-id", COLUMN_ICON,
					"pixbuf-emblem", COLUMN_EMBLEM,
					"pixbuf", COLUMN_PIXBUF,
					NULL);

    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(column, renderer, TRUE);
    gtk_tree_view_column_add_attribute(column, renderer, "markup", COLUMN_LABEL);

    gtk_tree_view_append_column(GTK_TREE_VIEW(self), column);

    /* misc */

    gtk_tree_view_set_search_column(GTK_TREE_VIEW(self), COLUMN_RAW_LABEL);
    gtk_tree_view_set_search_equal_func(GTK_TREE_VIEW(self), self_search_equal_cb, NULL, NULL);

    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(self), FALSE);

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);

    MN_LIST_FOREACH(l, mn_shell->mailboxes->list)
      self_append(self, l->data);
    self_update_sensitivity(self);

    mn_g_object_connect(self,
			mn_shell->mailboxes,
			"signal::mailbox-added", self_mailbox_added_h, self,
			"signal::mailbox-notify::stock-id", self_mailbox_notify_h, self,
			"signal::mailbox-notify::poll", self_mailbox_notify_h, self,
			"swapped-signal::mailbox-notify::poll", self_update_sensitivity, self,
			"signal::mailbox-notify::format", self_mailbox_notify_h, self,
			"signal::mailbox-notify::error", self_mailbox_notify_h, self,
			"signal::mailbox-removed", self_mailbox_removed_h, self,
			NULL);

    g_signal_connect_swapped(selection, "changed", G_CALLBACK(self_update_sensitivity), self);

    g_object_connect(self,
		     "signal::popup-menu", self_popup_menu_h, NULL,
		     "signal::button-press-event", self_button_press_event_h, NULL,
		     "signal::row-activated", self_row_activated_h, NULL,
		     NULL);
  
#line 499 "mn-mailbox-view.c"
 }
}
#undef __GOB_FUNCTION__

#line 84 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_update (MNMailboxView * self)
#line 507 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 84 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 84 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 519 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_UPDATE_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 84 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_update (MNMailboxView * self G_GNUC_UNUSED)
#line 535 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_update"
{
#line 86 "mn-mailbox-view.gob"
	
    GtkTreeSelection *selection;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_selected_foreach(selection, self_activate_update_cb, self);
  }}
#line 546 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 93 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_activate_update_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
#line 552 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_update_cb"
{
#line 98 "mn-mailbox-view.gob"
	
    MNMailbox *mailbox;

    gtk_tree_model_get(model, iter, COLUMN_MAILBOX, &mailbox, -1);
    mn_mailbox_check(mailbox);
    g_object_unref(mailbox);
  }}
#line 564 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 106 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_properties (MNMailboxView * self)
#line 570 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 106 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 106 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 582 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_PROPERTIES_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 106 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_properties (MNMailboxView * self G_GNUC_UNUSED)
#line 598 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_properties"
{
#line 108 "mn-mailbox-view.gob"
	
    GtkTreeSelection *selection;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_selected_foreach(selection, self_activate_properties_cb, self);
  }}
#line 609 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 115 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_activate_properties_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
#line 615 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_properties_cb"
{
#line 120 "mn-mailbox-view.gob"
	
    Self *self = data;
    MNMailbox *mailbox;
    GtkWidget *dialog;

    gtk_tree_model_get(model, iter, COLUMN_MAILBOX, &mailbox, -1);

    dialog = (GtkWidget *) mn_shell_get_mailbox_properties_dialog(mn_shell, mailbox);
    if (dialog)
      gtk_window_present(GTK_WINDOW(dialog));
    else
      {
	dialog = mn_mailbox_properties_dialog_new(mn_widget_get_parent_window(GTK_WIDGET(self)), mailbox);

	g_signal_connect(dialog,
			 "response",
			 G_CALLBACK(self_properties_edit_response_h),
			 NULL);

	mn_shell_add_mailbox_properties_dialog(mn_shell, MN_MAILBOX_PROPERTIES_DIALOG(dialog));
	gtk_widget_show(dialog);
      }

    g_object_unref(mailbox);
  }}
#line 645 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 146 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_add (MNMailboxView * self)
#line 651 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 146 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 146 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 663 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_ADD_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 146 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_add (MNMailboxView * self G_GNUC_UNUSED)
#line 679 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_add"
{
#line 148 "mn-mailbox-view.gob"
	
    GtkWidget *dialog;

    dialog = mn_mailbox_properties_dialog_new(mn_widget_get_parent_window(GTK_WIDGET(self)), NULL);

    g_signal_connect(dialog,
		     "response",
		     G_CALLBACK(self_properties_add_response_h),
		     NULL);

    gtk_widget_show(dialog);
  }}
#line 696 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 161 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_remove (MNMailboxView * self)
#line 702 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 161 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 161 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 714 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_REMOVE_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 161 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_remove (MNMailboxView * self G_GNUC_UNUSED)
#line 730 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_remove"
{
#line 163 "mn-mailbox-view.gob"
	
    self_remove_mailbox(self);
  }}
#line 738 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 167 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_cut (MNMailboxView * self)
#line 744 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 167 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 167 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 756 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_CUT_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 167 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_cut (MNMailboxView * self G_GNUC_UNUSED)
#line 772 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_cut"
{
#line 169 "mn-mailbox-view.gob"
	
    self_copy_mailbox(self);
    self_remove_mailbox(self);
  }}
#line 781 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 174 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_copy (MNMailboxView * self)
#line 787 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 174 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 174 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 799 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_COPY_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 174 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_copy (MNMailboxView * self G_GNUC_UNUSED)
#line 815 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_copy"
{
#line 176 "mn-mailbox-view.gob"
	
    self_copy_mailbox(self);
  }}
#line 823 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 180 "mn-mailbox-view.gob"
void 
mn_mailbox_view_activate_paste (MNMailboxView * self)
#line 829 "mn-mailbox-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 180 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 180 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 841 "mn-mailbox-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_PASTE_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 180 "mn-mailbox-view.gob"
static void 
___real_mn_mailbox_view_activate_paste (MNMailboxView * self G_GNUC_UNUSED)
#line 857 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::activate_paste"
{
#line 182 "mn-mailbox-view.gob"
	
    GtkSelectionData *data;

    data = gtk_clipboard_wait_for_contents(global_clipboard, clipboard_info[TARGET_MAILBOXES].atom);
    if (data)
      {
	GSList *configurations;
	GSList *l;

	memcpy(&configurations, data->data, data->length);

	MN_LIST_FOREACH(l, configurations)
	  {
	    MNMailbox *mailbox;

	    mailbox = mn_mailbox_new_from_configuration(l->data);

	    mn_mailbox_seal(mailbox);
	    mn_mailboxes_queue_add(mn_shell->mailboxes, mailbox);

	    g_object_unref(mailbox);
	  }

	gtk_selection_data_free(data);
	return;
      }

    data = gtk_clipboard_wait_for_contents(global_clipboard, clipboard_info[TARGET_GNOME_COPIED_FILES].atom);
    if (data)
      {
	if (data->format == 8 && data->length > 0)
	  {
	    char *gnome_copied_files;
	    gboolean status;
	    MNGnomeCopiedFilesType type;
	    GSList *uri_list;

	    gnome_copied_files = g_strndup(data->data, data->length);
	    status = mn_parse_gnome_copied_files(gnome_copied_files, &type, &uri_list);
	    g_free(gnome_copied_files);

	    if (status)
	      {
		if (type == MN_GNOME_COPIED_FILES_COPY)
		  {
		    GSList *l;
		    GSList *invalid_uri_list = NULL;

		    MN_LIST_FOREACH(l, uri_list)
		      {
			const char *uri = l->data;
			MNMailbox *mailbox;

			mailbox = mn_mailbox_new_from_uri(uri);
			if (mailbox)
			  {
			    mn_mailbox_seal(mailbox);
			    mn_mailboxes_queue_add(mn_shell->mailboxes, mailbox);
			    g_object_unref(mailbox);
			  }
			else
			  invalid_uri_list = g_slist_append(invalid_uri_list, (gpointer) uri);
		      }

		    if (invalid_uri_list)
		      {
			mn_invalid_uri_list_dialog(mn_widget_get_parent_window(GTK_WIDGET(self)), _("A paste error has occurred"), invalid_uri_list);
			g_slist_free(invalid_uri_list);
		      }
		  }

		eel_g_slist_free_deep(uri_list);
	      }
	  }

	gtk_selection_data_free(data);
      }
  }}
#line 940 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__



#line 404 "mn-mailbox-view.gob"
static int 
mn_mailbox_view_sort_cb (GtkTreeModel * model, GtkTreeIter * a, GtkTreeIter * b, gpointer user_data)
#line 948 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::sort_cb"
{
#line 409 "mn-mailbox-view.gob"
	
    MNMailbox *mailbox_a;
    MNMailbox *mailbox_b;
    int cmp;

    gtk_tree_model_get(model, a, COLUMN_MAILBOX, &mailbox_a, -1);
    gtk_tree_model_get(model, b, COLUMN_MAILBOX, &mailbox_b, -1);

    cmp = mn_mailboxes_compare_by_name_func(mailbox_a, mailbox_b);

    g_object_unref(mailbox_a);
    g_object_unref(mailbox_b);

    return cmp;
  }}
#line 968 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 425 "mn-mailbox-view.gob"
static gboolean 
mn_mailbox_view_search_equal_cb (GtkTreeModel * model, int column, const char * key, GtkTreeIter * iter, gpointer search_data)
#line 974 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::search_equal_cb"
{
#line 431 "mn-mailbox-view.gob"
	
    gboolean status = TRUE;
    GValue value = { 0, };
    GValue transformed = { 0, };
    const char *str;
    char *normalized_string;
    char *normalized_key;

    /*
     * The stock gtk_tree_view_search_equal_func() only searches the
     * start of the string, using strncmp(). We use strstr(), to
     * search anywhere inside the string.
     */

    gtk_tree_model_get_value(model, iter, column, &value);

    g_value_init(&transformed, G_TYPE_STRING);

    if (! g_value_transform(&value, &transformed))
      {
	g_value_unset(&value);
	return TRUE;
      }

    g_value_unset(&value);

    str = g_value_get_string(&transformed);
    if (! str)
      {
	g_value_unset(&transformed);
	return TRUE;
      }

    normalized_string = g_utf8_normalize(str, -1, G_NORMALIZE_ALL);
    normalized_key = g_utf8_normalize(key, -1, G_NORMALIZE_ALL);

    if (normalized_string && normalized_key)
      {
	char *case_normalized_string;
	char *case_normalized_key;

	case_normalized_string = g_utf8_casefold(normalized_string, -1);
	case_normalized_key = g_utf8_casefold(normalized_key, -1);

	if (strstr(case_normalized_string, case_normalized_key))
	  status = FALSE;

	g_free(case_normalized_string);
	g_free(case_normalized_key);
      }

    g_value_unset (&transformed);
    g_free(normalized_key);
    g_free(normalized_string);

    return status;
  }}
#line 1036 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 489 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_append (MNMailboxView * self, MNMailbox * mailbox)
#line 1042 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::append"
#line 489 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 489 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 489 "mn-mailbox-view.gob"
	g_return_if_fail (mailbox != NULL);
#line 489 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1053 "mn-mailbox-view.c"
{
#line 491 "mn-mailbox-view.gob"
	
    GtkTreeModel *model;
    GtkTreeIter iter;

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    gtk_list_store_append(GTK_LIST_STORE(model), &iter);
    self_update_iter(self, &iter, mailbox);
  }}
#line 1064 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 500 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_mailbox_added_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data)
#line 1070 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::mailbox_added_h"
{
#line 504 "mn-mailbox-view.gob"
	
    Self *self = user_data;

    self_append(self, mailbox);
  }}
#line 1080 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 510 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_mailbox_notify_h (MNMailboxes * mailboxes, MNMailbox * mailbox, GParamSpec * pspec, gpointer user_data)
#line 1086 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::mailbox_notify_h"
{
#line 515 "mn-mailbox-view.gob"
	
    Self *self = user_data;
    GtkTreeIter iter;

    if (self_find_mailbox(self, mailbox, &iter))
      self_update_iter(self, &iter, mailbox);
  }}
#line 1098 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 523 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_mailbox_removed_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data)
#line 1104 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::mailbox_removed_h"
{
#line 527 "mn-mailbox-view.gob"
	
    Self *self = user_data;
    GtkTreeIter iter;

    if (self_find_mailbox(self, mailbox, &iter))
      {
	GtkTreeModel *model;

	model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
	gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
      }
  }}
#line 1121 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 540 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_update_iter (MNMailboxView * self, GtkTreeIter * iter, MNMailbox * mailbox)
#line 1127 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::update_iter"
#line 540 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 540 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 540 "mn-mailbox-view.gob"
	g_return_if_fail (iter != NULL);
#line 540 "mn-mailbox-view.gob"
	g_return_if_fail (mailbox != NULL);
#line 540 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1140 "mn-mailbox-view.c"
{
#line 544 "mn-mailbox-view.gob"
	
    GtkTreeModel *model;
    char *status;
    const char *stock_id = NULL;
    const char *emblem_stock_id = NULL;
    GdkPixbuf *emblem = NULL;
    char *markup;
    char *text;

    if (mailbox->format)
      {
	if (mailbox->error)
	  {
	    status = g_strdup_printf(_("unhandled %s mailbox (%s)"), mailbox->format, mailbox->error);
	    emblem_stock_id = MN_STOCK_ERROR;
	  }
	else
	  {
	    status = g_strdup_printf(_("%s mailbox"), mailbox->format);
	    if (mn_mailbox_get_poll(mailbox))
	      emblem_stock_id = MN_STOCK_POLLED;
	  }
      }
    else
      {
	if (mailbox->error)
	  {
	    status = g_strdup(mailbox->error);
	    if (strcmp(mailbox->stock_id, MN_STOCK_UNKNOWN))
	      emblem_stock_id = MN_STOCK_UNKNOWN;
	  }
	else
	  {
	    status = g_strdup(_("detecting mailbox type..."));
	    stock_id = GTK_STOCK_EXECUTE;
	  }
      }

    if (! stock_id)
      stock_id = mailbox->stock_id;

    if (emblem_stock_id)
      emblem = gtk_widget_render_icon(GTK_WIDGET(self),
				      emblem_stock_id,
				      GTK_ICON_SIZE_MENU,
				      NULL);

    markup = g_markup_printf_escaped("<span weight=\"bold\">%s</span>\n%s",
				     mailbox->runtime_name,
				     status);
    text = g_strdup_printf("%s\n%s", mailbox->runtime_name, status);
    g_free(status);

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    gtk_list_store_set(GTK_LIST_STORE(model), iter,
		       COLUMN_MAILBOX, mailbox,
		       COLUMN_ICON, stock_id,
		       COLUMN_EMBLEM, emblem,
		       COLUMN_PIXBUF, NULL,
		       COLUMN_LABEL, markup,
		       COLUMN_RAW_LABEL, text,
		       -1);

    if (emblem)
      g_object_unref(emblem);

    g_free(markup);
    g_free(text);
  }}
#line 1212 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 614 "mn-mailbox-view.gob"
static gboolean 
mn_mailbox_view_find_mailbox (MNMailboxView * self, MNMailbox * mailbox, GtkTreeIter * iter)
#line 1218 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::find_mailbox"
#line 614 "mn-mailbox-view.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 614 "mn-mailbox-view.gob"
	g_return_val_if_fail (MN_IS_MAILBOX_VIEW (self), (gboolean )0);
#line 614 "mn-mailbox-view.gob"
	g_return_val_if_fail (mailbox != NULL, (gboolean )0);
#line 614 "mn-mailbox-view.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (gboolean )0);
#line 614 "mn-mailbox-view.gob"
	g_return_val_if_fail (iter != NULL, (gboolean )0);
#line 1231 "mn-mailbox-view.c"
{
#line 618 "mn-mailbox-view.gob"
	
    GtkTreeModel *model;
    GtkTreeIter our_iter;
    gboolean valid;

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    valid = gtk_tree_model_get_iter_first(model, &our_iter);

    while (valid)
      {
	MNMailbox *this_mailbox;
	gboolean is;

	gtk_tree_model_get(model, &our_iter, COLUMN_MAILBOX, &this_mailbox, -1);
	is = mailbox == this_mailbox;
	g_object_unref(this_mailbox);

	if (is)
	  {
	    *iter = our_iter;
	    return TRUE;
	  }

	valid = gtk_tree_model_iter_next(model, &our_iter);
      }

    return FALSE;
  }}
#line 1262 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 647 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_update_sensitivity (MNMailboxView * self)
#line 1268 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::update_sensitivity"
#line 647 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 647 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 1275 "mn-mailbox-view.c"
{
#line 649 "mn-mailbox-view.gob"
	
    GtkTreeSelection *selection;
    SensitivityInfo info = { FALSE, FALSE };

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_selected_foreach(selection, self_update_sensitivity_cb, &info);

    gtk_widget_set_sensitive(selfp->properties_item, info.has_selection);
    gtk_widget_set_sensitive(selfp->update_item, info.has_polled);
    gtk_widget_set_sensitive(selfp->remove_item, info.has_selection);
    gtk_widget_set_sensitive(selfp->cut_item, info.has_selection);
    gtk_widget_set_sensitive(selfp->copy_item, info.has_selection);
  }}
#line 1291 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 663 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_update_sensitivity_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
#line 1297 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::update_sensitivity_cb"
{
#line 668 "mn-mailbox-view.gob"
	
    SensitivityInfo *info = data;

    info->has_selection = TRUE;
    if (! info->has_polled)
      {
	MNMailbox *mailbox;

	gtk_tree_model_get(model, iter, COLUMN_MAILBOX, &mailbox, -1);
	if (mn_mailbox_get_poll(mailbox))
	  info->has_polled = TRUE;
	g_object_unref(mailbox);
      }
  }}
#line 1316 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 683 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_remove_mailbox (MNMailboxView * self)
#line 1322 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::remove_mailbox"
#line 683 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 683 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 1329 "mn-mailbox-view.c"
{
#line 685 "mn-mailbox-view.gob"
	
    GtkTreeSelection *selection;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_selected_foreach(selection, self_remove_mailbox_cb, NULL);
  }}
#line 1338 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 692 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_remove_mailbox_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
#line 1344 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::remove_mailbox_cb"
{
#line 697 "mn-mailbox-view.gob"
	
    MNMailbox *mailbox;

    gtk_tree_model_get(model, iter, COLUMN_MAILBOX, &mailbox, -1);
    mn_mailboxes_queue_remove(mn_shell->mailboxes, mailbox);
    g_object_unref(mailbox);
  }}
#line 1356 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 705 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_copy_mailbox (MNMailboxView * self)
#line 1362 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::copy_mailbox"
#line 705 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 705 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 1369 "mn-mailbox-view.c"
{
#line 707 "mn-mailbox-view.gob"
	
    GSList *configurations = NULL;
    GtkTreeSelection *selection;
    const GtkTargetEntry targets[] = {
      { clipboard_info[TARGET_MAILBOXES].name, 0, TARGET_MAILBOXES }
    };
    gboolean status;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_selected_foreach(selection, self_copy_mailbox_cb, &configurations);

    status = gtk_clipboard_set_with_data(global_clipboard,
					 targets,
					 G_N_ELEMENTS(targets),
					 self_get_clipboard_cb,
					 self_clear_clipboard_cb,
					 configurations);
    g_assert(status == TRUE);
  }}
#line 1391 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 727 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_copy_mailbox_cb (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
#line 1397 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::copy_mailbox_cb"
{
#line 732 "mn-mailbox-view.gob"
	
    GSList **configurations = data;
    MNMailbox *mailbox;

    gtk_tree_model_get(model, iter, COLUMN_MAILBOX, &mailbox, -1);
    *configurations = g_slist_append(*configurations, mn_mailbox_get_configuration(mailbox));
    g_object_unref(mailbox);
  }}
#line 1410 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 741 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_get_clipboard_cb (GtkClipboard * clipboard, GtkSelectionData * selection_data, unsigned int info, gpointer user_data_or_owner)
#line 1416 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::get_clipboard_cb"
{
#line 746 "mn-mailbox-view.gob"
	
    const GSList *configurations = user_data_or_owner;
    unsigned char buf[sizeof(configurations)];

    memcpy(buf, &configurations, sizeof(configurations));
    gtk_selection_data_set(selection_data,
			   clipboard_info[info].atom,
			   8,
			   buf,
			   sizeof(buf));
  }}
#line 1432 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 758 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_clear_clipboard_cb (GtkClipboard * clipboard, gpointer user_data_or_owner)
#line 1438 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::clear_clipboard_cb"
{
#line 760 "mn-mailbox-view.gob"
	
    GSList *configurations = user_data_or_owner;

    eel_g_slist_free_deep_custom(configurations, (GFunc) mn_mailbox_configuration_free, NULL);
  }}
#line 1448 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 766 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_select_all (MNMailboxView * self)
#line 1454 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::select_all"
#line 766 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 766 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 1461 "mn-mailbox-view.c"
{
#line 768 "mn-mailbox-view.gob"
	
    GtkTreeSelection *selection;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_select_all(selection);
  }}
#line 1470 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 775 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_properties_add_response_h (GtkDialog * dialog, int response, gpointer user_data)
#line 1476 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::properties_add_response_h"
{
#line 779 "mn-mailbox-view.gob"
	
    if (response == GTK_RESPONSE_HELP)
      mn_display_help(GTK_WINDOW(dialog), "mailbox-properties");
    else if (response == GTK_RESPONSE_CANCEL)
      gtk_widget_destroy(GTK_WIDGET(dialog));
    else if (response == GTK_RESPONSE_ACCEPT)
      {
	MNMailbox *mailbox;

	mailbox = mn_mailbox_properties_dialog_get_current_mailbox(MN_MAILBOX_PROPERTIES_DIALOG(dialog));
	g_assert(MN_IS_MAILBOX(mailbox));

	mn_mailbox_seal(mailbox);
	mn_mailboxes_add(mn_shell->mailboxes, mailbox);
	g_object_unref(mailbox);

	gtk_widget_destroy(GTK_WIDGET(dialog));
      }
  }}
#line 1500 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 799 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_properties_edit_response_h (GtkDialog * dialog, int response, gpointer user_data)
#line 1506 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::properties_edit_response_h"
{
#line 803 "mn-mailbox-view.gob"
	
    if (response == GTK_RESPONSE_HELP)
      mn_display_help(GTK_WINDOW(dialog), "mailbox-properties");
    else
      {
	if (response == GTK_RESPONSE_APPLY || response == GTK_RESPONSE_OK)
	  mn_mailbox_properties_dialog_apply(MN_MAILBOX_PROPERTIES_DIALOG(dialog));
	if (response == GTK_RESPONSE_CANCEL || response == GTK_RESPONSE_OK)
	  gtk_widget_destroy(GTK_WIDGET(dialog));
      }
  }}
#line 1522 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 815 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_popup_menu (MNMailboxView * self, unsigned int button, guint32 activate_time)
#line 1528 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::popup_menu"
#line 815 "mn-mailbox-view.gob"
	g_return_if_fail (self != NULL);
#line 815 "mn-mailbox-view.gob"
	g_return_if_fail (MN_IS_MAILBOX_VIEW (self));
#line 1535 "mn-mailbox-view.c"
{
#line 817 "mn-mailbox-view.gob"
	
    gtk_clipboard_request_targets(global_clipboard, self_popup_menu_targets_received_cb, self);
    gtk_menu_popup(GTK_MENU(selfp->menu), NULL, NULL, NULL, NULL, button, activate_time);
  }}
#line 1542 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 822 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_popup_menu_targets_received_cb (GtkClipboard * clipboard, GdkAtom * atoms, int n_atoms, gpointer data)
#line 1548 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::popup_menu_targets_received_cb"
{
#line 827 "mn-mailbox-view.gob"
	
    Self *self = data;
    int i;
    gboolean can_paste = FALSE;

    for (i = 0; i < n_atoms; i++)
      if (atoms[i] == clipboard_info[TARGET_MAILBOXES].atom
	  || atoms[i] == clipboard_info[TARGET_GNOME_COPIED_FILES].atom)
	{
	  can_paste = TRUE;
	  break;
	}

    gtk_widget_set_sensitive(selfp->paste_item, can_paste);
  }}
#line 1568 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 843 "mn-mailbox-view.gob"
static gboolean 
mn_mailbox_view_popup_menu_h (GtkWidget * widget, gpointer user_data)
#line 1574 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::popup_menu_h"
{
#line 845 "mn-mailbox-view.gob"
	
    Self *self = SELF(widget);

    self_popup_menu(self, 0, gtk_get_current_event_time());
    gtk_menu_shell_select_first(GTK_MENU_SHELL(selfp->menu), FALSE);

    return TRUE;		/* a menu was activated */
  }}
#line 1587 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 854 "mn-mailbox-view.gob"
static gboolean 
mn_mailbox_view_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data)
#line 1593 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::button_press_event_h"
{
#line 858 "mn-mailbox-view.gob"
	
    if (event->button == 3)
      self_popup_menu(SELF(widget), event->button, event->time);

    return FALSE;			/* propagate event */
  }}
#line 1604 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 865 "mn-mailbox-view.gob"
static void 
mn_mailbox_view_row_activated_h (GtkTreeView * treeview, GtkTreePath * path, GtkTreeViewColumn * column, gpointer user_data)
#line 1610 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::row_activated_h"
{
#line 870 "mn-mailbox-view.gob"
	
    self_activate_properties(SELF(treeview));
  }}
#line 1618 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__

#line 874 "mn-mailbox-view.gob"
GtkWidget * 
mn_mailbox_view_new (void)
#line 1624 "mn-mailbox-view.c"
{
#define __GOB_FUNCTION__ "MN:Mailbox:View::new"
{
#line 876 "mn-mailbox-view.gob"
	
    g_return_val_if_fail(mn_shell != NULL, NULL);
    return GTK_WIDGET(GET_NEW);
  }}
#line 1633 "mn-mailbox-view.c"
#undef __GOB_FUNCTION__
