/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-compact-message-view.h"

#include "mn-compact-message-view-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 25 "mn-compact-message-view.gob"

#include "config.h"
#include <glib/gi18n.h>
#include "mn-message-view-private.h"
#include "mn-message.h"
#include "mn-util.h"
#include "mn-text-table.h"

#line 35 "mn-compact-message-view.c"
/* self casting macros */
#define SELF(x) MN_COMPACT_MESSAGE_VIEW(x)
#define SELF_CONST(x) MN_COMPACT_MESSAGE_VIEW_CONST(x)
#define IS_SELF(x) MN_IS_COMPACT_MESSAGE_VIEW(x)
#define TYPE_SELF MN_TYPE_COMPACT_MESSAGE_VIEW
#define SELF_CLASS(x) MN_COMPACT_MESSAGE_VIEW_CLASS(x)

#define SELF_GET_CLASS(x) MN_COMPACT_MESSAGE_VIEW_GET_CLASS(x)

/* self typedefs */
typedef MNCompactMessageView Self;
typedef MNCompactMessageViewClass SelfClass;

/* here are local prototypes */
static void mn_compact_message_view_init (MNCompactMessageView * o) G_GNUC_UNUSED;
static void mn_compact_message_view_class_init (MNCompactMessageViewClass * c) G_GNUC_UNUSED;
static void ___1_mn_compact_message_view_update (MNMessageView * view, GSList * messages) G_GNUC_UNUSED;
static void mn_compact_message_view_append_message (MNCompactMessageView * self, time_t now, MNMessage * message) G_GNUC_UNUSED;
static void mn_compact_message_view_append_header (MNCompactMessageView * self, const char * name) G_GNUC_UNUSED;
static void mn_compact_message_view_append_cell (MNCompactMessageView * self, const char * text) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static MNMessageViewClass *parent_class = NULL;

/* Short form macros */
#define self_append_message mn_compact_message_view_append_message
#define self_append_header mn_compact_message_view_append_header
#define self_append_cell mn_compact_message_view_append_cell
#define self_new mn_compact_message_view_new
GType
mn_compact_message_view_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNCompactMessageViewClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_compact_message_view_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNCompactMessageView),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_compact_message_view_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_MESSAGE_VIEW, "MNCompactMessageView", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNCompactMessageView *)g_object_new(mn_compact_message_view_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNCompactMessageView * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNCompactMessageView *
GET_NEW_VARG (const char *first, ...)
{
	MNCompactMessageView *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNCompactMessageView *)g_object_new_valist (mn_compact_message_view_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
mn_compact_message_view_init (MNCompactMessageView * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Compact:Message:View::init"
}
#undef __GOB_FUNCTION__
static void 
mn_compact_message_view_class_init (MNCompactMessageViewClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Compact:Message:View::class_init"
	MNMessageViewClass *mn_message_view_class = (MNMessageViewClass *)c;

	parent_class = g_type_class_ref (MN_TYPE_MESSAGE_VIEW);

#line 36 "mn-compact-message-view.gob"
	mn_message_view_class->update = ___1_mn_compact_message_view_update;
#line 123 "mn-compact-message-view.c"
}
#undef __GOB_FUNCTION__



#line 36 "mn-compact-message-view.gob"
static void 
___1_mn_compact_message_view_update (MNMessageView * view G_GNUC_UNUSED, GSList * messages)
#line 132 "mn-compact-message-view.c"
#define PARENT_HANDLER(___view,___messages) \
	{ if(MN_MESSAGE_VIEW_CLASS(parent_class)->update) \
		(* MN_MESSAGE_VIEW_CLASS(parent_class)->update)(___view,___messages); }
{
#define __GOB_FUNCTION__ "MN:Compact:Message:View::update"
{
#line 38 "mn-compact-message-view.gob"
	
    Self *self = SELF(view);
    time_t now;
    GSList *l;

    mn_text_table_clear(MN_TEXT_TABLE(view));

    self_append_header(self, _("Mailbox"));
    self_append_header(self, _("From"));
    self_append_header(self, _("Subject"));
    self_append_header(self, _("Sent"));
    mn_text_table_line_break(MN_TEXT_TABLE(self));

    now = mn_time();
    MN_LIST_FOREACH(l, messages)
      self_append_message(self, now, l->data);

    PARENT_HANDLER(view, messages);
  }}
#line 159 "mn-compact-message-view.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 58 "mn-compact-message-view.gob"
static void 
mn_compact_message_view_append_message (MNCompactMessageView * self, time_t now, MNMessage * message)
#line 166 "mn-compact-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Compact:Message:View::append_message"
#line 58 "mn-compact-message-view.gob"
	g_return_if_fail (self != NULL);
#line 58 "mn-compact-message-view.gob"
	g_return_if_fail (MN_IS_COMPACT_MESSAGE_VIEW (self));
#line 58 "mn-compact-message-view.gob"
	g_return_if_fail (message != NULL);
#line 58 "mn-compact-message-view.gob"
	g_return_if_fail (MN_IS_MESSAGE (message));
#line 177 "mn-compact-message-view.c"
{
#line 60 "mn-compact-message-view.gob"
	
    self_append_cell(self, message->mailbox_name);
    if (message->error)
      self_append_cell(self, message->error);
    else
      {
	self_append_cell(self, message->from);
	self_append_cell(self, message->subject);

	if (message->sent_time > 0)
	  mn_message_view_append_past_time_cell(MN_MESSAGE_VIEW(self), message->sent_time, now);
      }

    mn_text_table_line_break(MN_TEXT_TABLE(self));
  }}
#line 195 "mn-compact-message-view.c"
#undef __GOB_FUNCTION__

#line 76 "mn-compact-message-view.gob"
static void 
mn_compact_message_view_append_header (MNCompactMessageView * self, const char * name)
#line 201 "mn-compact-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Compact:Message:View::append_header"
#line 76 "mn-compact-message-view.gob"
	g_return_if_fail (self != NULL);
#line 76 "mn-compact-message-view.gob"
	g_return_if_fail (MN_IS_COMPACT_MESSAGE_VIEW (self));
#line 76 "mn-compact-message-view.gob"
	g_return_if_fail (name != NULL);
#line 210 "mn-compact-message-view.c"
{
#line 78 "mn-compact-message-view.gob"
	
    char *markup;

    markup = g_markup_printf_escaped("<span weight=\"bold\">%s</span>", name);
    mn_text_table_append_text_cell_from_markup(MN_TEXT_TABLE(self), markup);
    g_free(markup);
  }}
#line 220 "mn-compact-message-view.c"
#undef __GOB_FUNCTION__

#line 86 "mn-compact-message-view.gob"
static void 
mn_compact_message_view_append_cell (MNCompactMessageView * self, const char * text)
#line 226 "mn-compact-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Compact:Message:View::append_cell"
#line 86 "mn-compact-message-view.gob"
	g_return_if_fail (self != NULL);
#line 86 "mn-compact-message-view.gob"
	g_return_if_fail (MN_IS_COMPACT_MESSAGE_VIEW (self));
#line 86 "mn-compact-message-view.gob"
	g_return_if_fail (text != NULL);
#line 235 "mn-compact-message-view.c"
{
#line 88 "mn-compact-message-view.gob"
	
    mn_text_table_append_text_cell(MN_TEXT_TABLE(self), text);
  }}
#line 241 "mn-compact-message-view.c"
#undef __GOB_FUNCTION__

#line 92 "mn-compact-message-view.gob"
GtkWidget * 
mn_compact_message_view_new (void)
#line 247 "mn-compact-message-view.c"
{
#define __GOB_FUNCTION__ "MN:Compact:Message:View::new"
{
#line 94 "mn-compact-message-view.gob"
	
    return GTK_WIDGET(GET_NEW);
  }}
#line 255 "mn-compact-message-view.c"
#undef __GOB_FUNCTION__
