%{
/*
Magpie - reference librarian for Debian systems
Copyright (C) 2000  Bear Giles <bgiles@coyotesong.com>

This program is free software; you may redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the license, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static const char rcsid[] = "$Id$";

#include "parser.h"

struct tags { const char *name; int value; };

extern struct tags * lookup_tag (const char *, unsigned int);

struct tokens { const char *name; int token; int value; };

extern struct tokens * lookup_token (const char *, unsigned int, int);

int last_token = 0;
int lineno = 1;

struct tokens *t;

%}

space		[ \t]
newline		\n
comma		\,
or			\|
slash		\/
lt_restrict	\(<[^)]+\)
gt_restrict	\(>[^)]+\)
	/* eq_restrict	\((={space}?)?[0-9][^)]*\) */
eq_restrict	\((={space}?)?[^)]*\)

tag			^[A-Za-z][^:]*\:

item		[^-,\ ]+

dec			[0-9]+
hex			[0-9a-f]+

token		[^,(|/\ \n]+
line		[^\n]+
body		{space}[^\n]+
eom			^\n

%%

{space}		;

{or}			return T_OR;
{comma}			return T_AND;
{lt_restrict}	return T_LT_RESTRICTION;
{gt_restrict}	return T_GT_RESTRICTION;
{eq_restrict}	return T_EQ_RESTRICTION;
{slash}			return T_SLASH;

{tag}		{
			struct tags *t;

			yytext[yyleng-1] = '\0';
			t = lookup_tag (yytext, yyleng-1);
			if (t == 0) {
				fprintf (stderr, "unrecognized tag: %s\n", yytext);
				REJECT;
			}
			return last_token = t->value;
			}

{token}		{
			switch (last_token)
				{
				case T_PRIORITY:
				case T_ESSENTIAL:
				case T_SECTION:
				case T_ARCHITECTURE:
					t = lookup_token (yytext, yyleng, last_token);
					if (t == NULL)
						REJECT;

//					printf ("priority = %s -> %d\n", yytext, t->value);
					return t->value;
					break;

				case T_MD5SUM:
				case T_SIZE:
				case T_INSTALLED_SIZE:
					REJECT;

				default:
					return T_TOKEN;
				}
			}

{line}	{
			switch (last_token)
				{
				case T_MAINTAINER:
				case T_FILENAME:
					last_token = T_TOKEN;
					return T_TOKEN;

				case T_DESCRIPTION:
					last_token = T_DESCRIPTION_TITLE;
					return last_token;
				
				case T_CONFFILES:
					last_token = T_DESCRIPTION_BODY;
					return last_token;

				default:
					REJECT;
				}
			}

{dec}		{
			switch (last_token)
				{
				case T_SIZE:
				case T_INSTALLED_SIZE:
					return T_DEC;
				
				default:
					REJECT;
				}
			}
				
{hex}		{
			switch (last_token)
				{
				case T_MD5SUM:
					return T_HEX;
				
				default:
					REJECT;
				}
			}

{body}		{
			switch (last_token)
				{
				case T_DESCRIPTION_TITLE:
				case T_DESCRIPTION_BODY:
					last_token = T_DESCRIPTION_BODY;
					return last_token;
				
				default:
					REJECT;
				}
			}

{eom}		{
			lineno++;
			return T_EOM;
			}

{newline}	lineno++;
			/* printf (" (line %d)\n", lineno++); */

<<EOF>>		return T_EOF;

%%

void free_flex (void)
{
	yy_delete_buffer (yy_current_buffer);
}
