/*
Magpie - reference librarian for Debian systems
Copyright (C) 2000  Bear Giles <bgiles@coyotesong.com>

This program is free software; you may redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the license, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

static const char rcsid[] = "$Id$";

/*****
This module must always be called first after loading the database.
*****/
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/wait.h>
#include "magpie.h"

#define OUTPUT_DIR	"html"

extern int mkdir (const char *, mode_t);

extern int rmrf (const char *);

extern FILE *md5sum (const char *);


/*+
+*/
static void html_dump (const char *filename, const char *title)
{
	FILE *fp;
	char pathname[256], ch;
	struct package_info *p;
	int i;

	sprintf (pathname, "%s/details", OUTPUT_DIR);
	mkdir (OUTPUT_DIR, 0755);

	/* weird syntax just in case we're non-ASCII */
	for (ch = 0; ch < 0x7F; ch++) {
		if (islower (ch) || isdigit (ch)) {
			sprintf (pathname, "%s/%s/%c", OUTPUT_DIR, filename, ch);
			mkdir (pathname, 0755);
		}
	}

	for (i = 0; i < cachecnt; i++) {
		p = cache[i];
		if (!p->selected)
			continue;

		sprintf (pathname, "%s/%s/%1$1.1s/%1$s.html", 
			OUTPUT_DIR, filename, p->name);
		fp = fopen (pathname, "w");
		mp_doc_open (fp, "Detailed Information for '%s'", p->name);

		mp_package (fp, p, 0, 0);

		mp_doc_close (fp);
		fclose (fp);

		gzip (pathname);
	}
}


/*+
Print the complete package information in individual files.
This procedure should be called first, after loading the package
information, since the other packages depend on the of the data
it produces.
+*/
static int core1_init (void)
{
	int i;

	mkdir (OUTPUT_DIR, 0755);

	/* select all packages */
	for (i = 0; i < CACHECNT; i++)
		cache[i]->selected = 1;
	html_dump ("details", NULL);

	return 0;
}


struct magpie_module mod_html1 = { 
	version           : MAGPIE_VERSION,
	description       : "HTML module",
	init              : html1_init
};
