
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file MetgramCurveAttributes.h
    \\brief Definition of MetgramCurve Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MetgramCurveAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

MetgramCurveAttributes::MetgramCurveAttributes():
	keyword1_(ParameterManager::getString("metgram_curve_keyword")),
	keyword2_(ParameterManager::getString("metgram_curve_keyword2")),
	thickness_(ParameterManager::getInt("metgram_curve_thickness")),
	thickness2_(ParameterManager::getInt("metgram_curve2_thickness"))
	,
	style_(MagTranslator<string, LineStyle>().magics("metgram_curve_line_style")),
	style2_(MagTranslator<string, LineStyle>().magics("metgram_curve2_line_style")),
	colour_(MagTranslator<string, Colour>().magics("metgram_curve_colour")),
	colour2_(MagTranslator<string, Colour>().magics("metgram_curve2_colour"))
	 
{
} 


MetgramCurveAttributes::~MetgramCurveAttributes()
{
	
}

    
void MetgramCurveAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "metgram";
	
	setAttribute(prefix, "metgram_curve_keyword", keyword1_, params);
	setAttribute(prefix, "metgram_curve_keyword2", keyword2_, params);
	setAttribute(prefix, "metgram_curve_thickness", thickness_, params);
	setAttribute(prefix, "metgram_curve2_thickness", thickness2_, params);
	
	setAttribute(prefix, "metgram_curve_line_style", style_, params);
	setAttribute(prefix, "metgram_curve2_line_style", style2_, params);
	setMember(prefix, "metgram_curve_colour", colour_, params);
	setMember(prefix, "metgram_curve2_colour", colour2_, params);
	
}

void MetgramCurveAttributes::copy(const MetgramCurveAttributes& other)
{
	keyword1_ = other.keyword1_;
	keyword2_ = other.keyword2_;
	thickness_ = other.thickness_;
	thickness2_ = other.thickness2_;
	style_ = other.style_;
	style2_ = other.style2_;
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	colour2_ = unique_ptr<Colour>(other.colour2_->clone());
	
} 


bool MetgramCurveAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "metgraph")  )
		return true;
	
	return false;
}

void MetgramCurveAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "metgraph")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void MetgramCurveAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " keyword1 = " <<  keyword1_;
	out << " keyword2 = " <<  keyword2_;
	out << " thickness = " <<  thickness_;
	out << " thickness2 = " <<  thickness2_;
	out << " style = " <<  style_;
	out << " style2 = " <<  style2_;
	out << " colour = " <<  *colour_;
	out << " colour2 = " <<  *colour2_;
	
	out << "]" << "\n";
}

void MetgramCurveAttributes::toxml(ostream& out)  const
{
	out <<  "\"metgraph\""; 
	out << ", \"metgram_curve_keyword\":";
	niceprint(out,keyword1_);
	out << ", \"metgram_curve_keyword2\":";
	niceprint(out,keyword2_);
	out << ", \"metgram_curve_thickness\":";
	niceprint(out,thickness_);
	out << ", \"metgram_curve2_thickness\":";
	niceprint(out,thickness2_);
	out << ", \"metgram_curve_line_style\":";
	niceprint(out, style_);
	out << ", \"metgram_curve2_line_style\":";
	niceprint(out, style2_);
	out << ", \"metgram_curve_colour\":";
	niceprint(out, *colour_);
	out << ", \"metgram_curve2_colour\":";
	niceprint(out, *colour2_);
	
}

static MagicsParameter<string> metgram_curve_keyword("metgram_curve_keyword", "curve1", "");
static MagicsParameter<string> metgram_curve_keyword2("metgram_curve_keyword2", "curve2", "");
static MagicsParameter<int> metgram_curve_thickness("metgram_curve_thickness", 2, "");
static MagicsParameter<int> metgram_curve2_thickness("metgram_curve2_thickness", 2, "");
static MagicsParameter<string> metgram_curve_line_style("metgram_curve_line_style", "solid", ""); 
static MagicsParameter<string> metgram_curve2_line_style("metgram_curve2_line_style", "solid", ""); 
static MagicsParameter<string> metgram_curve_colour("metgram_curve_colour", "red", ""); 
static MagicsParameter<string> metgram_curve2_colour("metgram_curve2_colour", "blue", ""); 
