
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileContourAttributes.h
    \brief Definition of Contour Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef ContourAttributes_H
#define ContourAttributes_H

#include "magics.h"
#include "ContourMethod.h"
#include "ValuePlotBase.h"
#include "IsoPlot.h"
#include "HiLoBase.h"
namespace magics {

class XmlNode;
class ContourAttributes 
{
public:
//  --  constructor
    ContourAttributes();
    
//  --  destructor
    virtual ~ContourAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const ContourAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	bool legend_;
	double floor_;
	double ceiling_;
	string setting_;
	string predefined_;
	bool metadata_only_;
	string library_path_;
	unique_ptr<IsoPlot> contour_;
	unique_ptr<ContourMethod> method_;
	unique_ptr<HiLoBase> hilo_;
	unique_ptr<ValuePlotBase> grid_;
	 

private:
	friend ostream& operator<<(ostream& s,const ContourAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

