/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisAttributes.h
    \brief Definition of Axis Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:46 2012
*/
   

#ifndef AxisAttributes_H
#define AxisAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "AxisTickLabel.h"
#include "AxisTick.h"
#include "AxisMinorTick.h"
#include "AxisTip.h"
#include "AxisGrid.h"
#include "AxisLine.h"
#include "AxisMethod.h"
#include "AxisControl.h"
#include "AxisTitle.h"

namespace magics {

class XmlNode;



class AxisAttributes 
{
public:
//  --  constructor
    AxisAttributes();
    
//  --  destructor
    virtual ~AxisAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const AxisAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Method to position ticks on an axis (REGULAR / POSITION_LIST / LOGARITHMIC / LATITUDE / LONGITUDE / DATE) 
    \param method Setting axis_type - default=regular
*/
	void setMethod(AxisMethod* method) 
		{ auto_ptr<AxisMethod> tmp(method); method_ = tmp; } 
	const AxisMethod&  getMethod() const 
		{ return *method_; }
/*!
    Magics Information:
    \brief  Value at beginning of axis in user units 
    \param control Setting graph_axis_control - default=off
*/
	void setControl(AxisControl* control) 
		{ auto_ptr<AxisControl> tmp(control); control_ = tmp; } 
	const AxisControl&  getControl() const 
		{ return *control_; }
/*!
    Magics Information:
    \brief  Orientation of axis (HORIZONTAL/VERTICAL) 
    \param orientation Setting axis_orientation - default=horizontal
*/
	void setOrientation(const string& orientation) 
		{ orientation_ =  orientation; } 
	const string& getOrientation() const 
		{ return orientation_; } 
        
/*!
    Magics Information:
    \brief  Position relative to subpage. When set to 'AUTOMATIC'  the parameter AXIS_LINE_POSITION should be set to the position of the axis relative to the lower left corner of the subpage, (BOTTOM/TOP/LEFT/RIGHT/AUTOMATIC) 
    \param position Setting axis_position - default=automatic
*/
	void setPosition(const string& position) 
		{ position_ =  position; } 
	const string& getPosition() const 
		{ return position_; } 
        
/*!
    Magics Information:
    \brief  Plot an axis line (ON/OFF) 
    \param line Setting axis_line - default=on
*/
	void setLine(AxisLine* line) 
		{ auto_ptr<AxisLine> tmp(line); line_ = tmp; } 
	const AxisLine&  getLine() const 
		{ return *line_; }
/*!
    Magics Information:
    \brief  Plot axis grid lines (ON/OFF) 
    \param grid Setting axis_grid - default=off
*/
	void setGrid(AxisGrid* grid) 
		{ auto_ptr<AxisGrid> tmp(grid); grid_ = tmp; } 
	const AxisGrid&  getGrid() const 
		{ return *grid_; }
/*!
    Magics Information:
    \brief  Plot axis title (ON/OFF) 
    \param title Setting axis_title - default=on
*/
	void setTitle(AxisTitle* title) 
		{ auto_ptr<AxisTitle> tmp(title); title_ = tmp; } 
	const AxisTitle&  getTitle() const 
		{ return *title_; }
/*!
    Magics Information:
    \brief  Plot ticks (ON/OFF) 
    \param tick Setting axis_tick - default=on
*/
	void setTick(AxisTick* tick) 
		{ auto_ptr<AxisTick> tmp(tick); tick_ = tmp; } 
	const AxisTick&  getTick() const 
		{ return *tick_; }
/*!
    Magics Information:
    \brief  Plot minor ticks (ON/OFF) 
    \param minor_tick Setting axis_minor_tick - default=off
*/
	void setMinor_tick(AxisMinorTick* minor_tick) 
		{ auto_ptr<AxisMinorTick> tmp(minor_tick); minor_tick_ = tmp; } 
	const AxisMinorTick&  getMinor_tick() const 
		{ return *minor_tick_; }
/*!
    Magics Information:
    \brief  Plot tick labels (ON/OFF) 
    \param label Setting axis_tick_label - default=on
*/
	void setLabel(AxisTickLabel* label) 
		{ auto_ptr<AxisTickLabel> tmp(label); label_ = tmp; } 
	const AxisTickLabel&  getLabel() const 
		{ return *label_; }
/*!
    Magics Information:
    \brief  Plot ticks (ON/OFF) 
    \param tip Setting axis_tip_title - default=off
*/
	void setTip(NoAxisTip* tip) 
		{ auto_ptr<NoAxisTip> tmp(tip); tip_ = tmp; } 
	const NoAxisTip&  getTip() const 
		{ return *tip_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<AxisMethod> method_;
	auto_ptr<AxisControl> control_;
	string orientation_;
	string position_;
	auto_ptr<AxisLine> line_;
	auto_ptr<AxisGrid> grid_;
	auto_ptr<AxisTitle> title_;
	auto_ptr<AxisTick> tick_;
	auto_ptr<AxisMinorTick> minor_tick_;
	auto_ptr<AxisTickLabel> label_;
	auto_ptr<NoAxisTip> tip_;

private:
  
	friend ostream& operator<<(ostream& s,const AxisAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
