/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file NetcdfMatrixInterpretor.h
    \brief Implementation of the Template class NetcdfMatrixInterpretor.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 17-Feb-2004
    
    Changes:
    
*/

#include <limits>

#include "NetcdfMatrixInterpretor.h"
#include "Factory.h"
#include "Netcdf.h"
#include "Coordinate.h"

using namespace magics;

NetcdfMatrixInterpretor::NetcdfMatrixInterpretor() 
{
}


NetcdfMatrixInterpretor::~NetcdfMatrixInterpretor() 
{
}


void NetcdfMatrixInterpretor::interpretAsMatrix(Matrix** matrix)
{
	static map<string, double> factors;
	if ( factors.empty() ) {
		factors["hours"] = 3600;
		factors["days"] = 24*3600;
	}
	Log::debug() << "NetcdfMatrixInterpretor::interpret()--->" << *this << "\n";
	if ( *matrix ) return;
	
	Matrix* data = new Matrix();
	
	*matrix = data;
	if ( !data->empty() ) return;
    
	data->missing(std::numeric_limits<double>::max());

	Netcdf netcdf(path_);
	// get the data ...
	try {
		map<string, string> first, last;
		setDimensions(dimension_, first, last);
		Log::debug() << "data" << data->size() << "\n";
        
		netcdf.get(field_, *data, first, last);
		
		Log::debug() << "data[" << data->size() << ", " << scaling_ << ", " << offset_ << "]" << "\n";

		data->multiply(scaling_);
		data->plus(offset_);
        
		Log::debug() << "data[" << data->size() << ", " << scaling_ << ", " << offset_ << "\n";
        
		//netcdf.get(longitude_, data->columnsAxis(), first, last);
		//netcdf.get(latitude_, data->rowsAxis(), first, last);
		vector<double> col;
	    netcdf.get(x_, data->columnsAxis(), first, last);			
		netcdf.get(y_, data->rowsAxis(), first, last);
		vector<double>& rows =  data->rowsAxis();
		vector<double>& columns =  data->columnsAxis();
		string date = netcdf.getVariableAttribute(y_, "reference_date", "");
		if ( date != "" ) {
			string units = netcdf.getVariableAttribute(y_, "units", "");
		// ???		Coordinate* from = new DateCoordinate(date);
			double diff = DateTime(date) - DateTime(reference_);
            Log::debug() << "DATE--->" << date << "--->" << reference_ << " [" << diff << "]\n";
			map<string, double>::const_iterator factor = factors.find(units);
			if ( factor != factors.end() )
				std::transform(rows.begin(), rows.end(),  rows.begin(), Multiply(factor->second, std::numeric_limits<double>::max()));	
			std::transform(rows.begin(), rows.end(),  rows.begin(), Plus(diff, std::numeric_limits<double>::max()));
		}
		string missing = netcdf.getVariableAttribute(field_, "missing_value", "");
		if ( !missing.empty() ) {
			std::stringstream ss(missing);		
			double m;
			ss >> m;
            data->missing(m);
		}
		
		date = netcdf.getVariableAttribute(x_, "reference_date", "");
		if ( !date.empty() ) {
			string units = netcdf.getVariableAttribute(x_, "units", "");
		// ???		Coordinate* from = new DateCoordinate(date);
			double diff = DateTime(date) - DateTime(reference_);
            Log::debug() << "DATE--->" << date << "--->" << reference_ << " [" << diff << "]\n";
			map<string, double>::const_iterator factor = factors.find(units);
			if ( factor != factors.end() )
				std::transform(columns.begin(), columns.end(),  columns.begin(), Multiply(factor->second, std::numeric_limits<double>::max()));	
			std::transform(columns.begin(), columns.end(),  columns.begin(), Plus(diff, std::numeric_limits<double>::max()));
		}
		data->setMapsAxis();
		
    
		Log::dev() << data << "\n";
	}
	catch (MagicsException& e)
	{
		Log::error() << e << "\n";
	}    
}



/*!
 Class information are given to the output-stream.
*/		
void NetcdfMatrixInterpretor::print(ostream& out)  const
{
	out << "NetcdfMatrixInterpretor[";
	NetcdfInterpretor::print(out);
	NetcdfMatrixInterpretorAttributes::print(out);
	out << "]";
}
