/*************************************************************************/
/*                                                                       */
/*  MacroSystem - Powerful C++ template system.                          */
/*                                                                       */
/*  http://projects.nn.com.br/                                           */
/*                                                                       */
/*  Copyright (C) 2000 Gustavo Niemeyer <gustavo@nn.com.br>              */
/*                                                                       */
/*  This library is free software; you can redistribute it and/or        */
/*  modify it under the terms of the GNU Library General Public          */
/*  License as published by the Free Software Foundation; either         */
/*  version 2 of the License, or (at your option) any later version.     */
/*                                                                       */
/*  This library is distributed in the hope that it will be useful,      */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    */
/*  Library General Public License for more details.                     */
/*                                                                       */
/*  You should have received a copy of the GNU Library General Public    */
/*  License along with this library; if not, write to the                */
/*  Free Software Foundation, Inc., 59 Temple Place - Suite 330,         */
/*  Boston, MA  02111-1307, USA.                                         */
/*                                                                       */
/*************************************************************************/

// $Revision: 1.4 $
// $Date: 2000/02/03 06:29:58 $

#include <iostream>
#include <fstream>
#include <macrosystem.hh>

using namespace macrosystem;

int main()
{
  MacroSystem macro;

  // Import macro file

  ifstream macrofile("macrofile.ms");
  macrofile >> macro;

  // Output a macro from macro file

  cout << macro["macro_file"].parse();

  // Set a singleline macro

  macro["singleline_macro"] = "This is a single line macro.";

  // Set a multiline macro

  macro["multiline_macro"] = "This is a multiline macro\n";
  macro["multiline_macro"] += "because it spans across multiple lines!";

  // Erase some macros

  macro["macro_file_parse_off"].erase();
  macro["macro_file"].erase();
  macro["macro_file_topic"].erase();

  // Set a new macro with parsing off

  macro["parse_off"].set("New macro with parsing off.",false);

  // Overwrite a macro

  macro["library_name"] = " -- MacroSystem -- ";

  // Export macro file with the changed MacroSystem.

  ofstream newmacrofile("exported.ms");
  newmacrofile << "#\n# This macro file has been exported by the macrofile example.\n#\n\n";
  newmacrofile << macro;

  return 0;
}

