%define ver 0.14.4


Name:      libsynaptics
Version:   %{ver}d
Release:   1
Summary:   libsynaptics library for interfacing with Xorg Synaptics Driver

Group:     Development/Libraries
License:   GPL
URL:       http://qsynaptics.sf.net
Source:    http://qsynaptics.sf.net/libsynaptics-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Requires:  synaptics = %{ver}
BuildRequires: synaptics = %{ver}


%description
libsynaptics is intended to support all upcoming driver versions of the
Xorg Synaptics Touch Pad Driver.
Programs that want to access the touch pad should make use of this library
and will thereby not interfere with each other.
Available parameters can be read and written and the version of the
installed driver can be determined.
It is still not clear whether libsynaptics will be distributed seperately or
within the driver package (which seems to be the better solution to me! )

%package devel
Group:     Development/Libraries
Summary:   Includes the files needed for development with libsynaptics
Requires:  libsynaptics = %{version}

%description devel
The libsynaptics-devel package contains the libraries and include files that you can use to develop applications using the libsynaptics.

%prep
%setup

%build
%configure --prefix=/usr
make

%install
%makeinstall

# remove unpackaged files from the buildroot
rm -f $RPM_BUILD_ROOT%{_libdir}/libsynaptics.la

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf "$RPM_BUILD_ROOT"

%post   -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc COPYING INSTALL README TODO
%{_libdir}/libsynaptics.so.*


%files devel
%defattr (-,root,root)
%{_includedir}/synaptics/*
%{_libdir}/libsynaptics.a
%{_libdir}/libsynaptics.so
# No .pc file in archive
#%{_libdir}/pkgconfig/*

%changelog
* Sun Apr 30 2006 Stephanos Manos <stefmanos@gmail.com>
- Initial spec file created

