/* package-info.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

/**
 * Provides mouse overlay panels which enable different
 * mouse 'tools' to be associated with a single panel. Useful when
 * mouse actions differ according to context: clicking on a graphical
 * object and dragging it activates one tool, while clicking (and
 * dragging) on the panel but not on an object activates another tool (which for instance
 * displays a selection rectangle). This allows a complicated mouse
 * listener to be split into several independent classes.<p>
 * A group of related mouse actions should be implemented as a subclass of
 * {@link be.ugent.caagt.swirl.mouse.MouseHandler}. A set of mouse handlers can be registered
 * with a single {@link be.ugent.caagt.swirl.mouse.MouseTool} which must then be associated
 * to a {@link be.ugent.caagt.swirl.mouse.MouseOverlay}. Finally, this 
 * panel should be added as a child
 * to a given component and will then track all mouse actions for that component.
 */
package be.ugent.caagt.swirl.mouse;

