/*
 * Licensed to the University Corporation for Advanced Internet Development, 
 * Inc. (UCAID) under one or more contributor license agreements.  See the 
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache 
 * License, Version 2.0 (the "License"); you may not use this file except in 
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.FilterProcessingException;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethFilteringContext;

/**
 * A match function that evaluates an attribute's value against the provided regular expression.
 */
public class AttributeValueRegexMatchFunctor extends AbstractAttributeTargetedRegexMatchFunctor {

    /**
     * Evaluates to true if any value for the specified attribute matches the provided regular expression.
     * 
     * {@inheritDoc}
     */
    protected boolean doEvaluatePolicyRequirement(ShibbolethFilteringContext filterContext)
            throws FilterProcessingException {
        BaseAttribute attribute = filterContext.getUnfilteredAttributes().get(getAttributeId());
        
        if (attribute != null && attribute.getValues() != null) {
            for (Object value : attribute.getValues()) {
                if (isMatch(value)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * Evaluates to true if the given attribute value matches the provided regular expression.
     * 
     * {@inheritDoc}
     */
    protected boolean doEvaluateValue(ShibbolethFilteringContext filterContext, String id, Object attributeValue)
            throws FilterProcessingException {

        return isMatch(attributeValue);
    }
}