/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.jdbc.translators;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;

/**
 * Implementation of <code>java.sql.Struct</code> for DB Procedure parameters.
 */
public class Structure implements Struct {

	private Object[] elements; 
	private String   typeName;

	public Structure(Object[] elements, String typeName) {
		this.elements = elements;
		this.typeName = typeName;	
	}
    
	public Object[] getAttributes() throws SQLException {
		return elements;
	}

	public String getSQLTypeName() throws SQLException {
		return typeName;
	}

	public Object[] getAttributes(Map arg0) throws SQLException {
		throw new SQLException("Feature not supported.");
	}

	public boolean equals(Object o) {
		if(o == null) {
			return false;
		} else {
			Object[] cmpArray=null;
			if(o instanceof java.sql.Struct) {
				try {
					cmpArray = ((Struct)o).getAttributes();
				} catch(SQLException sqlEx) {
					return false;
				}
			} else if(o instanceof Object[]) {
				cmpArray = (Object[]) o;
			} else {
				return false;
			}
			if(elements.length != cmpArray.length) {
				return false;
			} else {
				for(int i=0; i<elements.length; ++i) {
					if(!elements[i].equals(cmpArray[i])) {
						return false;
					}
				}
				return true;
			}
		}
	}
	
	public String toString() {
		StringWriter sw=new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		pw.println("STRUCTURE (");
		for(int i=0; i<elements.length; ++i) {
			if(elements[i] instanceof byte[]) {
				pw.println("  FIELD[" + (i) + "]=" + toHex((byte[])elements[i]));	
			} else {
				pw.println("  FIELD[" + (i) + "]=" + elements[i]);
			}
		}
		pw.println(")");
		return sw.toString();
	}

	private static char[] hexchar = { '0', '1', '2', '3', '4', '5', '6',
		'7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
	};
	
	private String toHex(byte[] ba) {
		StringBuffer r=new StringBuffer("x'");
		for(int i=0; i<ba.length; ++i) {
			int ba_i = ba[i];
			ba_i = ba_i & 255;
			r.append(hexchar[ba_i >> 4]);
			r.append(hexchar[ba_i % 4]);	
		}
		r.append("'");
		String s = new String(ba); 
		return r.toString()  + " (" + s + ")"; 
	}
	
}
