#include "osl/search/sacrificeCheck.h"
#include "osl/search/recordStack.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::search;

class SacrificeCheckTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(SacrificeCheckTest);
  CPPUNIT_TEST(testCount2);
  CPPUNIT_TEST_SUITE_END();
public:
  void testCount2();
};

CPPUNIT_TEST_SUITE_REGISTRATION(SacrificeCheckTest);

void SacrificeCheckTest::testCount2()
{
  MoveStack history;
  RecordStack record_stack;
  CPPUNIT_ASSERT_EQUAL(0, SacrificeCheck::count2(record_stack, history, 100));
  SimpleHashRecord *record0 = new SimpleHashRecord();
  record0->setInCheck(true);
  record_stack.push(&record0);
  history.push(Move(Position(5,5),SILVER,BLACK));

  CPPUNIT_ASSERT_EQUAL(0, SacrificeCheck::count2(record_stack, history, 100));

  SimpleHashRecord *record1 = new SimpleHashRecord();
  record_stack.push(&record1);
  history.push(Move(Position(5,4),Position(5,5),KING,SILVER,false,WHITE));

  CPPUNIT_ASSERT_EQUAL(1, SacrificeCheck::count2(record_stack, history, 100));

  SimpleHashRecord *record2 = new SimpleHashRecord();
  record2->setInCheck(true);
  record_stack.push(&record2);
  history.push(Move(Position(5,6),GOLD,BLACK));

  CPPUNIT_ASSERT_EQUAL(0, SacrificeCheck::count2(record_stack, history, 100));

  SimpleHashRecord *record3 = new SimpleHashRecord();
  record_stack.push(&record3);
  history.push(Move(Position(5,5),Position(5,6),KING,GOLD,false,WHITE));

  CPPUNIT_ASSERT_EQUAL(2, SacrificeCheck::count2(record_stack, history, 100));
  CPPUNIT_ASSERT_EQUAL(1, SacrificeCheck::count2(record_stack, history, 2));

  history.pop();
  history.push(Move(Position(5,5),Position(4,4),KING,PTYPE_EMPTY,false,WHITE));

  CPPUNIT_ASSERT_EQUAL(0, SacrificeCheck::count2(record_stack, history, 100));
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
