/* consistencyTest.h
 */
#ifndef TEST_EVAL_CONSISTENCYTEST_H
#define TEST_EVAL_CONSISTENCYTEST_H

#include "osl/state/numEffectState.h"
#include "osl/apply_move/applyMove.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"
#include "osl/effect_util/effectUtil.h"
#include "osl/effect_util/neighboring8Direct.h"
#include "osl/progress/effect5x3.h"
#include "osl/centering5x3.h"
#include "osl/centering3x3.h"
#include "osl/oslConfig.h"
#include <iostream>
#include <fstream>
#include <string>

#include <cppunit/extensions/HelperMacros.h>

namespace osl
{
  inline bool quiet_position(int progress_b, int progress_w, const NumEffectState& state, Move m) 
  {
    if (state.inCheck() )
      return false;
#if 0
    if (progress_b + progress_w < 13 && m.capturePtype() == PTYPE_EMPTY
	&& std::max(progress_b, progress_w) < 8)
      return true;
#endif
    if (m.capturePtype() != PTYPE_EMPTY
	&& isMajor(m.capturePtype()))
      return false;
    if (std::max(progress_b, progress_w) > 10 && m.capturePtype() != PTYPE_EMPTY)
      return false;
    const Position black_king = Centering3x3::adjustCenter(state.getKingPosition<BLACK>());
    const Position white_king = Centering3x3::adjustCenter(state.getKingPosition<WHITE>());
    const Position black_king_c = Centering5x3::adjustCenter(black_king);
    const Position white_king_c = Centering5x3::adjustCenter(white_king);
    const Position to = m.to();
    if (abs(black_king_c.x() - to.x()) < 4
	&& abs(black_king_c.y() - to.y()) < 3)
      return false;
    if (abs(white_king_c.x() - to.x()) < 4
	&& abs(white_king_c.y() - to.y()) < 3)
      return false;
    if (Neighboring8Direct::hasEffect(state, m.ptypeO(), to, black_king)
	|| Neighboring8Direct::hasEffect(state, m.ptypeO(), to, white_king))
	return false;
    if (Neighboring8Direct::hasEffect(state, m.capturePtypeOSafe(), to, black_king)
	|| Neighboring8Direct::hasEffect(state, m.capturePtypeOSafe(), to, white_king))
	return false;
    if (Neighboring8Direct::hasEffect(state, m.ptypeO(), to, black_king_c)
	|| Neighboring8Direct::hasEffect(state, m.ptypeO(), to, white_king_c))
	return false;
    // todo: sokofu
    return true;
  }
}

template <class Eval>
void consistencyTestExpect(int threshold=0)
{
  using namespace osl;

  extern bool isShortTest;
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string file_name;
  for (int i=0;i<(isShortTest ? 10 : 900) && (ifs >> file_name) ; i++)
  {
    if ((i % 100) == 0)
      std::cerr << '.';
    if (file_name == "") 
      break;
    file_name = OslConfig::testCsaFile(file_name);

    const Record record=CsaFile(file_name).getRecord();
    const vector<osl::Move> moves=record.getMoves();

    NumEffectState state(record.getInitialState());
    Eval eval(state);
    
    for (unsigned int i=0; i<moves.size(); i++) {
      const Move m = moves[i];
      const int value = eval.expect(state, m);
      const int progress_b = progress::Effect5x3(state).progress16(BLACK).value();
      const int progress_w = progress::Effect5x3(state).progress16(WHITE).value();
      const bool in_check = state.inCheck();
      ApplyMoveOfTurn::doMove(state, m);
      eval.update(state, m);	// update with new state
      if (threshold == 0 
	  || (! in_check && quiet_position(progress_b, progress_w, state, m))){
	if ((m.player() == BLACK && eval.value() > value + threshold)
	    || (m.player() == WHITE && eval.value() < value - threshold))
	  std::cerr << "\n" << state << std::endl << progress_b << " " << progress_w
		    << " " << m << " " << eval.value() << " " << value << std::endl;
	CPPUNIT_ASSERT((m.player() == BLACK && eval.value() <= value + threshold)
		       || (m.player() == WHITE && eval.value() >= value - threshold));
      }
    }
  }
}

template <class Eval>
void consistencyTestUpdate()
{
  using namespace osl;

  extern bool isShortTest;
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string file_name;
  for (int i=0;i<(isShortTest ? 100 : 900) && (ifs >> file_name) ; i++)
  {
    if ((i % 100) == 0)
      std::cerr << '.';
    if (file_name == "") 
      break;
    file_name = OslConfig::testCsaFile(file_name);

    const Record record=CsaFile(file_name).getRecord();
    const vector<osl::Move> moves=record.getMoves();

    NumEffectState state(record.getInitialState());
    Eval eval(state);
    
    for (unsigned int i=0; i<moves.size(); i++)
    {
      const Move m = moves[i];
      ApplyMoveOfTurn::doMove(state, m);
      eval.update(state, m);	// update with new state
      const Eval new_eval(state);
      if (new_eval.value() != eval.value()) {
	std::cerr << state << std::endl << m << std::endl;
      }
      CPPUNIT_ASSERT_EQUAL(new_eval.value(), eval.value());
    }
  }
}


#endif /* TEST_EVAL_CONSISTENCYTEST_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
