MODULE VO:Dlg:Input;

IMPORT (*O := VO:Base:Object,*)

       V := VO:Model:Value,

       W := VO:Window;

TYPE
  ModelEntry        = POINTER TO ModelEntryDesc;
  ModelEntryDesc    = RECORD
                        model : V.ValueModel;
                        next  : ModelEntry;
                      END;

  InputDialog     * = POINTER TO InputDialogDesc;
  InputDialogDesc * = RECORD (W.WindowDesc)
                        modelList : ModelEntry;
                        result-   : BOOLEAN;
                      END;

  PROCEDURE (d : InputDialog) Init*;

  BEGIN
    d.Init^;

    d.modelList:=NIL;
    d.result:=FALSE;
  END Init;

  PROCEDURE (d : InputDialog) AddModel*(model : V.ValueModel);

  VAR
    entry : ModelEntry;

  BEGIN
    NEW(entry);
    entry.model:=model;
    entry.next:=d.modelList;

    d.modelList:=entry;
  END AddModel;

  PROCEDURE (d : InputDialog) ClearModelList*;

  BEGIN
    d.modelList:=NIL;
  END ClearModelList;

  PROCEDURE (d : InputDialog) Backup;

  VAR
    entry : ModelEntry;

  BEGIN
    entry:=d.modelList;
    WHILE entry#NIL DO
      entry.model.Backup;
      entry:=entry.next;
    END;
  END Backup;

  PROCEDURE (d : InputDialog) DropBackup;

  VAR
    entry : ModelEntry;

  BEGIN
    entry:=d.modelList;
    WHILE entry#NIL DO
      entry.model.DropBackup;
      entry:=entry.next;
    END;
  END DropBackup;

  PROCEDURE (d : InputDialog) Restore;

  VAR
    entry : ModelEntry;

  BEGIN
    entry:=d.modelList;
    WHILE entry#NIL DO
      entry.model.Restore;
      entry:=entry.next;
    END;
  END Restore;

  PROCEDURE (d : InputDialog) ExitOK*;

  BEGIN
    d.result:=TRUE;
    d.Exit;
  END ExitOK;

  PROCEDURE (d : InputDialog) ExitCancel*;

  BEGIN
    d.result:=FALSE;
    d.Exit;
  END ExitCancel;

  PROCEDURE (d : InputDialog) Open*;

  BEGIN
    d.result:=FALSE;
    d.Backup;

    d.Open^;
  END Open;

  PROCEDURE (d : InputDialog) Close*;

  BEGIN
    d.Close^;

    IF d.result THEN
      d.DropBackup;
    ELSE
      d.Restore;
    END;

    d.ClearModelList;
  END Close;

END VO:Dlg:Input.