
(**
   A senseless demo-programm for VisualOberon.
**)

MODULE XTest;

(*
    Demo for VisualOberon.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D   := VO:Base:Display,
       E   := VO:Base:Event,
       O   := VO:Base:Object,
       Z   := VO:Base:Size,

       MD  := VO:Dlg:Msg,

       DS  := VO:Model:DataStream,
       TM  := VO:Model:Table,
       V   := VO:Model:Value,

              VO:Prefs:All,  (* Include preferences for all objects *)
       PG  := VO:Prefs:GUI,

       A   := VO:Array,
       B   := VO:Button,
       BO  := VO:Bool,
       C   := VO:Combo,
       CA  := VO:ColorArea,
       CL  := VO:Clock,
       FG  := VO:FrameGroup,
       FU  := VO:FuelGauge,
       G   := VO:Object,
       L   := VO:Label,
       LC  := VO:LightChain,
       LED := VO:LED,
(*       LF  := VOLLFor,*)
(*       LI  := VOLLInt,*)
       M   := VO:Menu,
       OZ  := VO:Oszil,
       P   := VO:Panel,
       PA  := VO:Pane,
       PW  := VO:Power,
       Q   := VO:QuickHelp,
       R   := VO:Radio,
       S   := VO:Space,
       SC  := VO:StringClock,
       SL  := VO:Slider,
       ST  := VO:String,
       STL := VO:StatusLine,
       T   := VO:Text,
       TA  := VO:Tab,
       TB  := VO:Toolbar,
       TL  := VO:Table,
       W   := VO:Window,
       WF  := VO:WireFrame,
       WG  := VO:WindowGroup,
       X   := VO:Image,

(*              C,*)
              Err;

CONST
  quitId     = 100;
  settingsId = 101;
  aboutId    = 103;

TYPE
TYPE
  Window     = POINTER TO WindowDesc;
  WindowDesc = RECORD (W.WindowDesc)
                 current   : V.IntModel;
                 stream    : DS.StreamLongModel;
                 topPos    : V.IntModel;

                 popup     : W.Window;
                 fTimeOut  : D.TimeOut;

                 status    : T.Text;
                 fuel      : FU.FuelGauge;
               END;

VAR
  w           : Window;

(*  dir         : LI.DIRPtr;
  dirEntry    : LI.direntPtr;
  dirName     : C.charPtr1d;*)

  msg2Exit    : D.Msg2Exit;

  i           : LONGINT;

  PROCEDURE NewImageEntry*(file : ARRAY OF CHAR):G.Object;

  VAR
    image : X.Image;

  BEGIN
    NEW(image);
    image.Init;
    image.SetAlignment(G.alignLeft,G.alignCenter);
    image.SetFilename(file);

    RETURN image;
  END NewImageEntry;

  PROCEDURE NewImage*(file : ARRAY OF CHAR):X.Image;

  VAR
    image : X.Image;

  BEGIN
    NEW(image);
    image.Init;
    image.SetAlignment(G.alignCenter,G.alignCenter);
    image.SetFilename(file);

    RETURN image;
  END NewImage;

  PROCEDURE MakeOKPopup(gadget : B.Button):W.Window;

  VAR
    array      : A.Array;
    button1,
    button2    : B.Button;
    open       : W.Msg2Open;
    close      : W.Msg2Close;
    popup      : W.Window;

  BEGIN
    (* Make popupwindow *)

    NEW(popup);
    popup.Init;
    popup.SetStyle(W.popup);

    NEW(array);
    array.Init;
    array.Set(2,TRUE);
    array.SetFlags({G.horizontalFlex,G.verticalFlex});

      NEW(button1);
      button1.Init;
      button1.SetFlags({G.horizontalFlex,G.verticalFlex});
      button1.SetLabelText("Ok*");
      popup.AddFocusObject(button1);
    array.Add(button1);

      NEW(button2);
      button2.Init;
      button2.SetFlags({G.horizontalFlex,G.verticalFlex});
      button2.SetLabelText("Cancel^");
      popup.AddFocusObject(button2);
    array.Add(button2);

    popup.SetTop(array);
    popup.SetReference(gadget);
    NEW(open);
    open.destination:=popup;
    gadget.AddHandler(open, B.pressedMsg);
    NEW(close);
    close.destination:=popup;
    button1.AddHandler(close, B.pressedMsg);
    NEW(close);
    close.destination:=popup;
    button2.AddHandler(close, B.pressedMsg);
    RETURN popup;
  END MakeOKPopup;

  PROCEDURE (w : Window) Receive*(message : O.Message);

  BEGIN
    WITH
      message : B.PressedMsg DO
        w.status.SetText("Button pressed!");
        RETURN;
    | message : ST.EnteredMsg DO
        w.status.SetText("Text entered!");
        RETURN;
    | message : M.SelectedMsg DO
        w.status.SetText("Menuitem selected!");
        CASE message.id OF
          settingsId:
            PG.settings.SetParent(w);
            PG.settings.SetPosition(D.centerOnParent,D.centerOnParent);
            PG.settings.Open;
            PG.settings.EventLoop;
            PG.settings.Close;
        | quitId:
            D.display.Exit;
        | aboutId:
            IF MD.Dialog(w,
                         "About XTest",
                         "XTest  1997 Tim Teulings\n\nXTest is a demo for the VisualOberon package",
                         "_Ok#",
                         MD.info)#NIL THEN END;
        ELSE
        END;
        RETURN;
    | message : D.TimeOutMsg DO
        IF message.timeOut=w.fTimeOut THEN
          w.current.SetLongint((w.current.GetLongint()+1) MOD 101);
          w.stream.SetValue((w.current.GetLongint()+1) MOD 101,0);
          w.fTimeOut:=D.display.AddTimeOut(0,100,w);
          RETURN;
        END;
    ELSE
      w.Receive^(message);
    END;
  END Receive;

  PROCEDURE (w : Window) PreInit*;

  VAR
  anim        : WF.WireFrame;
  button      : B.Button;
  boolModel   : V.BoolModel;
  bool        : BO.Bool;
  clock       : CL.Clock;
  color       : CA.ColorArea;
  combo       : C.Combo;
  intModel    : V.IntModel;
  label       : L.Label;
  led         : LED.LED;
  light       : LC.LightChain;
  menu,
  sub         : M.Menu;
  pane1,
  pane2,
  pane3       : PA.Pane;
  strip       : M.MenuStrip;
  text        : T.Text;
  tool        : TB.Toolbar;
  horiz,
  panel       : P.Panel;
  power       : PW.Power;
  radio       : R.Radio;
  space       : S.Space;
  slider      : SL.Slider;
  stringClock : SC.StringClock;
  stringModel : V.StringModel;
  string      : ST.String;
  stl         : STL.StatusLine;
  tab         : TA.Tab;
  frame       : FG.FrameGroup;
  wGroup      : WG.WindowGroup;
  lText       : T.Text;
  oszil       : OZ.Oszil;
  table       : TL.Table;
  tableModel,
  tableModel2,
  comboModel  : TM.LTableModel;


  BEGIN

  NEW(w.current);
  w.current.Init;
  w.current.SetLongint(0);

  NEW(w.stream);
  w.stream.Init;
  w.stream.SetNotificationMode(DS.notifyImplicit);
  w.stream.SetSize(1);

  NEW(w.topPos);
  w.topPos.Init;
  w.topPos.SetLongint(42);

  NEW(tableModel);
  tableModel.Init;

  tableModel.AppendEntry;
  tableModel.SetString(1,1,"Entry 1");
  tableModel.AppendEntry;
  tableModel.SetString(1,2,"Entry 2");
  tableModel.AppendEntry;
  tableModel.SetString(1,3,"Entry 3");
  tableModel.AppendEntry;
  tableModel.SetString(1,4,"Entry 4");
  tableModel.AppendEntry;
  tableModel.SetString(1,5,"Entry 5");
  tableModel.AppendEntry;
  tableModel.SetString(1,6,"Entry 6");
  tableModel.AppendEntry;
  tableModel.SetString(1,7,"Entry 7");
  tableModel.AppendEntry;
  tableModel.SetString(1,8,"Entry 8");
  tableModel.AppendEntry;
  tableModel.SetString(1,9,"Entry 9");
  tableModel.AppendEntry;
  tableModel.SetString(1,10,"Entry 10");
  tableModel.AppendEntry;
  tableModel.SetString(1,11,"Entry 11");
  tableModel.AppendEntry;
  tableModel.SetString(1,12,"Entry 12");
  tableModel.AppendEntry;
  tableModel.SetString(1,13,"Entry 13");
  tableModel.AppendEntry;
  tableModel.SetString(1,14,"Entry 14");
  tableModel.AppendEntry;
  tableModel.SetString(1,15,"Entry 15");
  tableModel.AppendEntry;
  tableModel.SetString(1,16,"Entry 16");
  tableModel.AppendEntry;
  tableModel.SetString(1,17,"Entry 17");
  tableModel.AppendEntry;
  tableModel.SetString(1,18,"Entry 18");
  tableModel.AppendEntry;
  tableModel.SetString(1,19,"Entry 19");
  tableModel.AppendEntry;
  tableModel.SetString(1,20,"Entry 20");

  NEW(tableModel2);
  tableModel2.Init;
(*  tableModel2.AppendEntryObject(NewImageEntry("xpm/new.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/open.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/save.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/redo.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/undo.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/first.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/left.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/current.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/right.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/last.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/cut.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/copy.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/paste.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/insert.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/export.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/help.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/mail.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/followmail.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/remail.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/news.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/renews.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/pgp.xpm"));
  tableModel2.AppendEntryObject(NewImageEntry("xpm/popup.xpm"));*)

    NEW(comboModel);
    comboModel.Init;

    comboModel.AppendEntry;
    comboModel.SetString(1,1,"Entry 1");
    comboModel.AppendEntry;
    comboModel.SetString(1,2,"Entry 2");
    comboModel.AppendEntry;
    comboModel.SetString(1,3,"Entry 3");
    comboModel.AppendEntry;
    comboModel.SetString(1,4,"Entry 4");
    comboModel.AppendEntry;
    comboModel.SetString(1,5,"Entry 5");
    comboModel.AppendEntry;
    comboModel.SetString(1,6,"Entry 6");
    comboModel.AppendEntry;
    comboModel.SetString(1,7,"Entry 7");
    comboModel.AppendEntry;
    comboModel.SetString(1,8,"Entry 8");
    comboModel.AppendEntry;
    comboModel.SetString(1,9,"Entry 9");
    comboModel.AppendEntry;
    comboModel.SetString(1,10,"Entry 10");

    (* The submenues will be added later *)

    NEW(tab);
    tab.Init;
    tab.SetFlags({G.horizontalFlex,G.verticalFlex});
    w.AddFocusObject(tab);

        NEW(light);
        light.Init;
        light.SetFlags({G.horizontalFlex});
        light.SetText("Welcome to VisualOberon!" );


    tab.AddStringTab("Welcome",light);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex,G.verticalFlex});
(*      frame.SetFrame(F.groupFrame);*)
      frame.SetTextLabel("Text...");

        lText:=T.MakeLeftText("This is a\n\eamultiline\en text!\nCreated using the \ebVOText-class\en!\n\erRight alligned\n\ec\eucentered...\en\n...over two lines\n\elSpalte 1 \tSpalte 2 \tSpalte 3\neins \tzwei \tdrei\n\n\en\ew\euThis is a text in warning color!\en\n\nWe also support different fonts:\nThis f.e. is written with a \effixed font\ep!");
        lText.SetHelpObject(Q.InitHelp(T.MakeLeftText("The powerfull textimage\nof VisualOberon!"),lText));

      frame.SetObject(lText);
    tab.AddStringTab("Text",frame);

      horiz:=P.CreatePanel();
      horiz.Set(P.horizontal);
      horiz.SetFlags({G.horizontalFlex,G.verticalFlex});

        space:=S.CreateHSpace();
        space.SetFlags({G.horizontalFlex});
      horiz.Add(space);

        NEW(label);
        label.Init;
        label.Set(TRUE);
        label.SetHelpObject(Q.InitHelp(T.MakeLeftText("Bool-gadgets!"),label));

          NEW(boolModel);
          boolModel.Init;
          boolModel.SetBoolean(TRUE);

          FOR i:=0 TO 4 DO
            NEW(bool);
            bool.Init;
            bool.SetModel(boolModel);
            IF i=0 THEN
              w.AddFocusObject(bool);
            ELSE
              w.AddFocusObjectToGroup(bool);
            END;
          label.AddTextLabel("CheckMark",bool);
          END;

          NEW(led);
          led.Init;
          led.SetModel(boolModel);
          label.AddTextLabel("Power LED",led);
      horiz.Add(label);

        NEW(space);
        space.Init;
        space.Set(FALSE,S.normal);
        space.SetFlags({G.horizontalFlex});
      horiz.Add(space);

        NEW(label);
        label.Init;
        label.Set(TRUE);
        label.SetHelpObject(Q.InitHelp(T.MakeLeftText("Radiobuttons..."),label));

        NEW(intModel);
        intModel.Init;
        intModel.SetLongint(0);

        FOR i:=0 TO 4 DO
          NEW(radio);
          radio.Init;
          radio.SetModel(intModel);
          radio.SetIndex(i);
          IF i=0 THEN
            w.AddFocusObject(radio);
          ELSE
            w.AddFocusObjectToGroup(radio);
          END;
        label.AddTextLabel("Radiobutton",radio);
        END;
      horiz.Add(label);

        NEW(space);
        space.Init;
        space.Set(FALSE,S.normal);
        space.SetFlags({G.horizontalFlex});
      horiz.Add(space);

      text:=T.MakeCenterText("B&R");
    tab.AddStringTab("B&R",horiz);

      NEW(panel);
      panel.Init;
      panel.Set(P.vertical);
      panel.SetFlags({G.horizontalFlex,G.verticalFlex});

        NEW(slider);
        slider.Init;
        slider.Set(FALSE);
        slider.SetFlags({G.horizontalFlex});
        slider.SetRange(0,100);
        slider.SetModel(w.topPos);
        w.AddFocusObject(slider);
      panel.Add(slider);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
      panel.Add(space);

        NEW(button);
        button.Init;
        button.SetLabelText("_Press me for \espopup\en!#");
        w.AddFocusObject(button);
        button.Forward(B.pressedMsg,w);
        button.SetHelpObject(Q.InitHelp(T.MakeLeftText("Press this button\nto get a little\npopup-menu!"),button));
        w.popup:=MakeOKPopup(button);
      panel.Add(button);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
      panel.Add(space);

        NEW(button);
        button.Init;
        button.SetText("I'm disabled!");
        button.Disable(TRUE);
        button.SetHelpObject(Q.InitHelp(T.MakeLeftText("This one is disabled!"),button));
        w.AddFocusObject(button);
      panel.Add(button);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
      panel.Add(space);

        NEW(intModel);
        intModel.Init;
        intModel.SetLongint(2);

        combo:=C.CreateTextCombo();
        combo.SetTableModel(comboModel);
        combo.SetMinWidth(Z.unit,20);
        combo.SetHelpObject(Q.InitHelp(T.MakeLeftText("This is a combo gadget."),combo));
        w.AddFocusObject(combo);
      panel.Add(combo);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
      panel.Add(space);

        NEW(oszil);
        oszil.Init;
        oszil.SetFlags({G.horizontalFlex,G.verticalFlex});
        oszil.SetHeight(Z.unit,4);
        oszil.SetRange(0,150);
        oszil.SetInterval(100,10);
        oszil.SetModel(w.stream);
      panel.Add(oszil);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
      panel.Add(space);

        NEW(w.fuel);
        w.fuel.Init;
        w.fuel.SetFlags({G.horizontalFlex});
        w.fuel.SetRange(0,100);
        w.fuel.SetModel(w.current);
      panel.Add(w.fuel);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
      panel.Add(space);

        NEW(stringModel);
        stringModel.Init;
        stringModel.SetString("VisualOberon is really, really, really, really, really fantastic!");

        NEW(string);
        string.Init;
        string.SetFlags({G.horizontalFlex});
        string.SetHelpObject(Q.InitHelp(T.MakeLeftText("A simple string gadget!"),string));
        string.SetModel(stringModel);
        w.AddFocusObject(string);
        string.Forward(ST.enteredMsg,w);
      panel.Add(string);

        NEW(space);
        space.Init;
        space.Set(TRUE,S.normal);
      panel.Add(space);

        NEW(stringModel);
        stringModel.Init;
        stringModel.SetString("Drop on me!");

        NEW(string);
        string.Init;
        string.SetFlags({G.horizontalFlex});
        string.SetHelpObject(Q.InitHelp(T.MakeLeftText("A simple string gadget!"),string));
        string.SetModel(stringModel);
        w.AddFocusObject(string);
        string.Forward(ST.enteredMsg,w);
      panel.Add(string);

    tab.AddStringTab("Other",panel);

      NEW(horiz);
      horiz.Init;
      horiz.Set(P.horizontal);
      horiz.SetFlags({G.horizontalFlex,G.verticalFlex});

        table:=TL.CreateTable();
        table.SetFlags({G.horizontalFlex,G.verticalFlex});
        table.SetShowHeader(FALSE);
        table.SetModel(tableModel);
        tableModel.SetSelectionType(TM.singleLineSelect);
        table.SetHelpObject(Q.InitHelp(T.MakeLeftText("VisualOberon also supports\na table gadget!"),table));
        w.AddFocusObject(table.table);
      horiz.Add(table);

      text:=T.MakeCenterText("Table");
    tab.AddStringTab("Table",horiz);

      NEW(horiz);
      horiz.Init;
      horiz.Set(P.horizontal);
      horiz.SetFlags({G.horizontalFlex,G.verticalFlex});

        table:=TL.CreateTable();
        table.SetFlags({G.horizontalFlex,G.verticalFlex});
        table.SetShowHeader(FALSE);
        table.SetModel(tableModel2);
        table.table.SetRowHeight(24);
        tableModel2.SetSelectionType(TM.singleLineSelect);
        table.SetHelpObject(Q.InitHelp(T.MakeLeftText("VisualOberon also supports\na table gadget!"),table));
        w.AddFocusObject(table.table);
      horiz.Add(table);

    tab.AddStringTab("Image",horiz);

      NEW(clock);
      clock.Init;
      clock.SetFlags({G.horizontalFlex,G.verticalFlex});
      clock.ShowFrame(FALSE);
      clock.SetHelpObject(Q.InitHelp(T.MakeLeftText("This is the VO clock!"),clock));
    tab.AddStringTab("Clock",clock);

      NEW(pane1);
      pane1.Init;
      pane1.SetFlags({G.horizontalFlex,G.verticalFlex});
      pane1.Set(PA.vertical);

        NEW(pane2);
        pane2.Init;
        pane2.SetFlags({G.horizontalFlex,G.verticalFlex});
        pane2.Set(PA.horizontal);

          NEW(anim);
          anim.Init;
          anim.SetFlags({G.horizontalFlex,G.verticalFlex});
          anim.SetWidth(Z.unit,15);
          anim.SetHeight(Z.unit,15);
          anim.SetViewer(0,0,-2000,-500);
(*        (* Front plane *)
        anim.AddLine(-25, 25,25, 25, 25,25);
        anim.AddLine( 25, 25,25, 25,-25,25);
        anim.AddLine( 25,-25,25,-25,-25,25);
        anim.AddLine(-25,-25,25,-25, 25,25);

        (* back plane *)
        anim.AddLine(-25, 25,-25, 25, 25,-25);
        anim.AddLine( 25, 25,-25, 25,-25,-25);
        anim.AddLine( 25,-25,-25,-25,-25,-25);
        anim.AddLine(-25,-25,-25,-25, 25,-25);

        (* connections between front and back *)
        anim.AddLine( 25, 25,25, 25, 25,-25);
        anim.AddLine(-25,-25,25,-25,-25,-25);
        anim.AddLine(-25, 25,25,-25, 25,-25);
        anim.AddLine( 25,-25,25, 25,-25,-25);*)

          (* outer O *)
          anim.AddLine( 50, 0,0, 50,50,0);
          anim.AddLine( 50,50,0,-50,50,0);
          anim.AddLine(-50, 0,0,-50,50,0);
          anim.AddLine( 50, 0,0,-50, 0,0);

          (* inner O *)
          anim.AddLine( 40,10,0, 40,40,0);
          anim.AddLine( 40,40,0,-40,40,0);
          anim.AddLine(-40,10,0,-40,40,0);
          anim.AddLine( 40,10,0,-40,10,0);

          (* V *)
          anim.AddLine( 50,  0,0,50, -25,0);
          anim.AddLine( 50,-25,0, 0, -25,0);

          anim.AddLine(-50,  0,0,50,-100,0);

          anim.AddLine( 50,-75,0,50,-100,0);
          anim.AddLine(  0,-25,0,50, -75,0);
        pane2.Add(anim);


          NEW(color);
          color.Init;
          color.SetFlags({G.horizontalFlex,G.verticalFlex});
          color.SetWidth(Z.unit,15);
          color.SetHeight(Z.unit,15);
          color.SetColor(D.halfShadowColor);
        pane2.Add(color);

      pane1.Add(pane2);

        NEW(pane3);
        pane3.Init;
        pane3.SetFlags({G.horizontalFlex,G.verticalFlex});
        pane3.Set(PA.horizontal);

          NEW(color);
          color.Init;
          color.SetFlags({G.horizontalFlex,G.verticalFlex});
          color.SetWidth(Z.unit,30);
          color.SetHeight(Z.unit,15);
          color.SetColor(D.halfShadowColor);
        pane3.Add(color);

          NEW(power);
          power.Init;
          power.SetWidth(Z.unit,15);
          power.SetHeight(Z.unit,15);
          power.SetFlags({G.horizontalFlex,G.verticalFlex});
        pane3.Add(power);

      pane1.Add(pane3);

    tab.AddStringTab("Pane",pane1);

    NEW(strip);
    strip.Init;

      menu:=M.InitMenu();
        sub:=M.InitMenu();
          sub.AddTextItem("New",0);
          sub.AddTextItemSC("Open...","a+o",1,E.altMask,"o",w);
          sub.AddTextItemSC("Save","a+s",2,E.altMask,"o",w);
          sub.AddSeparator;
          sub.AddTextItemSC("\ew\ebQuit","a+q",quitId,E.altMask,"q",w);
      menu.AddTextSubMenu("File",sub);
    strip.AddPullDownMenuText("File",sub);
        sub:=M.InitMenu();
          sub.AddTextItemSC("Cut","a+x",4,E.altMask,"x",w);
          sub.AddTextItemSC("Copy","a+c",5,E.altMask,"c",w);
          sub.AddTextItemSC("Paste","a+v",6,E.altMask,"v",w);
      menu.AddTextSubMenu("Edit",sub);
    strip.AddPullDownMenuText("Edit",sub);
        sub:=M.InitMenu();
          sub.AddTextItemSC("Find...","a+f",7,E.altMask,"f",w);
          sub.AddTextItemSC("Find next","a+n",8,E.altMask,"n",w);
          sub.AddSeparator;
          sub.AddTextItemSC("Replace...","a+r",9,E.altMask,"r",w);
          sub.AddTextItemSC("Replace next","a+y",10,E.altMask,"y",w);
          sub.AddSeparator;
          sub.AddTextItemSC("Goto","a+g",11,E.altMask,"g",w);
      menu.AddTextSubMenu("Search",sub);
    strip.AddPullDownMenuText("Search",sub);
        sub:=M.InitMenu();
          sub.AddTextItem("No extras currently :-)",12);
      menu.AddTextSubMenu("Extras",sub);
    strip.AddPullDownMenuText("Extras",sub);
        sub:=M.InitMenu();
          sub.AddTextItemSC("Help on item...","a+?",13,E.altMask,"?",w);
          sub.AddTextItem("Tutorial",14);
          sub.AddSeparator;
          sub.AddTextItemSC("\ebVO settings...","a+!",settingsId,E.altMask,"!",w);
          sub.AddSeparator;
          sub.AddTextItem("\ebAbout",aboutId);
      menu.AddTextSubMenu("Help",sub);
    strip.AddPullDownMenuText("Help",sub);
      menu.Forward(M.selectedMsg,w);
    tab.SetMenuObject(menu);
    tab.SetHelpObject(Q.InitHelp(T.MakeLeftText("This is a quick help\nfor this Tabgadget!"),tab));

  NEW(tool);
  tool.Init;
  tool.SetFlags({G.horizontalFlex});
  tool.SetEqualSize(TRUE);

    NEW(button);
    button.Init;
    button.SetFlags({G.horizontalFlex});
    button.SetType(B.toolBar);
    button.SetImage(NewImage("xpm/new.xpm"));
    button.SetHelpObject(Q.InitHelp(T.MakeLeftText("Tooltip"),button));
  tool.Add(button);
    NEW(button);
    button.Init;
    button.SetFlags({G.horizontalFlex});
    button.SetType(B.toolBar);
    button.SetImage(NewImage("xpm/open.xpm"));
    button.SetHelpObject(Q.InitHelp(T.MakeLeftText("Tooltip"),button));
  tool.Add(button);
    NEW(button);
    button.Init;
    button.SetFlags({G.horizontalFlex});
    button.SetType(B.toolBar);
    button.SetImage(NewImage("xpm/save.xpm"));
    button.SetHelpObject(Q.InitHelp(T.MakeLeftText("Tooltip"),button));
  tool.Add(button);
    NEW(button);
    button.Init;
    button.SetFlags({G.horizontalFlex});
    button.SetType(B.toolBar);
    button.SetImage(NewImage("xpm/help.xpm"));
    button.SetHelpObject(Q.InitHelp(T.MakeLeftText("Tooltip"),button));
  tool.Add(button);

  NEW(stl);
  stl.Init;
  stl.SetFlags({G.horizontalFlex});

    NEW(w.status);
    w.status.Init;
    w.status.SetFlags({G.verticalFlex,G.horizontalFlex});
    w.status.SetText("Ok.");
  stl.Add(w.status);

    NEW(stringClock);
    stringClock.Init;
    stringClock.SetFlags({G.verticalFlex});
  stl.Add(stringClock);

  NEW(wGroup);
  wGroup.Init;
  wGroup.Set(strip,tab,TRUE);
  wGroup.SetToolbar(tool);
  wGroup.SetStatusLine(stl);

  w.SetTop(wGroup);

    w.PreInit^;
  END PreInit;

BEGIN
  D.display.SetAppName("XTest");

  IF ~D.display.Open() THEN
    Err.String("Cannot init application!"); Err.Ln;
    HALT(1);
  END;

  NEW(w);
  w.Init;
  w.SetTitle("XTest");

  NEW(msg2Exit);
  msg2Exit.destination:=D.display;
  w.AddHandler(msg2Exit,W.closeMsg);

  w.Open;
  w.fTimeOut:=D.display.AddTimeOut(0,100,w);

  D.display.EventLoop;

  w.Close;

(*  dir:=LI.opendir(".");
  IF dir#NIL THEN
    dirEntry:=LI.readdir(dir);
    WHILE dirEntry#NIL DO
      dirName:=LF.GetDirName(dirEntry);
      i:=0;
      WHILE dirName[i]#0X DO
        Err.Char(dirName[i]);
        INC(i);
      END;
      Err.Ln;
      dirEntry:=LI.readdir(dir);
    END;
  ELSE
    Err.String("Cannot open directory");
  END;*)

  D.display.Close;

END XTest.