(**
  VisualOberon preferences program for oo(2)c.
**)

MODULE VOOOCP;

(*
    VisualOberon preferences program for oo(2)c.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D   := VO:Base:Display,

       TM  := VO:Model:Table,
       V   := VO:Model:Value,

              VO:Prefs:All,  (* Include preferences for all objects *)

       B   := VO:Bool,
       G   := VO:Object,
       L   := VO:Label,
       P   := VO:Panel,
       PB  := VO:Button,
(*       Q   := VOQuickHelp,*)
       S   := VO:String,
       SP  := VO:Space,
       T   := VO:Text,
       TA  := VO:Tab,
       TB  := VO:Table,
       W   := VO:Window,
       WG  := VO:WindowGroup,

              Err;


VAR
  w         : W.Window;
  wGroup    : WG.WindowGroup;
  label     : L.Label;
  text      : T.Text;
  tab1,tab2 : TA.Tab;

  msg2Exit  : D.Msg2Exit;

  PROCEDURE AddBool(label : L.Label; text : ARRAY OF CHAR);

  VAR
    bool      : B.Bool;
    boolModel : V.BoolModel;

  BEGIN
    NEW(bool);
    bool.Init;
      NEW(boolModel);
      boolModel.Init;
      boolModel.SetBoolean(FALSE);
    bool.SetModel(boolModel);
    label.AddTextLabel(text,bool);
    w.AddFocusObject(bool);
  END AddBool;

  PROCEDURE AddString(label : L.Label; text : ARRAY OF CHAR);

  VAR
    string      : S.String;
    stringModel : V.StringModel;

  BEGIN
    NEW(string);
    string.Init;
    string.SetFlags({G.horizontalFlex});
      NEW(stringModel);
      stringModel.Init;
      stringModel.SetString("");
    string.SetModel(stringModel);
(*    string.SetLabel(label.AddTextLabelFull(text,bool));*)
    label.AddTextLabel(text,string);
    w.AddFocusObject(string);
  END AddString;

  PROCEDURE AddList():G.Object;

  VAR
    button     : PB.Button;
    table      : TB.Table;
    tableModel : TM.LTableModel;
    horiz,vert : P.Panel;
    space      : SP.Space;

  BEGIN
    NEW(horiz);
    horiz.Init;
    horiz.Set(P.horizontal);
    horiz.SetFlags({G.horizontalFlex,G.verticalFlex});

      NEW(tableModel);
      tableModel.Init;

      table:=TB.CreateTable();
      table.SetModel(tableModel);
      table.SetFlags({G.horizontalFlex,G.verticalFlex});
      table.SetShowHeader(FALSE);
      tableModel.SetSelectionType(TM.singleLineSelect);
      w.AddFocusObject(table.table);
    horiz.Add(table);
      NEW(space);
      space.Init;
      space.Set(FALSE,SP.normal);
    horiz.Add(space);
      NEW(vert);
      vert.Init;
      vert.Set(P.vertical);
      vert.SetFlags({G.verticalFlex});
        NEW(button);
        button.Init;
        button.SetLabelText("_Up");
        button.SetFlags({G.horizontalFlex});
      vert.Add(button);
        NEW(space);
        space.Init;
        space.Set(TRUE,SP.normal);
      vert.Add(space);
        NEW(button);
        button.Init;
        button.SetLabelText("_Down");
        button.SetFlags({G.horizontalFlex});
      vert.Add(button);
        NEW(space);
        space.Init;
        space.Set(TRUE,SP.normal);
      vert.Add(space);
        NEW(button);
        button.Init;
        button.SetLabelText("_Add");
        button.SetFlags({G.horizontalFlex});
      vert.Add(button);
        NEW(space);
        space.Init;
        space.Set(TRUE,SP.normal);
      vert.Add(space);
        NEW(button);
        button.Init;
        button.SetLabelText("_Remove");
        button.SetFlags({G.horizontalFlex});
      vert.Add(button);
        NEW(space);
        space.Init;
        space.Set(TRUE,SP.normal);
        space.SetFlags({G.verticalFlex});
      vert.Add(space);
    horiz.Add(vert);

    RETURN horiz;
  END AddList;


BEGIN
  D.display.SetAppName("VOOOCP");
  IF ~D.display.Open() THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  NEW(w);
  w.Init;

  NEW(wGroup);
  wGroup.Init;

    NEW(tab1);
    tab1.Init;
    tab1.SetFlags({G.horizontalFlex,G.verticalFlex});
    w.AddFocusObject(tab1);

      NEW(label);
      label.Init;
      label.Set(TRUE);

        AddBool(label,"Verbose");
        AddBool(label,"Optimize");

        AddString(label,"Errormsgs.");
        AddString(label,"C compiler");
        AddString(label,"C compiler flags");
        AddString(label,"coptflags");
        AddString(label,"Linker flags");
        AddString(label,"GC flags");

    tab1.AddTab(T.MakeCenterText("Options"),label);

      NEW(label);
      label.Init;
      label.Set(TRUE);

        AddBool(label,"Warnings");
        AddBool(label,"Assertions");
        AddBool(label,"Initialize");
        AddBool(label,"Stack check");
        AddBool(label,"Conformant mode");
        AddBool(label,"case select check");
        AddBool(label,"Index check");
        AddBool(label,"Range check");
        AddBool(label,"Deref check");
        AddBool(label,"Funct result");
        AddBool(label,"Typegard");
        AddBool(label,"Int div check");
        AddBool(label,"Real div check");

    tab1.AddTab(T.MakeCenterText("Pragmas"),label);

      NEW(tab2);
      tab2.Init;
      tab2.SetFlags({G.horizontalFlex,G.verticalFlex});
      w.AddFocusObject(tab2);
        tab2.AddTab(T.MakeCenterText("Module"),AddList());
        tab2.AddTab(T.MakeCenterText("Symbols"),AddList());
        tab2.AddTab(T.MakeCenterText("C-tmp"),AddList());
        tab2.AddTab(T.MakeCenterText("Objects"),AddList());

    tab1.AddTab(T.MakeCenterText("Paths"),tab2);

      NEW(text);
      text.Init;
    tab1.AddTab(T.MakeCenterText("About..."),T.MakeLeftText("\e\c\e\s\e\9VOOOCP\e\p\n\en\e\c(functionless demo for \esVisualOberon\en)\n\nCopyright 1997\nTim Teulings\n(rael@edge.ping.de)"));
  wGroup.Set(NIL,tab1,TRUE);

  w.SetTop(wGroup);
  w.SetTitle("VOOOCP");
  NEW(msg2Exit);
  msg2Exit.destination:=D.display;
  w.AddHandler(msg2Exit,W.closeMsg);
  w.Open;

  D.display.EventLoop;

  D.display.Close;
END VOOOCP.