MODULE VO:TextPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT F   := VO:Base:Frame,

       FSD := VO:Dlg:FrmSel,

       V   := VO:Model:Value,

       PP  := VO:Prefs:Parser,

       BO  := VO:Bool,
       FG  := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       L   := VO:Label,
       P   := VO:Panel,
       SP  := VO:Space,
       T   := VO:Text,
       TA  := VO:Tab;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (GP.PrefsItemDesc)
                highlight : V.BoolModel;
                frame     : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Text";

    d.SetPrefs(T.prefs);

    NEW(d.frame);
    d.frame.Init;

    NEW(d.highlight);
    d.highlight.Init;
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    bool   : BO.Bool;
    combo  : FSD.FrmSelCombo;
    frame  : FG.FrameGroup;
    label  : L.Label;
    panel  : P.Panel;
    space  : SP.Space;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    object:=d.GetObject^();
    tab:=object(TA.Tab);

    panel:=P.CreatePanel();
    panel.Set(P.vertical);

      frame:=FG.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Focus frame");

        combo:=FSD.CreateFrmSelCombo();
        combo.SetModel(d.frame);
      frame.SetObject(combo);
    panel.Add(frame);

      space:=SP.CreateSpace();
      space.Set(TRUE,SP.normal);
    panel.Add(space);

      frame:=FG.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Options");

        label:=L.CreateLabel();

          bool:=BO.CreateBool();
          bool.SetModel(d.highlight);
          d.window.AddFocusObject(bool);
        label.AddTextLabel("Highlight",bool);
      frame.SetObject(label);
    panel.Add(frame);

    tab.AddTab(T.MakeCenterText(d.name),panel);

    RETURN tab;
  END GetObject;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.Refresh^;

    d.frame.SetLongint(T.prefs.focusFrame);
    d.highlight.SetBoolean(T.prefs.highlight);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    T.prefs.focusFrame:=p.frame.GetLongint();
    T.prefs.highlight:=p.highlight.GetBoolean();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  BEGIN
    p.LoadPrefs^(top);

    F.LoadFrame("focus",top,T.prefs.focusFrame);
    T.prefs.highlight:=top.GetBoolEntry("highlight",T.prefs.highlight);
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    block.AddItemValue("focus",F.internalFrames[T.prefs.focusFrame]);
    block.AddItemBool("highlight",T.prefs.highlight);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:TextPrefs.