(**
   Implements a tab groupobject.

  TODO
  * Hide is suboptimal.
**)

MODULE VO:Multi;

(*
    Implements a unvisible tab gadget.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)


IMPORT D  := VO:Base:Display,
       E  := VO:Base:Event,
       O  := VO:Base:Object,
       U  := VO:Base:Util,

       G  := VO:Object;

CONST
  setMsg* = 0;

TYPE
  Prefs*     = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff of the button is stored.
  **)

  PrefsDesc* = RECORD (G.PrefsDesc)
               END;


  Multi*     = POINTER TO MultiDesc;
  MultiDesc* = RECORD (G.ObjectDesc)
               list,                  (* A linked list of all members *)
               last     : G.Object;
               count    : LONGINT;    (* The number of members *)
               current  : G.Object;
               selected : LONGINT;
             END;

  SetMsg*        = POINTER TO SetMsgDesc;
  SetMsgDesc*    = RECORD (O.MessageDesc)
                     pos* : LONGINT;
                   END;

VAR
  prefs* : Prefs;

  PROCEDURE (m : Multi) Init*;

  BEGIN
    m.Init^;

    m.SetPrefs(prefs);

    m.current:=NIL;
    m.selected:=-1;
  END Init;

  PROCEDURE (m : Multi) CalcSize*;

  VAR
    entry : G.Object;

  BEGIN
    m.width:=0;
    m.height:=0;
    m.minWidth:=0;
    m.minHeight:=0;

    entry:=m.list;
    WHILE entry#NIL DO
      entry.SetParent(m);
      entry.CalcSize;

      m.width:=U.MaxLong(m.width,entry.oWidth);
      m.height:=U.MaxLong(m.height,entry.oHeight);

      m.minWidth:=U.MaxLong(m.minWidth,entry.oMinWidth);
      m.minHeight:=U.MaxLong(m.minHeight,entry.oMinHeight);

      entry:=entry.next;
    END;

    m.CalcSize^;
  END CalcSize;

  PROCEDURE (m : Multi) Add*(object : G.Object);

  BEGIN
    IF m.list=NIL THEN
      m.list:=object;
    ELSE
      m.last.next:=object;
    END;
    m.last:=object;
    object.SetParent(m);
    INC(m.count);
  END Add;

  PROCEDURE (m : Multi) GetEntry(count :LONGINT): G.Object;

  VAR
    entry : G.Object;

  BEGIN
    entry:=m.list;
    WHILE count>1 DO
      entry:=entry.next;
      DEC(count);
    END;
    RETURN entry;
  END GetEntry;

  (**
    Set the nth entry the multi object should display.
  **)

  PROCEDURE (m : Multi) SetEntry*(pos : LONGINT);

  VAR
    old : G.Object;

  BEGIN
    old:=m.current;
    m.current:=m.GetEntry(pos);
    m.selected:=pos;
    IF m.current#old THEN
      IF old#NIL THEN
        old.Hide;
      END;
      m.SetRelayout;
      m.Redraw;
    END;
  END SetEntry;

  PROCEDURE (m : Multi) GetPosObject*(x,y : LONGINT; type : LONGINT):G.Object;

  VAR
    return : G.Object;

  BEGIN
    return:=NIL;
    IF m.current#NIL THEN
      return:=m.current.GetPosObject(x,y,type);
    END;

    IF return=NIL THEN
      RETURN m.GetPosObject^(x,y,type);
    ELSE
      RETURN return;
    END;
  END GetPosObject;

  PROCEDURE (m : Multi) GetDnDObject*(x,y : LONGINT; drag : BOOLEAN):G.Object;

  VAR
    return : G.Object;

  BEGIN
    return:=NIL;
    IF m.current#NIL THEN
      return:=m.current.GetDnDObject(x,y,drag);
    END;

    IF return=NIL THEN
      RETURN m.GetDnDObject^(x,y,drag);
    ELSE
      RETURN return;
    END;
  END GetDnDObject;

  PROCEDURE (m : Multi) HandleMouseEvent*(event : E.MouseEvent;
                                          VAR grab : G.Object):BOOLEAN;

  BEGIN
    IF ~m.visible OR m.disabled THEN
      RETURN FALSE;
    END;

    IF m.current#NIL THEN
      RETURN m.current.HandleMouseEvent(event,grab);
    ELSE
      RETURN FALSE;
    END;
  END HandleMouseEvent;

  PROCEDURE (m : Multi) Layout*;

  BEGIN
    IF m.current#NIL THEN
      m.current.Resize(m.width,m.height);
      m.current.Move(m.x+(m.width-m.current.oWidth) DIV 2,
                     m.y+(m.height-m.current.oHeight) DIV 2);
    END;

    m.Layout^;
  END Layout;

  PROCEDURE (m : Multi) Draw*(x,y,w,h : LONGINT);

  VAR
    draw : D.DrawInfo;

  BEGIN
    m.Draw^(x,y,w,h);

    IF ~m.Intersect(x,y,w,h) THEN
      RETURN;
    END;

    draw:=m.GetDrawInfo();

    draw.InstallClip(x,y,w,h);
    IF m.current#NIL THEN
      draw.SubRegion(m.current.oX,m.current.oY,m.current.oWidth,m.current.oHeight);
    END;
    m.DrawBackground(m.x,m.y,m.width,m.height);
    draw.FreeLastClip;

    IF m.current#NIL THEN
      m.current.Draw(x,y,w,h);
    END;
  END Draw;

  PROCEDURE (m : Multi) Hide*;

  BEGIN
    IF m.visible THEN
      IF m.current#NIL THEN
        m.current.Hide;
      END;
      m.DrawHide;
      m.Hide^;
    END;
  END Hide;

  (**
    The Handler for messages from user and other objects
  **)

  PROCEDURE (m : Multi) Receive*(message : O.Message);

  BEGIN
    WITH
      message: SetMsg DO
        m.SetEntry(message.pos);
    ELSE
    END;
  END Receive;

  PROCEDURE CreateMulti*():Multi;

  VAR
    multi : Multi;

  BEGIN
    NEW(multi);
    multi.Init;

    RETURN multi;
  END CreateMulti;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:Multi.