MODULE VO:KnobPrefs;

(*
    Copyright (C) 2000  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT ISD := VO:Dlg:ImgSel,

       V   := VO:Model:Value,

       PP  := VO:Prefs:Parser,

       K   := VO:Knob,
       P   := VO:Panel,
       T   := VO:Text,
       TA  := VO:Tab,
       FG  := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       VI  := VO:VecImage;

TYPE
  Item*     = POINTER TO ItemDesc;

  (**
   TODO
   Make it only use one ImgSelDlg.
  **)

  ItemDesc* = RECORD (GP.PrefsItemDesc)
                image     : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Knob";

    d.SetPrefs(K.prefs);

    NEW(d.image);
    d.image.Init;
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    combo  : ISD.ImgSelCombo;
    frame  : FG.FrameGroup;
    panel  : P.Panel;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    object:=d.GetObject^();
    tab:=object(TA.Tab);

    panel:=P.CreatePanel();
    panel.Set(P.vertical);

      frame:=FG.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Knob");
        combo:=ISD.CreateImgSelCombo();
        combo.SetModel(d.image);
      frame.SetObject(combo);
    panel.Add(frame);

    tab.AddTab(T.MakeCenterText(d.name),panel);

    RETURN tab;
  END GetObject;

  PROCEDURE (p : Item) Refresh*;

  BEGIN
    p.Refresh^;

    p.image.SetLongint(K.prefs.knob);
  END Refresh;


  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    K.prefs.knob:=p.image.GetLongint();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  VAR
    buffer : ARRAY 256 OF CHAR;
    pos    : LONGINT;

  BEGIN
    p.LoadPrefs^(top);

    IF top.GetStringEntry("knob",buffer) THEN
      pos:=VI.GetImageEntry(buffer);
      IF pos>=0 THEN
        K.prefs.knob:=pos;
      ELSE
        p.ErrorWrongData("knob",buffer);
      END;
    END;
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    block.AddItemValue("knob",VI.images[K.prefs.knob]);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:KnobPrefs.