(**

**)

MODULE VO:ClipTest;

(*
    Implements a simple led with two states: on and off.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D := VO:Base:Display,
       O := VO:Base:Object,

       G := VO:Object;

TYPE
  Prefs*        = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff of the button is stored.
  **)

  PrefsDesc*    = RECORD (G.PrefsDesc)
                  END;

  ClipTest*     = POINTER TO ClipTestDesc;
  ClipTestDesc* = RECORD (G.ImageDesc)
                  END;

VAR
  prefs : Prefs;

  PROCEDURE (d : ClipTest) Init*;

  BEGIN
    d.Init^;
  END Init;

  PROCEDURE (d : ClipTest) CalcSize*;

  BEGIN
    d.width:=120;
    d.height:=120;

    d.minWidth:=d.width;
    d.minHeight:=d.height;

    d.CalcSize^;
  END CalcSize;

  PROCEDURE (d : ClipTest) Draw*(x,y,w,h : LONGINT);

  VAR
    draw : D.DrawInfo;

  BEGIN
    d.Draw^(x,y,w,h);

    draw:=d.GetDrawInfo();

    draw.InstallClip(d.x,d.y,d.width,d.height);
    draw.SubRegion(d.x+d.width DIV 4,d.y+d.height DIV 4,
                   d.width DIV 2,d.height DIV 2);


    (* Rectangle *)
    draw.PushForeground(D.whiteColor);
    draw.FillRectangle(d.x+d.width DIV 4,d.y+d.height DIV 4,
                       d.width DIV 2,d.height DIV 2);
    draw.PopForeground;

    (* Lines *)
    d.DrawBackground(d.x,d.y,d.width,d.height);

    draw.FreeLastClip;
  END Draw;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:ClipTest.