MODULE VO:ButtonPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT F   := VO:Base:Frame,
       Z   := VO:Base:Size,

       FSD := VO:Dlg:FrmSel,

       V   := VO:Model:Value,

       PP  := VO:Prefs:Parser,

       B   := VO:Button,
       BO  := VO:Bool,
       FG  := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       L   := VO:Label,
       P   := VO:Panel,
       SP  := VO:Space,
       T   := VO:Text,
       TA  := VO:Tab;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (GP.PrefsItemDesc)
                frame,
                sFrame,
                iFrame,
                tFrame      : V.IntModel;
                highlight   : V.BoolModel;
                gridDisable : V.BoolModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Button";

    d.SetPrefs(B.prefs);

    NEW(d.frame);
    d.frame.Init;

    NEW(d.sFrame);
    d.sFrame.Init;

    NEW(d.iFrame);
    d.iFrame.Init;

    NEW(d.tFrame);
    d.tFrame.Init;

    NEW(d.highlight);
    d.highlight.Init;

    NEW(d.gridDisable);
    d.gridDisable.Init;
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    combo  : FSD.FrmSelCombo;
    frame  : FG.FrameGroup;
    label  : L.Label;
    panel  : P.Panel;
    space  : SP.Space;
    bool   : BO.Bool;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    object:=d.GetObject^();
    tab:=object(TA.Tab);

    panel:=P.CreatePanel();
    panel.Set(P.vertical);

      frame:=FG.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Frames");

        label:=L.CreateLabel();

          combo:=FSD.CreateFrmSelCombo();
          combo.SetModel(d.frame);
        label.AddTextLabel("normal",combo);

          combo:=FSD.CreateFrmSelCombo();
          combo.SetModel(d.sFrame);
        label.AddTextLabel("small",combo);

          combo:=FSD.CreateFrmSelCombo();
          combo.SetModel(d.iFrame);
        label.AddTextLabel("image",combo);

          combo:=FSD.CreateFrmSelCombo();
          combo.SetModel(d.tFrame);
        label.AddTextLabel("toolbar",combo);
      frame.SetObject(label);
    panel.Add(frame);

      space:=SP.CreateSpace();
      space.Set(TRUE,SP.normal);
    panel.Add(space);

      frame:=FG.CreateFrameGroup();
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Options");

        label:=L.CreateLabel();

          bool:=BO.CreateBool();
          bool.SetModel(d.highlight);
          d.window.AddFocusObject(bool);
        label.AddTextLabel("Highlight label",bool);

          bool:=BO.CreateBool();
          bool.SetModel(d.gridDisable);
          d.window.AddFocusObject(bool);
        label.AddTextLabel("disable with grid",bool);
      frame.SetObject(label);
    panel.Add(frame);

    tab.AddTab(T.MakeCenterText(d.name),panel);

    RETURN tab;
  END GetObject;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.Refresh^;

    d.frame.SetLongint(B.prefs.frame);
    d.sFrame.SetLongint(B.prefs.sFrame);
    d.iFrame.SetLongint(B.prefs.iFrame);
    d.tFrame.SetLongint(B.prefs.tFrame);
    d.highlight.SetBoolean(B.prefs.highlight);
    d.gridDisable.SetBoolean(B.prefs.gridDisable);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    B.prefs.frame:=p.frame.GetLongint();
    B.prefs.sFrame:=p.sFrame.GetLongint();
    B.prefs.iFrame:=p.iFrame.GetLongint();
    B.prefs.tFrame:=p.tFrame.GetLongint();
    B.prefs.highlight:=p.highlight.GetBoolean();
    B.prefs.gridDisable:=p.gridDisable.GetBoolean();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  BEGIN
    p.LoadPrefs^(top);

    Z.LoadSize("hSpace",top,B.prefs.hSpace);
    Z.LoadSize("vSpace",top,B.prefs.vSpace);

    F.LoadFrame("sFrame",top,B.prefs.sFrame);
    F.LoadFrame("iFrame",top,B.prefs.iFrame);
    F.LoadFrame("tFrame",top,B.prefs.tFrame);

    B.prefs.highlight:=top.GetBoolEntry("highlight",B.prefs.highlight);
    B.prefs.gridDisable:=top.GetBoolEntry("gridDisable",B.prefs.gridDisable);
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    Z.SaveSize("hSpace",block,B.prefs.hSpace);
    Z.SaveSize("vSpace",block,B.prefs.vSpace);

    block.AddItemValue("sFrame",F.internalFrames[B.prefs.sFrame]);
    block.AddItemValue("iFrame",F.internalFrames[B.prefs.iFrame]);
    block.AddItemValue("tFrame",F.internalFrames[B.prefs.tFrame]);
    block.AddItemBool("highlight",B.prefs.highlight);
    block.AddItemBool("gridDisable",B.prefs.gridDisable);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:ButtonPrefs.