(**
  This class defines a number of events - based on userinteraction -
  a object (gadget, window) can get. These messages are OS-independant,
  but offer a way to interpret the underlying OS-specific events, however
  the interface to that part of the events is not portable.

  NOTE
  * Not all GUIs can name the qualifiers extactly. F.e. X11 does not make a
    destinction between shift_left and shift_right in the qualifier field
    of an event. use the qualifier mask for that or handle key up and down for
    qualifiers explicitely..
**)

MODULE VO:Base:Event [OOC_EXTENSIONS];

(*
    Classhierachie defining a number of OS-independend messgaes.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT xk := Xkeysymdef;

CONST
  (* type *)
  keyUp       * = 0;
  keyDown     * = 1;
  mouseUp     * = 2;
  mouseDown   * = 3;

  (* qualifiers *)

  none          * =  0;

  button1       * =  1;
  button2       * =  2;
  button3       * =  3;
  button4       * =  4;
  button5       * =  5;

  dragDropButton * = button2;

  qShiftLeft    * =  6;
  qShiftRight   * =  7;
  qCapsLock     * =  8;
  qControlLeft  * =  9;
  qControlRight * = 10;
  qAltLeft      * = 11;
  qAltRight     * = 12;
  qMetaLeft     * = 13;
  qMetaRight    * = 14;
  qSuperLeft    * = 15;
  qSuperRight   * = 16;
  qHyperLeft    * = 17;
  qHyperRight   * = 18;

  (* qualifier masks *)

  shiftMask    * = {qShiftLeft,qShiftRight};
  altMask      * = {qAltLeft,qAltRight};
  controlMask  * = {qControlLeft,qControlRight};
  metaMask     * = {qMetaLeft,qMetaRight};          (* not supported *)
  superMask    * = {qSuperLeft,qSuperRight};        (* not supported *)
  hyperMask    * = {qHyperLeft,qHyperRight};        (* not supported *)

  buttonMask   * = {button1,button2,button3,button4,button5};
  keyMask      * = shiftMask+altMask+controlMask+metaMask+superMask+hyperMask;

  (* key constants *)

  shiftLeft    * = xk.XK_Shift_L;
  shiftRight   * = xk.XK_Shift_R;
  shiftLock    * = xk.XK_Shift_Lock;
  capsLock     * = xk.XK_Caps_Lock;
  scrollLock   * = xk.XK_Scroll_Lock;
  numLock      * = xk.XK_Num_Lock;
  controlLeft  * = xk.XK_Control_L;
  controlRight * = xk.XK_Control_R;
  altLeft      * = xk.XK_Alt_L;
  altRight     * = xk.XK_Alt_R;
  metaLeft     * = xk.XK_Meta_L;
  metaRight    * = xk.XK_Meta_R;
  superLeft    * = xk.XK_Super_L;
  superRight   * = xk.XK_Super_R;
  hyperLeft    * = xk.XK_Hyper_L;
  hyperRight   * = xk.XK_Hyper_R;

  backspace    * = xk.XK_BackSpace;
  delete       * = xk.XK_Delete;
  tab          * = xk.XK_Tab;
  leftTab      * = xk.XK_ISO_Left_Tab;
  return       * = xk.XK_Return;
  escape       * = xk.XK_Escape;
  space        * = xk.XK_space;

  home         * = xk.XK_Home;
  begin        * = xk.XK_Begin;
  end          * = xk.XK_End;
  left         * = xk.XK_Left;
  right        * = xk.XK_Right;
  up           * = xk.XK_Up;
  down         * = xk.XK_Down;
  pageUp       * = xk.XK_Page_Up;
  pageDown     * = xk.XK_Page_Down;
  prior        * = xk.XK_Prior;
  next         * = xk.XK_Next;

  print        * = xk.XK_Print;
  insert       * = xk.XK_Insert;

  f1           * = xk.XK_F1;
  f2           * = xk.XK_F2;
  f3           * = xk.XK_F3;
  f4           * = xk.XK_F4;
  f5           * = xk.XK_F5;
  f6           * = xk.XK_F6;
  f7           * = xk.XK_F7;
  f8           * = xk.XK_F8;
  f9           * = xk.XK_F9;
  f10          * = xk.XK_F10;
  f11          * = xk.XK_F11;
  f12          * = xk.XK_F12;

TYPE
  Event*     = POINTER TO EventDesc;

  (**
    Baseclass for events. Currently all objects get a instance
    of this baseclass and then have to analyse the message by
    evaluating the containing X11-event itself. This may change in the
    future. Display will send generate and send instances of inherited
    Classes thatd define abstract events.
  **)
  EventDesc*      = RECORD [ABSTRACT]
                      reUse* : BOOLEAN;
                    END;

  KeyEvent*       = POINTER TO KeyEventDesc;

  (**
    Keyboard event. The application receives this event when a key
    has been pressed or raised.
  **)

  KeyEventDesc*   = RECORD [ABSTRACT] (EventDesc)
                      type*      : INTEGER; (* type of key event *)
                      qualifier* : SET;
                    END;

  MouseEvent*     = POINTER TO MouseEventDesc;

  (**
    Mouse event. The application recieves this event when one or
    more mousebuttons have been pressed or released. You'll also
    get events when the mouse moves.
  **)

  MouseEventDesc* = RECORD [ABSTRACT] (EventDesc)
                      qualifier* : SET;      (* the qualifier *)
                      x*,y*      : LONGINT;  (* window relative position of mouse *)
                    END;

  ButtonEvent*    = POINTER TO ButtonEventDesc;

  (**
    Mouse event. The application recieves this event when one or
    more mousebuttons have been pressed or released. You'll also
    get events when the mouse moves.
  **)

  ButtonEventDesc* = RECORD [ABSTRACT] (MouseEventDesc)
                       type*   : INTEGER;  (* type of mouse event *)
                       button* : INTEGER;  (* button that caused action *)
                     END;

  MotionEvent*    = POINTER TO MotionEventDesc;

  (**
    Mouse event. The application recieves this event when one or
    more mousebuttons have been pressed or released. You'll also
    get events when the mouse moves.
  **)

  MotionEventDesc* = RECORD [ABSTRACT] (MouseEventDesc)
                     END;

  PROCEDURE (e : KeyEvent) [ABSTRACT] GetText*(VAR string : ARRAY OF CHAR):LONGINT;
  (**
    Returns the ASCII-string corresponding to the keyboard event.

    RESULT
    The number of characters in the string.
  *)
  END GetText;

  PROCEDURE (e : KeyEvent) [ABSTRACT] GetKey*():LONGINT;
  END GetKey;

  PROCEDURE (e : KeyEvent) [ABSTRACT] GetName*(keysym : LONGINT; VAR buffer : ARRAY OF CHAR);
  END GetName;

END VO:Base:Event.