/* utils.c generated by valac 0.24.0.131-42e78, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2012-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2012-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <config.h>
#include <keysyms.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define KKC_TYPE_PREFIX_ENTRY (kkc_prefix_entry_get_type ())
typedef struct _KkcPrefixEntry KkcPrefixEntry;

#define KKC_TYPE_KEY_EVENT_UTILS (kkc_key_event_utils_get_type ())
#define KKC_KEY_EVENT_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEY_EVENT_UTILS, KkcKeyEventUtils))
#define KKC_KEY_EVENT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEY_EVENT_UTILS, KkcKeyEventUtilsClass))
#define KKC_IS_KEY_EVENT_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEY_EVENT_UTILS))
#define KKC_IS_KEY_EVENT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEY_EVENT_UTILS))
#define KKC_KEY_EVENT_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEY_EVENT_UTILS, KkcKeyEventUtilsClass))

typedef struct _KkcKeyEventUtils KkcKeyEventUtils;
typedef struct _KkcKeyEventUtilsClass KkcKeyEventUtilsClass;
typedef struct _KkcKeyEventUtilsPrivate KkcKeyEventUtilsPrivate;
typedef struct _Block11Data Block11Data;

#define KKC_TYPE_INDEX_FILE (kkc_index_file_get_type ())
#define KKC_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_INDEX_FILE, KkcIndexFile))
#define KKC_IS_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_INDEX_FILE))
#define KKC_INDEX_FILE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_INDEX_FILE, KkcIndexFileIface))

typedef struct _KkcIndexFile KkcIndexFile;
typedef struct _KkcIndexFileIface KkcIndexFileIface;

#define KKC_TYPE_MAPPED_INDEX_FILE (kkc_mapped_index_file_get_type ())
#define KKC_MAPPED_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_MAPPED_INDEX_FILE, KkcMappedIndexFile))
#define KKC_MAPPED_INDEX_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_MAPPED_INDEX_FILE, KkcMappedIndexFileClass))
#define KKC_IS_MAPPED_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_MAPPED_INDEX_FILE))
#define KKC_IS_MAPPED_INDEX_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_MAPPED_INDEX_FILE))
#define KKC_MAPPED_INDEX_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_MAPPED_INDEX_FILE, KkcMappedIndexFileClass))

typedef struct _KkcMappedIndexFile KkcMappedIndexFile;
typedef struct _KkcMappedIndexFileClass KkcMappedIndexFileClass;
typedef struct _KkcMappedIndexFilePrivate KkcMappedIndexFilePrivate;
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))

#define KKC_TYPE_LOADED_INDEX_FILE (kkc_loaded_index_file_get_type ())
#define KKC_LOADED_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LOADED_INDEX_FILE, KkcLoadedIndexFile))
#define KKC_LOADED_INDEX_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LOADED_INDEX_FILE, KkcLoadedIndexFileClass))
#define KKC_IS_LOADED_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LOADED_INDEX_FILE))
#define KKC_IS_LOADED_INDEX_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LOADED_INDEX_FILE))
#define KKC_LOADED_INDEX_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LOADED_INDEX_FILE, KkcLoadedIndexFileClass))

typedef struct _KkcLoadedIndexFile KkcLoadedIndexFile;
typedef struct _KkcLoadedIndexFileClass KkcLoadedIndexFileClass;
typedef struct _KkcLoadedIndexFilePrivate KkcLoadedIndexFilePrivate;

struct _KkcPrefixEntry {
	gint offset;
	gchar** sequence;
	gint sequence_length1;
	gint _sequence_size_;
};

struct _KkcKeyEventUtils {
	GObject parent_instance;
	KkcKeyEventUtilsPrivate * priv;
};

struct _KkcKeyEventUtilsClass {
	GObjectClass parent_class;
};

struct _Block11Data {
	int _ref_count_;
	gchar* name;
};

struct _KkcIndexFileIface {
	GTypeInterface parent_iface;
	gchar* (*get_contents) (KkcIndexFile* self);
	gsize (*get_length) (KkcIndexFile* self);
};

struct _KkcMappedIndexFile {
	GObject parent_instance;
	KkcMappedIndexFilePrivate * priv;
};

struct _KkcMappedIndexFileClass {
	GObjectClass parent_class;
};

struct _KkcMappedIndexFilePrivate {
	GMappedFile* mmap;
};

struct _KkcLoadedIndexFile {
	GObject parent_instance;
	KkcLoadedIndexFilePrivate * priv;
};

struct _KkcLoadedIndexFileClass {
	GObjectClass parent_class;
};

struct _KkcLoadedIndexFilePrivate {
	guint8* contents;
	gint contents_length1;
	gint _contents_size_;
};


static gpointer kkc_key_event_utils_parent_class = NULL;
static gpointer kkc_mapped_index_file_parent_class = NULL;
static KkcIndexFileIface* kkc_mapped_index_file_kkc_index_file_parent_iface = NULL;
static gpointer kkc_loaded_index_file_parent_class = NULL;
static KkcIndexFileIface* kkc_loaded_index_file_kkc_index_file_parent_iface = NULL;

gchar** kkc_utils_build_data_path (const gchar* subdir, int* result_length1);
gchar** kkc_utils_split_utf8 (const gchar* str, int* result_length1);
gint kkc_utils_hex_char_to_int (gchar hex);
gchar* kkc_utils_parse_hex (const gchar* hex);
GType kkc_prefix_entry_get_type (void) G_GNUC_CONST;
KkcPrefixEntry* kkc_prefix_entry_dup (const KkcPrefixEntry* self);
void kkc_prefix_entry_free (KkcPrefixEntry* self);
void kkc_prefix_entry_copy (const KkcPrefixEntry* self, KkcPrefixEntry* dest);
void kkc_prefix_entry_destroy (KkcPrefixEntry* self);
void kkc_prefix_entry_init (KkcPrefixEntry *self, gint offset, gchar** sequence, int sequence_length1);
static gchar** _vala_array_dup6 (gchar** self, int length);
static gchar** _vala_array_dup7 (gchar** self, int length);
GeeList* kkc_sequence_utils_enumerate_prefixes (gchar** sequence, int sequence_length1, gint min, gint max);
GType kkc_key_event_utils_get_type (void) G_GNUC_CONST;
enum  {
	KKC_KEY_EVENT_UTILS_DUMMY_PROPERTY
};
static struct name_keysym* kkc_key_event_utils_bsearch_keysyms (struct name_keysym* memory, glong start_offset, glong end_offset, GCompareDataFunc compare, void* compare_target, struct name_keysym* needle);
static gchar* kkc_key_event_utils_read_name (glong start_offset);
gchar* kkc_key_event_utils_keyval_name (guint keyval);
static gint __lambda4_ (struct name_keysym* a, struct name_keysym* b);
static gint ___lambda4__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static struct name_keysym* kkc_key_event_utils_find_keysym (struct name_keysym* entry, const gchar* name);
guint kkc_key_event_utils_keyval_from_name (const gchar* name);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gint __lambda5_ (Block11Data* _data11_, struct name_keysym* a, struct name_keysym* b);
static gint ___lambda5__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
#define KKC_KEYSYMS_VoidSymbol ((guint) 0xffffff)
gunichar kkc_key_event_utils_keyval_unicode (guint keyval);
#define KKC_KEYSYMS_yen ((guint) 0x00a5)
KkcKeyEventUtils* kkc_key_event_utils_construct (GType object_type);
GType kkc_index_file_get_type (void) G_GNUC_CONST;
gchar* kkc_index_file_get_contents (KkcIndexFile* self);
gsize kkc_index_file_get_length (KkcIndexFile* self);
GType kkc_mapped_index_file_get_type (void) G_GNUC_CONST;
#define KKC_MAPPED_INDEX_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_MAPPED_INDEX_FILE, KkcMappedIndexFilePrivate))
enum  {
	KKC_MAPPED_INDEX_FILE_DUMMY_PROPERTY
};
KkcMappedIndexFile* kkc_mapped_index_file_new (const gchar* filename, GError** error);
KkcMappedIndexFile* kkc_mapped_index_file_construct (GType object_type, const gchar* filename, GError** error);
static gchar* kkc_mapped_index_file_real_get_contents (KkcIndexFile* base);
static gsize kkc_mapped_index_file_real_get_length (KkcIndexFile* base);
static void kkc_mapped_index_file_finalize (GObject* obj);
GType kkc_loaded_index_file_get_type (void) G_GNUC_CONST;
#define KKC_LOADED_INDEX_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_LOADED_INDEX_FILE, KkcLoadedIndexFilePrivate))
enum  {
	KKC_LOADED_INDEX_FILE_DUMMY_PROPERTY
};
KkcLoadedIndexFile* kkc_loaded_index_file_new (const gchar* filename, GError** error);
KkcLoadedIndexFile* kkc_loaded_index_file_construct (GType object_type, const gchar* filename, GError** error);
static gchar* kkc_loaded_index_file_real_get_contents (KkcIndexFile* base);
static gsize kkc_loaded_index_file_real_get_length (KkcIndexFile* base);
static void kkc_loaded_index_file_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


gchar** kkc_utils_build_data_path (const gchar* subdir, int* result_length1) {
	gchar** result = NULL;
	GeeArrayList* dirs = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gchar* path = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GeeArrayList* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gpointer* _tmp34_ = NULL;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	g_return_val_if_fail (subdir != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	dirs = _tmp0_;
	_tmp1_ = g_utf8_strup (PACKAGE_NAME, (gssize) (-1));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s_DATA_PATH", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_getenv (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	path = _tmp7_;
	_tmp8_ = path;
	if (_tmp8_ == NULL) {
		GeeArrayList* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		GeeArrayList* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GeeArrayList* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp9_ = dirs;
		_tmp10_ = g_get_user_config_dir ();
		_tmp11_ = subdir;
		_tmp12_ = g_build_filename (_tmp10_, PACKAGE_NAME, _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = dirs;
		_tmp15_ = subdir;
		_tmp16_ = g_build_filename (LIBDIR, PACKAGE_NAME, _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = dirs;
		_tmp19_ = subdir;
		_tmp20_ = g_build_filename (PKGDATADIR, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp21_);
		_g_free0 (_tmp21_);
	} else {
		gchar** elements = NULL;
		const gchar* _tmp22_ = NULL;
		gchar** _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint elements_length1 = 0;
		gint _elements_size_ = 0;
		gchar** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		_tmp22_ = path;
		_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, ":", 0);
		elements = _tmp24_;
		elements_length1 = _vala_array_length (_tmp23_);
		_elements_size_ = elements_length1;
		_tmp25_ = elements;
		_tmp25__length1 = elements_length1;
		{
			gchar** element_collection = NULL;
			gint element_collection_length1 = 0;
			gint _element_collection_size_ = 0;
			gint element_it = 0;
			element_collection = _tmp25_;
			element_collection_length1 = _tmp25__length1;
			for (element_it = 0; element_it < _tmp25__length1; element_it = element_it + 1) {
				gchar* _tmp26_ = NULL;
				gchar* element = NULL;
				_tmp26_ = g_strdup (element_collection[element_it]);
				element = _tmp26_;
				{
					GeeArrayList* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					_tmp27_ = dirs;
					_tmp28_ = element;
					_tmp29_ = subdir;
					_tmp30_ = g_build_filename (_tmp28_, _tmp29_, NULL);
					_tmp31_ = _tmp30_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp31_);
					_g_free0 (_tmp31_);
					_g_free0 (element);
				}
			}
		}
		elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp32_ = dirs;
	_tmp34_ = gee_collection_to_array ((GeeCollection*) _tmp32_, &_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp35__length1 = _tmp33_;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	_g_free0 (path);
	_g_object_unref0 (dirs);
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


gchar** kkc_utils_split_utf8 (const gchar* str, int* result_length1) {
	gchar** result = NULL;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint index = 0;
	gunichar uc = 0U;
	GeeArrayList* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gpointer* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_result_ = _tmp0_;
	index = 0;
	while (TRUE) {
		const gchar* _tmp1_ = NULL;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_ = FALSE;
		GeeArrayList* _tmp4_ = NULL;
		gunichar _tmp5_ = 0U;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp1_ = str;
		_tmp3_ = string_get_next_char (_tmp1_, &index, &_tmp2_);
		uc = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = _result_;
		_tmp5_ = uc;
		_tmp6_ = g_unichar_to_string (_tmp5_);
		_tmp7_ = _tmp6_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = _result_;
	_tmp10_ = gee_collection_to_array ((GeeCollection*) _tmp8_, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp9_;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	_g_object_unref0 (_result_);
	return result;
}


gint kkc_utils_hex_char_to_int (gchar hex) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_ = '\0';
	_tmp1_ = hex;
	if ('0' <= _tmp1_) {
		gchar _tmp2_ = '\0';
		_tmp2_ = hex;
		_tmp0_ = _tmp2_ <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar _tmp3_ = '\0';
		_tmp3_ = hex;
		result = (gint) (_tmp3_ - '0');
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gchar _tmp5_ = '\0';
		gchar _tmp6_ = '\0';
		_tmp5_ = hex;
		_tmp6_ = g_ascii_tolower (_tmp5_);
		if ('a' <= _tmp6_) {
			gchar _tmp7_ = '\0';
			gchar _tmp8_ = '\0';
			_tmp7_ = hex;
			_tmp8_ = g_ascii_tolower (_tmp7_);
			_tmp4_ = _tmp8_ <= 'f';
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gchar _tmp9_ = '\0';
			_tmp9_ = hex;
			result = (_tmp9_ - 'a') + 10;
			return result;
		}
	}
	result = -1;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gchar* kkc_utils_parse_hex (const gchar* hex) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	g_return_val_if_fail (hex != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				const gchar* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint c = 0;
				const gchar* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gchar _tmp9_ = '\0';
				gint _tmp10_ = 0;
				const gchar* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gchar _tmp13_ = '\0';
				gint _tmp14_ = 0;
				GString* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 2;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = hex;
				_tmp5_ = strlen (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < (_tmp6_ - 1))) {
					break;
				}
				_tmp7_ = hex;
				_tmp8_ = i;
				_tmp9_ = string_get (_tmp7_, (glong) _tmp8_);
				_tmp10_ = kkc_utils_hex_char_to_int (_tmp9_);
				_tmp11_ = hex;
				_tmp12_ = i;
				_tmp13_ = string_get (_tmp11_, (glong) (_tmp12_ + 1));
				_tmp14_ = kkc_utils_hex_char_to_int (_tmp13_);
				c = (_tmp10_ << 4) | _tmp14_;
				_tmp15_ = builder;
				_tmp16_ = c;
				g_string_append_c (_tmp15_, (gchar) _tmp16_);
			}
		}
	}
	_tmp17_ = builder;
	_tmp18_ = _tmp17_->str;
	_tmp19_ = g_strdup (_tmp18_);
	result = _tmp19_;
	_g_string_free0 (builder);
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void kkc_prefix_entry_init (KkcPrefixEntry *self, gint offset, gchar** sequence, int sequence_length1) {
	gint _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	memset (self, 0, sizeof (KkcPrefixEntry));
	_tmp0_ = offset;
	(*self).offset = _tmp0_;
	_tmp1_ = sequence;
	_tmp1__length1 = sequence_length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup6 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp1__length1;
	(*self).sequence = (_vala_array_free ((*self).sequence, (*self).sequence_length1, (GDestroyNotify) g_free), NULL);
	(*self).sequence = _tmp2_;
	(*self).sequence_length1 = _tmp2__length1;
	(*self)._sequence_size_ = (*self).sequence_length1;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void kkc_prefix_entry_copy (const KkcPrefixEntry* self, KkcPrefixEntry* dest) {
	gint _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	_tmp0_ = (*self).offset;
	(*dest).offset = _tmp0_;
	_tmp1_ = (*self).sequence;
	_tmp1__length1 = (*self).sequence_length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup7 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp1__length1;
	(*dest).sequence = (_vala_array_free ((*dest).sequence, (*dest).sequence_length1, (GDestroyNotify) g_free), NULL);
	(*dest).sequence = _tmp2_;
	(*dest).sequence_length1 = _tmp2__length1;
	(*dest)._sequence_size_ = (*dest).sequence_length1;
}


void kkc_prefix_entry_destroy (KkcPrefixEntry* self) {
	(*self).sequence = (_vala_array_free ((*self).sequence, (*self).sequence_length1, (GDestroyNotify) g_free), NULL);
}


KkcPrefixEntry* kkc_prefix_entry_dup (const KkcPrefixEntry* self) {
	KkcPrefixEntry* dup;
	dup = g_new0 (KkcPrefixEntry, 1);
	kkc_prefix_entry_copy (self, dup);
	return dup;
}


void kkc_prefix_entry_free (KkcPrefixEntry* self) {
	kkc_prefix_entry_destroy (self);
	g_free (self);
}


GType kkc_prefix_entry_get_type (void) {
	static volatile gsize kkc_prefix_entry_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_prefix_entry_type_id__volatile)) {
		GType kkc_prefix_entry_type_id;
		kkc_prefix_entry_type_id = g_boxed_type_register_static ("KkcPrefixEntry", (GBoxedCopyFunc) kkc_prefix_entry_dup, (GBoxedFreeFunc) kkc_prefix_entry_free);
		g_once_init_leave (&kkc_prefix_entry_type_id__volatile, kkc_prefix_entry_type_id);
	}
	return kkc_prefix_entry_type_id__volatile;
}


GeeList* kkc_sequence_utils_enumerate_prefixes (gchar** sequence, int sequence_length1, gint min, gint max) {
	GeeList* result = NULL;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_ = NULL;
	_tmp0_ = gee_array_list_new (KKC_TYPE_PREFIX_ENTRY, (GBoxedCopyFunc) kkc_prefix_entry_dup, kkc_prefix_entry_free, NULL, NULL, NULL);
	_result_ = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gchar** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = sequence;
				_tmp4__length1 = sequence_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				{
					gint j = 0;
					gchar** _tmp5_ = NULL;
					gint _tmp5__length1 = 0;
					_tmp5_ = sequence;
					_tmp5__length1 = sequence_length1;
					j = _tmp5__length1;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							GeeArrayList* _tmp16_ = NULL;
							gint _tmp17_ = 0;
							gchar** _tmp18_ = NULL;
							gint _tmp18__length1 = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							KkcPrefixEntry _tmp21_ = {0};
							KkcPrefixEntry _tmp22_ = {0};
							KkcPrefixEntry _tmp23_ = {0};
							if (!_tmp6_) {
								gint _tmp7_ = 0;
								_tmp7_ = j;
								j = _tmp7_ - 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = j;
							_tmp9_ = i;
							if (!(_tmp8_ > _tmp9_)) {
								break;
							}
							_tmp10_ = j;
							_tmp11_ = i;
							_tmp12_ = min;
							if ((_tmp10_ - _tmp11_) < _tmp12_) {
								break;
							}
							_tmp13_ = j;
							_tmp14_ = i;
							_tmp15_ = max;
							if ((_tmp13_ - _tmp14_) > _tmp15_) {
								continue;
							}
							_tmp16_ = _result_;
							_tmp17_ = i;
							_tmp18_ = sequence;
							_tmp18__length1 = sequence_length1;
							_tmp19_ = i;
							_tmp20_ = j;
							kkc_prefix_entry_init (&_tmp21_, _tmp17_, _tmp18_ + _tmp19_, _tmp20_ - _tmp19_);
							_tmp22_ = _tmp21_;
							_tmp23_ = _tmp22_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, &_tmp23_);
							kkc_prefix_entry_destroy (&_tmp22_);
						}
					}
				}
			}
		}
	}
	result = (GeeList*) _result_;
	return result;
}


static struct name_keysym* kkc_key_event_utils_bsearch_keysyms (struct name_keysym* memory, glong start_offset, glong end_offset, GCompareDataFunc compare, void* compare_target, struct name_keysym* needle) {
	struct name_keysym* result = NULL;
	glong offset = 0L;
	glong _tmp0_ = 0L;
	glong _tmp1_ = 0L;
	glong _tmp2_ = 0L;
	g_return_val_if_fail (needle != NULL, NULL);
	_tmp0_ = start_offset;
	_tmp1_ = end_offset;
	_tmp2_ = start_offset;
	offset = _tmp0_ + ((_tmp1_ - _tmp2_) / 2);
	while (TRUE) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		struct name_keysym* p = NULL;
		struct name_keysym* _tmp5_ = NULL;
		glong _tmp6_ = 0L;
		gint r = 0;
		GCompareDataFunc _tmp7_ = NULL;
		void* _tmp7__target = NULL;
		struct name_keysym* _tmp8_ = NULL;
		struct name_keysym _tmp9_ = {0};
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp13_ = 0;
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		glong _tmp18_ = 0L;
		_tmp3_ = start_offset;
		_tmp4_ = end_offset;
		if (!(_tmp3_ <= _tmp4_)) {
			break;
		}
		_tmp5_ = memory;
		_tmp6_ = offset;
		p = _tmp5_ + _tmp6_;
		_tmp7_ = compare;
		_tmp7__target = compare_target;
		_tmp8_ = p;
		_tmp9_ = *needle;
		_tmp10_ = _tmp7_ (_tmp8_, &_tmp9_, _tmp7__target);
		r = _tmp10_;
		_tmp11_ = r;
		if (_tmp11_ == 0) {
			struct name_keysym* _tmp12_ = NULL;
			_tmp12_ = p;
			result = _tmp12_;
			return result;
		}
		_tmp13_ = r;
		if (_tmp13_ > 0) {
			glong _tmp14_ = 0L;
			_tmp14_ = offset;
			end_offset = _tmp14_ - 1;
		} else {
			glong _tmp15_ = 0L;
			_tmp15_ = offset;
			start_offset = _tmp15_ + 1;
		}
		_tmp16_ = start_offset;
		_tmp17_ = end_offset;
		_tmp18_ = start_offset;
		offset = _tmp16_ + ((_tmp17_ - _tmp18_) / 2);
	}
	result = NULL;
	return result;
}


static gchar* kkc_key_event_utils_read_name (glong start_offset) {
	gchar* result = NULL;
	glong offset = 0L;
	const gchar* _result_ = NULL;
	glong _tmp5_ = 0L;
	glong _tmp6_ = 0L;
	void* _tmp7_ = NULL;
	gchar* dest = NULL;
	const gchar* _tmp8_ = NULL;
	glong _tmp9_ = 0L;
	glong _tmp10_ = 0L;
	glong _tmp11_ = 0L;
	const gchar* _tmp12_ = NULL;
	{
		glong _tmp0_ = 0L;
		gboolean _tmp1_ = FALSE;
		_tmp0_ = start_offset;
		offset = _tmp0_;
		_tmp1_ = TRUE;
		while (TRUE) {
			glong _tmp3_ = 0L;
			gchar _tmp4_ = '\0';
			if (!_tmp1_) {
				glong _tmp2_ = 0L;
				_tmp2_ = offset;
				offset = _tmp2_ + 1;
			}
			_tmp1_ = FALSE;
			_tmp3_ = offset;
			_tmp4_ = string_get (keysym_names, _tmp3_);
			if (!(_tmp4_ != '\0')) {
				break;
			}
		}
	}
	_tmp5_ = offset;
	_tmp6_ = start_offset;
	_tmp7_ = g_malloc0 ((gsize) ((_tmp5_ - _tmp6_) + 1));
	_result_ = _tmp7_;
	_tmp8_ = _result_;
	dest = (gchar*) _tmp8_;
	_tmp9_ = start_offset;
	_tmp10_ = offset;
	_tmp11_ = start_offset;
	memcpy (dest, ((gchar*) keysym_names) + _tmp9_, (gsize) (_tmp10_ - _tmp11_));
	_tmp12_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp12_;
	return result;
}


static gint __lambda4_ (struct name_keysym* a, struct name_keysym* b) {
	gint result = 0;
	gint _tmp0_ = 0;
	struct name_keysym* _tmp1_ = NULL;
	guint32 _tmp2_ = 0U;
	struct name_keysym* _tmp3_ = NULL;
	guint32 _tmp4_ = 0U;
	_tmp1_ = a;
	_tmp2_ = (*_tmp1_).keysym;
	_tmp3_ = b;
	_tmp4_ = (*_tmp3_).keysym;
	if (_tmp2_ == _tmp4_) {
		_tmp0_ = 0;
	} else {
		gint _tmp5_ = 0;
		struct name_keysym* _tmp6_ = NULL;
		guint32 _tmp7_ = 0U;
		struct name_keysym* _tmp8_ = NULL;
		guint32 _tmp9_ = 0U;
		_tmp6_ = a;
		_tmp7_ = (*_tmp6_).keysym;
		_tmp8_ = b;
		_tmp9_ = (*_tmp8_).keysym;
		if (_tmp7_ < _tmp9_) {
			_tmp5_ = -1;
		} else {
			_tmp5_ = 1;
		}
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}


static gint ___lambda4__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda4_ ((struct name_keysym*) a, (struct name_keysym*) b);
	return result;
}


gchar* kkc_key_event_utils_keyval_name (guint keyval) {
	gchar* result = NULL;
	struct name_keysym needle = {0};
	guint _tmp0_ = 0U;
	struct name_keysym _tmp1_ = {0};
	struct name_keysym* entry = NULL;
	struct name_keysym _tmp2_ = {0};
	struct name_keysym* _tmp3_ = NULL;
	struct name_keysym* _tmp4_ = NULL;
	struct name_keysym* _tmp5_ = NULL;
	guint32 _tmp6_ = 0U;
	gchar* _tmp7_ = NULL;
	_tmp0_ = keyval;
	memset (&_tmp1_, 0, sizeof (struct name_keysym));
	_tmp1_.keysym = (guint32) _tmp0_;
	_tmp1_.offset = (guint32) 0;
	needle = _tmp1_;
	_tmp2_ = needle;
	_tmp3_ = kkc_key_event_utils_bsearch_keysyms (keysym_to_name, (glong) 0, (glong) G_N_ELEMENTS (keysym_to_name), ___lambda4__gcompare_data_func, NULL, &_tmp2_);
	entry = _tmp3_;
	_tmp4_ = entry;
	if (_tmp4_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp5_ = entry;
	_tmp6_ = (*_tmp5_).offset;
	_tmp7_ = kkc_key_event_utils_read_name ((glong) _tmp6_);
	result = _tmp7_;
	return result;
}


static struct name_keysym* kkc_key_event_utils_find_keysym (struct name_keysym* entry, const gchar* name) {
	struct name_keysym* result = NULL;
	struct name_keysym* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	struct name_keysym* iter = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = entry;
	_tmp1_ = (*_tmp0_).offset;
	_tmp2_ = kkc_key_event_utils_read_name ((glong) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = name;
	_tmp5_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	_g_free0 (_tmp3_);
	if (_tmp5_) {
		struct name_keysym* _tmp6_ = NULL;
		_tmp6_ = entry;
		result = _tmp6_;
		return result;
	}
	{
		struct name_keysym* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = entry;
		iter = _tmp7_ - 1;
		_tmp8_ = TRUE;
		while (TRUE) {
			struct name_keysym* _tmp10_ = NULL;
			struct name_keysym* _tmp11_ = NULL;
			guint32 _tmp12_ = 0U;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			if (!_tmp8_) {
				struct name_keysym* _tmp9_ = NULL;
				_tmp9_ = iter;
				iter = _tmp9_ + 1;
			}
			_tmp8_ = FALSE;
			_tmp10_ = iter;
			if (!(_tmp10_ >= ((struct name_keysym*) name_to_keysym))) {
				break;
			}
			_tmp11_ = iter;
			_tmp12_ = (*_tmp11_).offset;
			_tmp13_ = kkc_key_event_utils_read_name ((glong) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = name;
			_tmp16_ = g_strcmp0 (_tmp14_, _tmp15_) == 0;
			_g_free0 (_tmp14_);
			if (_tmp16_) {
				struct name_keysym* _tmp17_ = NULL;
				_tmp17_ = iter;
				result = _tmp17_;
				return result;
			}
		}
	}
	result = NULL;
	return result;
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_free0 (_data11_->name);
		g_slice_free (Block11Data, _data11_);
	}
}


static gint __lambda5_ (Block11Data* _data11_, struct name_keysym* a, struct name_keysym* b) {
	gint result = 0;
	gchar* aname = NULL;
	struct name_keysym* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	_tmp0_ = a;
	_tmp1_ = (*_tmp0_).offset;
	_tmp2_ = kkc_key_event_utils_read_name ((glong) _tmp1_);
	aname = _tmp2_;
	_tmp3_ = _data11_->name;
	_tmp4_ = g_ascii_strcasecmp (aname, _tmp3_);
	result = _tmp4_;
	_g_free0 (aname);
	return result;
}


static gint ___lambda5__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda5_ (self, (struct name_keysym*) a, (struct name_keysym*) b);
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


guint kkc_key_event_utils_keyval_from_name (const gchar* name) {
	guint result = 0U;
	Block11Data* _data11_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	struct name_keysym needle = {0};
	struct name_keysym _tmp2_ = {0};
	struct name_keysym* entry = NULL;
	struct name_keysym _tmp3_ = {0};
	struct name_keysym* _tmp4_ = NULL;
	struct name_keysym* _tmp5_ = NULL;
	const gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	g_return_val_if_fail (name != NULL, 0U);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data11_->name);
	_data11_->name = _tmp1_;
	memset (&_tmp2_, 0, sizeof (struct name_keysym));
	_tmp2_.keysym = (guint32) 0;
	_tmp2_.offset = (guint32) 0;
	needle = _tmp2_;
	_tmp3_ = needle;
	_tmp4_ = kkc_key_event_utils_bsearch_keysyms (name_to_keysym, (glong) 0, (glong) G_N_ELEMENTS (name_to_keysym), ___lambda5__gcompare_data_func, _data11_, &_tmp3_);
	entry = _tmp4_;
	_tmp5_ = entry;
	if (_tmp5_ != NULL) {
		struct name_keysym* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		struct name_keysym* _tmp8_ = NULL;
		struct name_keysym* _tmp9_ = NULL;
		_tmp6_ = entry;
		_tmp7_ = _data11_->name;
		_tmp8_ = kkc_key_event_utils_find_keysym (_tmp6_, _tmp7_);
		entry = _tmp8_;
		_tmp9_ = entry;
		if (_tmp9_ != NULL) {
			struct name_keysym* _tmp10_ = NULL;
			guint32 _tmp11_ = 0U;
			_tmp10_ = entry;
			_tmp11_ = (*_tmp10_).keysym;
			result = (guint) _tmp11_;
			block11_data_unref (_data11_);
			_data11_ = NULL;
			return result;
		}
	}
	_tmp12_ = _data11_->name;
	_tmp13_ = g_utf8_strlen (_tmp12_, (gssize) (-1));
	if (_tmp13_ == 1) {
		gunichar code = 0U;
		const gchar* _tmp14_ = NULL;
		gunichar _tmp15_ = 0U;
		gboolean _tmp16_ = FALSE;
		gunichar _tmp17_ = 0U;
		_tmp14_ = _data11_->name;
		_tmp15_ = string_get_char (_tmp14_, (glong) 0);
		code = _tmp15_;
		_tmp17_ = code;
		if (((gunichar) 0x20) <= _tmp17_) {
			gunichar _tmp18_ = 0U;
			_tmp18_ = code;
			_tmp16_ = _tmp18_ < ((gunichar) 0x7F);
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			result = (guint) code;
			block11_data_unref (_data11_);
			_data11_ = NULL;
			return result;
		}
	}
	result = KKC_KEYSYMS_VoidSymbol;
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}


gunichar kkc_key_event_utils_keyval_unicode (guint keyval) {
	gunichar result = 0U;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	guint _tmp4_ = 0U;
	_tmp1_ = keyval;
	if (((guint) 0x20) <= _tmp1_) {
		guint _tmp2_ = 0U;
		_tmp2_ = keyval;
		_tmp0_ = _tmp2_ < ((guint) 0x7F);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint _tmp3_ = 0U;
		_tmp3_ = keyval;
		result = (gunichar) _tmp3_;
		return result;
	}
	_tmp4_ = keyval;
	switch (_tmp4_) {
		case KKC_KEYSYMS_yen:
		{
			gunichar _tmp5_ = 0U;
			_tmp5_ = string_get_char ("\xc2\xa5", (glong) 0);
			result = _tmp5_;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = (gunichar) '\0';
	return result;
}


KkcKeyEventUtils* kkc_key_event_utils_construct (GType object_type) {
	KkcKeyEventUtils * self = NULL;
	self = (KkcKeyEventUtils*) g_object_new (object_type, NULL);
	return self;
}


static void kkc_key_event_utils_class_init (KkcKeyEventUtilsClass * klass) {
	kkc_key_event_utils_parent_class = g_type_class_peek_parent (klass);
}


static void kkc_key_event_utils_instance_init (KkcKeyEventUtils * self) {
}


GType kkc_key_event_utils_get_type (void) {
	static volatile gsize kkc_key_event_utils_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_key_event_utils_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcKeyEventUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_key_event_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcKeyEventUtils), 0, (GInstanceInitFunc) kkc_key_event_utils_instance_init, NULL };
		GType kkc_key_event_utils_type_id;
		kkc_key_event_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcKeyEventUtils", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&kkc_key_event_utils_type_id__volatile, kkc_key_event_utils_type_id);
	}
	return kkc_key_event_utils_type_id__volatile;
}


gchar* kkc_index_file_get_contents (KkcIndexFile* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return KKC_INDEX_FILE_GET_INTERFACE (self)->get_contents (self);
}


gsize kkc_index_file_get_length (KkcIndexFile* self) {
	g_return_val_if_fail (self != NULL, 0UL);
	return KKC_INDEX_FILE_GET_INTERFACE (self)->get_length (self);
}


static void kkc_index_file_base_init (KkcIndexFileIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType kkc_index_file_get_type (void) {
	static volatile gsize kkc_index_file_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_index_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcIndexFileIface), (GBaseInitFunc) kkc_index_file_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType kkc_index_file_type_id;
		kkc_index_file_type_id = g_type_register_static (G_TYPE_INTERFACE, "KkcIndexFile", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (kkc_index_file_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&kkc_index_file_type_id__volatile, kkc_index_file_type_id);
	}
	return kkc_index_file_type_id__volatile;
}


KkcMappedIndexFile* kkc_mapped_index_file_construct (GType object_type, const gchar* filename, GError** error) {
	KkcMappedIndexFile * self = NULL;
	GMappedFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GMappedFile* _tmp2_ = NULL;
	GMappedFile* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (KkcMappedIndexFile*) g_object_new (object_type, NULL);
	_tmp1_ = filename;
	_tmp2_ = g_mapped_file_new (_tmp1_, FALSE, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_mapped_file_unref0 (self->priv->mmap);
	self->priv->mmap = _tmp3_;
	_g_mapped_file_unref0 (_tmp0_);
	return self;
}


KkcMappedIndexFile* kkc_mapped_index_file_new (const gchar* filename, GError** error) {
	return kkc_mapped_index_file_construct (KKC_TYPE_MAPPED_INDEX_FILE, filename, error);
}


static gchar* kkc_mapped_index_file_real_get_contents (KkcIndexFile* base) {
	KkcMappedIndexFile * self;
	gchar* result = NULL;
	GMappedFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (KkcMappedIndexFile*) base;
	_tmp0_ = self->priv->mmap;
	_tmp1_ = g_mapped_file_get_contents (_tmp0_);
	result = _tmp1_;
	return result;
}


static gsize kkc_mapped_index_file_real_get_length (KkcIndexFile* base) {
	KkcMappedIndexFile * self;
	gsize result = 0UL;
	GMappedFile* _tmp0_ = NULL;
	gsize _tmp1_ = 0UL;
	self = (KkcMappedIndexFile*) base;
	_tmp0_ = self->priv->mmap;
	_tmp1_ = g_mapped_file_get_length (_tmp0_);
	result = _tmp1_;
	return result;
}


static void kkc_mapped_index_file_class_init (KkcMappedIndexFileClass * klass) {
	kkc_mapped_index_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcMappedIndexFilePrivate));
	G_OBJECT_CLASS (klass)->finalize = kkc_mapped_index_file_finalize;
}


static void kkc_mapped_index_file_kkc_index_file_interface_init (KkcIndexFileIface * iface) {
	kkc_mapped_index_file_kkc_index_file_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_contents = (gchar* (*)(KkcIndexFile*)) kkc_mapped_index_file_real_get_contents;
	iface->get_length = (gsize (*)(KkcIndexFile*)) kkc_mapped_index_file_real_get_length;
}


static void kkc_mapped_index_file_instance_init (KkcMappedIndexFile * self) {
	self->priv = KKC_MAPPED_INDEX_FILE_GET_PRIVATE (self);
}


static void kkc_mapped_index_file_finalize (GObject* obj) {
	KkcMappedIndexFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_MAPPED_INDEX_FILE, KkcMappedIndexFile);
	_g_mapped_file_unref0 (self->priv->mmap);
	G_OBJECT_CLASS (kkc_mapped_index_file_parent_class)->finalize (obj);
}


GType kkc_mapped_index_file_get_type (void) {
	static volatile gsize kkc_mapped_index_file_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_mapped_index_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcMappedIndexFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_mapped_index_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcMappedIndexFile), 0, (GInstanceInitFunc) kkc_mapped_index_file_instance_init, NULL };
		static const GInterfaceInfo kkc_index_file_info = { (GInterfaceInitFunc) kkc_mapped_index_file_kkc_index_file_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_mapped_index_file_type_id;
		kkc_mapped_index_file_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcMappedIndexFile", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_mapped_index_file_type_id, KKC_TYPE_INDEX_FILE, &kkc_index_file_info);
		g_once_init_leave (&kkc_mapped_index_file_type_id__volatile, kkc_mapped_index_file_type_id);
	}
	return kkc_mapped_index_file_type_id__volatile;
}


KkcLoadedIndexFile* kkc_loaded_index_file_construct (GType object_type, const gchar* filename, GError** error) {
	KkcLoadedIndexFile * self = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* etag = NULL;
	guint8* _tmp2_ = NULL;
	gsize _tmp3_;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (KkcLoadedIndexFile*) g_object_new (object_type, NULL);
	_tmp0_ = filename;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	g_file_load_contents (file, NULL, &_tmp2_, &_tmp3_, &_tmp4_, &_inner_error_);
	self->priv->contents = (g_free (self->priv->contents), NULL);
	self->priv->contents = _tmp2_;
	self->priv->contents_length1 = _tmp3_;
	self->priv->_contents_size_ = self->priv->contents_length1;
	_g_free0 (etag);
	etag = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (etag);
		_g_object_unref0 (file);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_free0 (etag);
	_g_object_unref0 (file);
	return self;
}


KkcLoadedIndexFile* kkc_loaded_index_file_new (const gchar* filename, GError** error) {
	return kkc_loaded_index_file_construct (KKC_TYPE_LOADED_INDEX_FILE, filename, error);
}


static gchar* kkc_loaded_index_file_real_get_contents (KkcIndexFile* base) {
	KkcLoadedIndexFile * self;
	gchar* result = NULL;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = (KkcLoadedIndexFile*) base;
	_tmp0_ = self->priv->contents;
	_tmp0__length1 = self->priv->contents_length1;
	result = _tmp0_;
	return result;
}


static gsize kkc_loaded_index_file_real_get_length (KkcIndexFile* base) {
	KkcLoadedIndexFile * self;
	gsize result = 0UL;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = (KkcLoadedIndexFile*) base;
	_tmp0_ = self->priv->contents;
	_tmp0__length1 = self->priv->contents_length1;
	result = (gsize) _tmp0__length1;
	return result;
}


static void kkc_loaded_index_file_class_init (KkcLoadedIndexFileClass * klass) {
	kkc_loaded_index_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcLoadedIndexFilePrivate));
	G_OBJECT_CLASS (klass)->finalize = kkc_loaded_index_file_finalize;
}


static void kkc_loaded_index_file_kkc_index_file_interface_init (KkcIndexFileIface * iface) {
	kkc_loaded_index_file_kkc_index_file_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_contents = (gchar* (*)(KkcIndexFile*)) kkc_loaded_index_file_real_get_contents;
	iface->get_length = (gsize (*)(KkcIndexFile*)) kkc_loaded_index_file_real_get_length;
}


static void kkc_loaded_index_file_instance_init (KkcLoadedIndexFile * self) {
	self->priv = KKC_LOADED_INDEX_FILE_GET_PRIVATE (self);
}


static void kkc_loaded_index_file_finalize (GObject* obj) {
	KkcLoadedIndexFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_LOADED_INDEX_FILE, KkcLoadedIndexFile);
	self->priv->contents = (g_free (self->priv->contents), NULL);
	G_OBJECT_CLASS (kkc_loaded_index_file_parent_class)->finalize (obj);
}


GType kkc_loaded_index_file_get_type (void) {
	static volatile gsize kkc_loaded_index_file_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_loaded_index_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcLoadedIndexFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_loaded_index_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcLoadedIndexFile), 0, (GInstanceInitFunc) kkc_loaded_index_file_instance_init, NULL };
		static const GInterfaceInfo kkc_index_file_info = { (GInterfaceInitFunc) kkc_loaded_index_file_kkc_index_file_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_loaded_index_file_type_id;
		kkc_loaded_index_file_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcLoadedIndexFile", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_loaded_index_file_type_id, KKC_TYPE_INDEX_FILE, &kkc_index_file_info);
		g_once_init_leave (&kkc_loaded_index_file_type_id__volatile, kkc_loaded_index_file_type_id);
	}
	return kkc_loaded_index_file_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



