/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.apple;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.TargetInfo;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.ProcessorConfiguration;
import net.sf.antcontrib.cpptasks.gcc.GccCCompiler;
import net.sf.antcontrib.cpptasks.ide.ProjectDef;
import net.sf.antcontrib.cpptasks.ide.ProjectWriter;
import org.apache.tools.ant.BuildException;

public final class XcodeProjectWriter
implements ProjectWriter {
    private int nextID = 150697878;

    private String getUniqueID() {
        return Integer.toString(this.nextID++, 16) + "FE84155DC02AAC07";
    }

    public void writeProject(File fileName, CCTask task, ProjectDef projectDef, List sources, Hashtable targets, TargetInfo linkTarget) throws IOException {
        File[] includes;
        int i;
        File xcodeDir = new File(fileName + ".xcode");
        if (!projectDef.getOverwrite() && xcodeDir.exists()) {
            throw new BuildException("Not allowed to overwrite project file " + xcodeDir.toString());
        }
        CommandLineCompilerConfiguration compilerConfig = this.getBaseCompilerConfiguration(targets);
        if (compilerConfig == null) {
            throw new BuildException("Unable to find compilation target using GNU C++ compiler");
        }
        String projectName = projectDef.getName();
        if (projectName == null) {
            projectName = fileName.getName();
        }
        String basePath = fileName.getAbsoluteFile().getParent();
        xcodeDir.mkdir();
        File xcodeProj = new File(xcodeDir, "project.pbxproj");
        CommandLineCompilerConfiguration gccConfig = null;
        Vector<SourceEntry> sourceList = new Vector<SourceEntry>(targets.size());
        Iterator targetIter = targets.values().iterator();
        while (targetIter.hasNext()) {
            TargetInfo info = (TargetInfo)targetIter.next();
            File[] targetsources = info.getSources();
            for (int i2 = 0; i2 < targetsources.length; ++i2) {
                sourceList.addElement(new SourceEntry(targetsources[i2], this.getUniqueID(), this.getUniqueID()));
            }
            ProcessorConfiguration procConfig = info.getConfiguration();
            if (!(procConfig instanceof CommandLineCompilerConfiguration) || gccConfig != null) continue;
            gccConfig = (CommandLineCompilerConfiguration)procConfig;
        }
        Object[] sortedSources = new SourceEntry[sourceList.size()];
        sourceList.copyInto(sortedSources);
        Arrays.sort(sortedSources, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((SourceEntry)o1).getFile().getName().compareTo(((SourceEntry)o2).getFile().getName());
            }
        });
        File outFile = task.getOutfile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(xcodeProj));
        writer.write("// !$*UTF8*$!\n");
        writer.write("   {\n");
        writer.write("   \tarchiveVersion = 1;\n");
        writer.write("   \tclasses = {\n");
        writer.write("   \t};\n");
        writer.write("   \tobjectVersion = 39;\n");
        writer.write("   \tobjects = {\n");
        writer.write("   \t\t014CEA520018CE5811CA2923 = {\n");
        writer.write("   \t\t\tbuildRules = (\n");
        writer.write("   \t\t\t);\n");
        writer.write("   \t\t\tbuildSettings = {\n");
        writer.write("   \t\t\t\tCOPY_PHASE_STRIP = NO;\n");
        writer.write("   \t\t\t\tDEBUGGING_SYMBOLS = YES;\n");
        writer.write("   \t\t\t\tGCC_DYNAMIC_NO_PIC = NO;\n");
        writer.write("   \t\t\t\tGCC_ENABLE_FIX_AND_CONTINUE = YES;\n");
        writer.write("   \t\t\t\tGCC_GENERATE_DEBUGGING_SYMBOLS = YES;\n");
        writer.write("   \t\t\t\tGCC_OPTIMIZATION_LEVEL = 0;\n");
        writer.write("   \t\t\t\tOPTIMIZATION_CFLAGS = \"-O0\";\n");
        writer.write("   \t\t\t\tZERO_LINK = YES;\n");
        writer.write("   \t\t\t};\n");
        writer.write("   \t\t\tisa = PBXBuildStyle;\n");
        writer.write("   \t\t\tname = Development;\n");
        writer.write("   \t\t};\n");
        writer.write("   \t\t014CEA530018CE5811CA2923 = {\n");
        writer.write("   \t\t\tbuildRules = (\n");
        writer.write("   \t\t\t);\n");
        writer.write("   \t\t\tbuildSettings = {\n");
        writer.write("   \t\t\t\tCOPY_PHASE_STRIP = YES;\n");
        writer.write("   \t\t\t\tGCC_ENABLE_FIX_AND_CONTINUE = NO;\n");
        writer.write("   \t\t\t\tZERO_LINK = NO;\n");
        writer.write("   \t\t\t};\n");
        writer.write("   \t\t\tisa = PBXBuildStyle;\n");
        writer.write("   \t\t\tname = Deployment;\n");
        writer.write("   \t\t};\n");
        writer.write("//   010\n");
        writer.write("//   011\n");
        writer.write("//   012\n");
        writer.write("//   013\n");
        writer.write("//   014\n");
        writer.write("//   080\n");
        writer.write("//   081\n");
        writer.write("//   082\n");
        writer.write("//   083\n");
        writer.write("//   084\n");
        writer.write("   \t\t08FB7793FE84155DC02AAC07 = {\n");
        writer.write("   \t\t\tbuildSettings = {\n");
        writer.write("   \t\t\t};\n");
        writer.write("   \t\t\tbuildStyles = (\n");
        writer.write("   \t\t\t\t014CEA520018CE5811CA2923,\n");
        writer.write("   \t\t\t\t014CEA530018CE5811CA2923,\n");
        writer.write("   \t\t\t);\n");
        writer.write("   \t\t\thasScannedForEncodings = 1;\n");
        writer.write("   \t\t\tisa = PBXProject;\n");
        writer.write("   \t\t\tmainGroup = 08FB7794FE84155DC02AAC07;\n");
        writer.write("   \t\t\tprojectDirPath = \"\";\n");
        writer.write("   \t\t\ttargets = (\n");
        writer.write("   \t\t\t\tD2AAC0620554660B00DB518D,\n");
        writer.write("   \t\t\t);\n");
        writer.write("   \t\t};\n");
        writer.write("   \t\t08FB7794FE84155DC02AAC07 = {\n");
        writer.write("   \t\t\tchildren = (\n");
        writer.write("   \t\t\t\t08FB7795FE84155DC02AAC07,\n");
        writer.write("   \t\t\t\t1AB674ADFE9D54B511CA2CBB,\n");
        writer.write("   \t\t\t);\n");
        writer.write("   \t\t\tisa = PBXGroup;\n");
        writer.write("   \t\t\tname = ");
        writer.write(outFile.getName());
        writer.write(";\n");
        writer.write("   \t\t\trefType = 4;\n");
        writer.write("   \t\t\tsourceTree = \"<group>\";\n");
        writer.write("   \t\t};\n");
        writer.write("   \t\t08FB7795FE84155DC02AAC07 = {\n");
        writer.write("   \t\t\tchildren = (\n");
        for (i = 0; i < sortedSources.length; ++i) {
            writer.write("   \t\t\t\t");
            writer.write(((SourceEntry)sortedSources[i]).getSourceID());
            writer.write(",\n");
        }
        writer.write("   \t\t\t);\n");
        writer.write("   \t\t\tisa = PBXGroup;\n");
        writer.write("   \t\t\tname = Source;\n");
        writer.write("   \t\t\trefType = 4;\n");
        writer.write("   \t\t\tsourceTree = \"<group>\";\n");
        writer.write("   \t\t};\n");
        for (i = 0; i < sortedSources.length; ++i) {
            Object entry = sortedSources[i];
            writer.write("   \t\t");
            writer.write(((SourceEntry)entry).getSourceID());
            writer.write(" = {\n");
            writer.write("   \t\t\tfileEncoding = 4;\n");
            writer.write("   \t\t\tisa = PBXFileReference;\n");
            String sourceName = ((SourceEntry)entry).getFile().getName();
            if (sourceName.endsWith(".c")) {
                writer.write("   \t\t\tlastKnownFileType = sourcecode.c.c;\n");
            } else {
                writer.write("   \t\t\tlastKnownFileType = sourcecode.cpp.cpp;\n");
            }
            String relativePath = CUtil.getRelativePath(basePath, ((SourceEntry)entry).getFile());
            if (!relativePath.equals(sourceName)) {
                writer.write("              name = ");
                writer.write(sourceName);
                writer.write(";\n");
            }
            writer.write("   \t\t\tpath = ");
            writer.write(relativePath);
            writer.write(";\n");
            writer.write("   \t\t\trefType = 4;\n");
            writer.write("   \t\t\tsourceTree = \"<group>\";\n");
            writer.write("   \t\t};\n");
            writer.write("   \t\t");
            writer.write(((SourceEntry)entry).getBuildID());
            writer.write(" = {\n");
            writer.write("   \t\t\tfileRef = ");
            writer.write(((SourceEntry)entry).getSourceID());
            writer.write(";\n");
            writer.write("   \t\t\tisa = PBXBuildFile;\n");
            writer.write("   \t\t\tsettings = {\n");
            writer.write("   \t\t\t};\n");
            writer.write("   \t\t};\n");
        }
        writer.write("//   080\n");
        writer.write("//   081\n");
        writer.write("//   082\n");
        writer.write("//   083\n");
        writer.write("//   084\n");
        writer.write("//   1A0\n");
        writer.write("//   1A1\n");
        writer.write("//   1A2\n");
        writer.write("//   1A3\n");
        writer.write("//   1A4\n");
        writer.write("   \t\t1AB674ADFE9D54B511CA2CBB = {\n");
        writer.write("   \t\t\tchildren = (\n");
        writer.write("   \t\t\t\tD2AAC0630554660B00DB518D,\n");
        writer.write("   \t\t\t);\n");
        writer.write("   \t\t\tisa = PBXGroup;\n");
        writer.write("   \t\t\tname = Products;\n");
        writer.write("   \t\t\trefType = 4;\n");
        writer.write("   \t\t\tsourceTree = \"<group>\";\n");
        writer.write("   \t\t};\n");
        writer.write("//   1A0\n");
        writer.write("//   1A1\n");
        writer.write("//   1A2\n");
        writer.write("//   1A3\n");
        writer.write("//   1A4\n");
        writer.write("//   D20\n");
        writer.write("//   D21\n");
        writer.write("//   D22\n");
        writer.write("//   D23\n");
        writer.write("//   D24\n");
        writer.write("   \t\tD2AAC0600554660B00DB518D = {\n");
        writer.write("   \t\t\tbuildActionMask = 2147483647;\n");
        writer.write("   \t\t\tfiles = (\n");
        writer.write("   \t\t\t);\n");
        writer.write("   \t\t\tisa = PBXHeadersBuildPhase;\n");
        writer.write("   \t\t\trunOnlyForDeploymentPostprocessing = 0;\n");
        writer.write("   \t\t};\n");
        writer.write("   \t\tD2AAC0610554660B00DB518D = {\n");
        writer.write("   \t\t\tbuildActionMask = 2147483647;\n");
        writer.write("   \t\t\tfiles = (\n");
        for (i = 0; i < sortedSources.length; ++i) {
            writer.write("   \t\t\t\t");
            writer.write(((SourceEntry)sortedSources[i]).getBuildID());
            writer.write(",\n");
        }
        writer.write("   \t\t\t);\n");
        writer.write("   \t\t\tisa = PBXSourcesBuildPhase;\n");
        writer.write("   \t\t\trunOnlyForDeploymentPostprocessing = 0;\n");
        writer.write("   \t\t};\n");
        writer.write("   \t\tD2AAC0620554660B00DB518D = {\n");
        writer.write("   \t\t\tbuildPhases = (\n");
        writer.write("   \t\t\t\tD2AAC0600554660B00DB518D,\n");
        writer.write("   \t\t\t\tD2AAC0610554660B00DB518D,\n");
        writer.write("   \t\t\t);\n");
        writer.write("   \t\t\tbuildRules = (\n");
        writer.write("   \t\t\t);\n");
        writer.write("   \t\t\tbuildSettings = {\n");
        writer.write("   \t\t\t\tDYLIB_COMPATIBILITY_VERSION = 1;\n");
        writer.write("   \t\t\t\tDYLIB_CURRENT_VERSION = 1;\n");
        if (gccConfig != null) {
            String[] options = gccConfig.getPreArguments();
            boolean hasD = false;
            for (int i3 = 0; i3 < options.length; ++i3) {
                if (!options[i3].startsWith("-D")) continue;
                if (!hasD) {
                    writer.write("   \t\t\t\tGCC_PREPROCESSOR_DEFINITIONS = \"");
                    hasD = true;
                } else {
                    writer.write(" ");
                }
                writer.write(options[i3].substring(2));
            }
            if (hasD) {
                writer.write("\";\n");
            }
        }
        writer.write("   \t\t\t\tGCC_WARN_FOUR_CHARACTER_CONSTANTS = NO;\n");
        writer.write("   \t\t\t\tGCC_WARN_UNKNOWN_PRAGMAS = NO;\n");
        if (gccConfig != null && (includes = gccConfig.getIncludePath()).length > 0) {
            writer.write("   \t\t\t\tHEADER_SEARCH_PATHS = \"");
            for (int i4 = 0; i4 < includes.length; ++i4) {
                if (i4 > 0) {
                    writer.write(" ");
                }
                writer.write(CUtil.getRelativePath(basePath, includes[i4]));
            }
            writer.write("\";\n");
        }
        String[] linkerArgs = null;
        ProcessorConfiguration linkConfig = linkTarget.getConfiguration();
        if (linkConfig instanceof CommandLineLinkerConfiguration) {
            linkerArgs = ((CommandLineLinkerConfiguration)linkConfig).getPreArguments();
        }
        writer.write("   \t\t\t\tINSTALL_PATH = /usr/local/lib;\n");
        if (linkerArgs != null) {
            boolean hasLibPath = false;
            for (int i5 = 0; i5 < linkerArgs.length; ++i5) {
                if (!linkerArgs[i5].startsWith("-L")) continue;
                if (!hasLibPath) {
                    writer.write("   \t\t\t\tLIBRARY_SEARCH_PATHS = \"");
                    hasLibPath = true;
                } else {
                    writer.write(" ");
                }
                writer.write(linkerArgs[i5].substring(2));
            }
            if (hasLibPath) {
                writer.write("\";\n");
            }
        }
        writer.write("   \t\t\t\tLIBRARY_STYLE = DYNAMIC;\n");
        writer.write("   \t\t\t\tOTHER_CFLAGS = \"\";\n");
        writer.write("   \t\t\t\tOTHER_LDFLAGS = \"");
        if (linkerArgs != null) {
            String prepend = "";
            for (int i6 = 0; i6 < linkerArgs.length; ++i6) {
                if (linkerArgs[i6].startsWith("-L")) continue;
                writer.write(prepend);
                writer.write(linkerArgs[i6]);
                prepend = "  ";
            }
        }
        writer.write("\";\n");
        writer.write("   \t\t\t\tOTHER_REZFLAGS = \"\";\n");
        writer.write("   \t\t\t\tPRODUCT_NAME = testbsd;\n");
        writer.write("   \t\t\t\tSECTORDER_FLAGS = \"\";\n");
        writer.write("   \t\t\t\tWARNING_CFLAGS = \"-Wmost\";\n");
        writer.write("   \t\t\t};\n");
        writer.write("   \t\t\tdependencies = (\n");
        writer.write("   \t\t\t);\n");
        writer.write("   \t\t\tisa = PBXNativeTarget;\n");
        writer.write("   \t\t\tname = ");
        writer.write(outFile.getName());
        writer.write(";\n");
        writer.write("   \t\t\tproductName = ");
        writer.write(outFile.getName());
        writer.write(";\n");
        writer.write("   \t\t\tproductReference = D2AAC0630554660B00DB518D;\n");
        String productType = "com.apple.product-type.library.dynamic";
        String prefix = "lib";
        String suffix = ".dylib";
        String explicitFileType = "compiled.mach-o.dylib";
        String outType = task.getOuttype();
        if ("executable".equals(outType)) {
            productType = "com.apple.product-type.tool";
            prefix = "";
            suffix = "";
            explicitFileType = "compiled.mach-o.executable";
        } else if ("static".equals(outType)) {
            productType = "com.apple.product-type.library.static";
            suffix = ".a";
            explicitFileType = "archive.ar";
        }
        writer.write("   \t\t\tproductType = \"");
        writer.write(productType);
        writer.write("\";\n");
        writer.write("   \t\t};\n");
        writer.write("   \t\tD2AAC0630554660B00DB518D = {\n");
        writer.write("   \t\t\texplicitFileType = \"");
        writer.write(explicitFileType);
        writer.write("\";\n");
        writer.write("   \t\t\tincludeInIndex = 0;\n");
        writer.write("   \t\t\tisa = PBXFileReference;\n");
        writer.write("   \t\t\tpath = ");
        writer.write(outFile.getName());
        writer.write(suffix);
        writer.write(";\n");
        writer.write("   \t\t\trefType = 3;\n");
        writer.write("   \t\t\tsourceTree = BUILT_PRODUCTS_DIR;\n");
        writer.write("   \t\t};\n");
        writer.write("   \t};\n");
        writer.write("   \trootObject = 08FB7793FE84155DC02AAC07;\n");
        writer.write("   }\n");
        ((Writer)writer).close();
    }

    private CommandLineCompilerConfiguration getBaseCompilerConfiguration(Hashtable targets) {
        CommandLineCompilerConfiguration compilerConfig = null;
        Iterator targetIter = targets.values().iterator();
        while (targetIter.hasNext()) {
            TargetInfo targetInfo = (TargetInfo)targetIter.next();
            ProcessorConfiguration config = targetInfo.getConfiguration();
            String identifier = config.getIdentifier();
            if (!(config instanceof CommandLineCompilerConfiguration) || !((compilerConfig = (CommandLineCompilerConfiguration)config).getCompiler() instanceof GccCCompiler)) continue;
            return compilerConfig;
        }
        return null;
    }

    private static final class SourceEntry {
        private final File file;
        private final String sourceID;
        private final String buildID;

        public SourceEntry(File fileArg, String sourceIDArg, String buildIDArg) {
            this.file = fileArg;
            this.sourceID = sourceIDArg;
            this.buildID = buildIDArg;
        }

        public File getFile() {
            return this.file;
        }

        public String getSourceID() {
            return this.sourceID;
        }

        public String getBuildID() {
            return this.buildID;
        }
    }
}

