#include <cassert>

#include "talk/base/signalthread.h"
#include "talk/base/postthread.h"

using namespace cricket;

class SignalThread::WorkerThread : public PostThread {
public:
  WorkerThread(SignalThread * parent) :
    PostThread(parent, 0), parent_(parent), halt_(false) {
  }

  virtual void Run() {
    parent_->DoWork(&halt_);
  }

  virtual void Halt() { halt_ = true; }
  bool halting() const { return halt_; }

private:
  SignalThread * parent_;
  bool halt_;
};

SignalThread::SignalThread() : worker_(0), destroy_(false), destroy_when_done_(false) {
}

SignalThread::~SignalThread() {
  assert(worker_ == 0);
}

void SignalThread::StartWork() {
  if (worker_) {
    assert(false);
    return;
  }
  worker_ = new WorkerThread(this);
  worker_->Start();
}

void SignalThread::StopWork() {
  if (worker_)
    worker_->Stop();
}

void SignalThread::Destroy() {
  if (destroy_)
    return;

  destroy_ = true;
  StopWork();
  if (!worker_)
    delete this;
}

bool SignalThread::ContinueWorking() {
  assert(worker_ != 0);
  return !worker_->halting();
}

void SignalThread::OnWorkDone() {
  if (!destroy_)
    SignalWorkDone(this);
  if (destroy_when_done_)
   delete this;
}

void SignalThread::OnMessage(Message *msg) {
  assert(worker_ != 0);
  assert(msg->message_id == 0);
  
  worker_->Release();
  worker_ = 0;
  if (destroy_)
    delete this;
  else
    OnWorkDone();
}
