/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParserUtil {
    static /* synthetic */ Class class$java$awt$Color;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static Rectangle2D getElementPosition(Attributes atts) throws SAXException {
        float x = ParserUtil.parseRelativeFloat(atts.getValue("x"), "Element x not specified");
        float y = ParserUtil.parseRelativeFloat(atts.getValue("y"), "Element y not specified");
        float w = ParserUtil.parseRelativeFloat(atts.getValue("width"), "Element width not specified");
        float h = ParserUtil.parseRelativeFloat(atts.getValue("height"), "Element height not specified");
        Rectangle2D.Float retval = new Rectangle2D.Float(x, y, w, h);
        return retval;
    }

    public static boolean parseBoolean(String text, boolean defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        return text.equalsIgnoreCase("true");
    }

    public static Color parseColor(String color) {
        return ParserUtil.parseColor(color, Color.black);
    }

    public static Color parseColor(String color, Color defaultValue) {
        if (color == null) {
            return defaultValue;
        }
        try {
            return Color.decode(color);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Field f = (class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = ParserUtil.class$("java.awt.Color"))).getField(color);
                return (Color)f.get(null);
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }
    }

    public static float parseFloat(String text, float defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultVal;
        }
    }

    public static float parseFloat(String text, String message) throws SAXException {
        if (text == null) {
            throw new SAXException(message);
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("NumberFormatError: " + message);
        }
    }

    public static int parseInt(String text, int defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultVal;
        }
    }

    public static int parseInt(String text, String message) throws SAXException {
        if (text == null) {
            throw new SAXException(message);
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException("NumberFormatError: " + message);
        }
    }

    public static float parseRelativeFloat(String value, String exceptionMessage) throws SAXException {
        if (value == null) {
            throw new SAXException(exceptionMessage);
        }
        String tvalue = value.trim();
        if (tvalue.endsWith("%")) {
            String number = tvalue.substring(0, tvalue.indexOf("%"));
            float f = ParserUtil.parseFloat(number, exceptionMessage) * -1.0f;
            return f;
        }
        return ParserUtil.parseFloat(tvalue, exceptionMessage);
    }

    public static String parseString(String text, String defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        return text;
    }

    public static Stroke parseStroke(String weight) {
        try {
            if (weight != null) {
                Float w = new Float(weight);
                return new BasicStroke(w.floatValue());
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return new BasicStroke(1.0f);
    }
}

