#! /bin/sh -pe

# rproxy -- dynamic caching and delta update in HTTP
# $Id: mkprototab.sh,v 1.2 2000/08/07 07:23:16 mbp Exp $
# 
# Copyright (C) 2000 by Martin Pool <mbp@humbug.org.au>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1 of
# the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# Generate code for the instruction tables

cat <<EOF 
/* AUTOGENERATED BY $0, DO NOT EDIT */

#include "includes.h"
#include "protocol.h"
#include "command.h"
#include "prototab.h"

/* This file defines an array mapping command IDs to the operation kind,
 * implied literal value, length of the first and second parameters,
 * and length of the whole command.  The implied value is only used
 * if the first parameter length is zero. */

const struct hs_prototab_ent _hs_prototab[] = {
EOF

not_first=
value=0
emit_cmd() {
    if test "$not_first"
    then 
	printf ', \n'
    fi
    not_first=1
    len=`expr 1 + $3 + $4 `
    printf '    { op_kind_%-10s, %3d, %d, %d, %d }            /* %#4x */' $@ $len $value
    value=`expr $value + 1 `
}

emit_cmd eof 0 0 0

for i in `seq 1 120`
do
    emit_cmd literal $i 0 0
done

for i in 1 2 4
do 
    emit_cmd literal 0 $i 0
done

for i in `seq 1 119`
do
    emit_cmd signature $i 0 0
done

for i in 1 2 4
do 
    emit_cmd signature 0 $i 0
done

emit_cmd checksum 0 2 0

for i in 2 4
do
    for j in 1 2 4
    do
	emit_cmd copy 0 $i $j
    done
done

# These would be int64 COPY commands, but we don't support long files
# yet so they're illegal.

for j in 1 2 4
do
    emit_cmd reserved 0 8 $j
done

# we've just moved past the last command, so assert value == 0xff+1
if test $value -ne 256
then
    printf "$0: internal inconsistency: last command is %#x not 0xff\n" \
	`expr $value - 1` >&2
    exit 1
fi

cat <<EOF

};
/* end of autogenerated code */
EOF