/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * EncodingFactory.java
 * ------------
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.IOException;

import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;

/**
 * Creation-Date: 29.04.2006, 14:32:15
 *
 * @author Thomas Morgner
 */
public class EncodingFactory implements ResourceFactory
{
  public EncodingFactory()
  {
  }

  public Resource create(final ResourceManager manager,
                         final ResourceData data,
                         final ResourceKey context)
          throws ResourceCreationException, ResourceLoadingException
  {
    try
    {
      final InputStream in = data.getResourceAsStream(manager);
      final ObjectInputStream oin = new ObjectInputStream(in);
      try
      {
        final Object ob = oin.readObject();
        // yes, that will be more generic in the future ...
        if (ob instanceof External8BitEncodingData == false)
        {
          throw new ResourceCreationException("This is no 8Bit Encoding data");
        }
        final External8BitEncodingData encData = (External8BitEncodingData) ob;
        final External8BitEncodingCore encCore =
                new External8BitEncodingCore(encData);
        return new SimpleResource(data.getKey(), encCore, data.getVersion(manager));
      }
      finally
      {
        oin.close();
      }
    }
    catch (IOException e)
    {
      throw new ResourceLoadingException("Failed to load resource", e);
    }
    catch (ClassNotFoundException e)
    {
      throw new ResourceCreationException
              ("Missing class definition: Failed to create encoding.");
    }
  }

  public Class getFactoryType()
  {
    return Encoding.class;
  }

  public void initializeDefaults()
  {
    // do nothing -- yet ..
  }
}
