/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "flux.h"


char *mt_types[MT_TYPES_NUM] =
{
  "data", "entity", "empty", "span"
};


MT *mt_new(MT_TYPE type)
{
  TT *tt_type;

  tt_type = tt_new();
  tt_data_set_internal(tt_type, mt_types[type], strlen(mt_types[type]), TRUE);

  return(MT(tt_type));
}


MT *mt_dup(MT *mt)
{
  TT *tt_n, *tt_n_sub, *tt_temp;
  

  tt_n = tt_dup(TT(mt));

  for (tt_temp = tt_get_first_child(TT(mt)); tt_temp; tt_temp = tt_get_next(tt_temp))
  {
    if (!tt_strcmp(tt_temp, "sub")) continue;
    else
    {
      tt_n_sub = tt_dup_all(tt_temp);
      tt_add_as_last_child(tt_n, tt_n_sub);
    }
  }

  return(MT(tt_n));
}


MT *mt_dup_all(MT *mt)
{
  MT *mt_n, *mt_child, *mt_n_child;

  /* Self */
  
  mt_n = mt_dup(mt);
  
  /* Children */
  
  for (mt_child = mt_get_first_child(mt); mt_child; mt_child = mt_get_next(mt_child))
  {  
    mt_n_child = mt_dup_all(mt_child);
    mt_add_as_last_child(mt_n, mt_n_child);
  }
  
  return(mt_n);
}
