/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>


/* --- Time-related --- */

const char *month_strl[12] = { "January", "February", "March", "April", "May", "June", "July", "August", "September",
                               "October", "November", "December" };
const char *smonth_strl[12] = { "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec" };
const char *day_strl[7] = { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" };
const char *sday_strl[7] = { "SUN", "mon", "tue", "wed", "thu", "fri", "sat" };


/* -------------------------
   Make readable date string
   ------------------------- */

char *datestr_soft(time_t srctime)
{
  struct tm loctime;
  char temp_str[256];


  localtime_r(&srctime, &loctime);

  sprintf(temp_str, "%02d.%s.%02d %02d:%02d", loctime.tm_mday, smonth_strl[loctime.tm_mon], loctime.tm_year % 100,
          loctime.tm_hour, loctime.tm_min);
  
  return(strdup(temp_str));
}


/* ------------------------
   Make compact date string
   ------------------------ */

char *datestr_hard(time_t srctime)
{
  struct tm loctime;
  char temp_str[256];
  

  localtime_r(&srctime, &loctime);

  sprintf(temp_str, "%04d%02d%02d %02d:%02d", loctime.tm_year + 1900, loctime.tm_mon + 1, loctime.tm_mday,
          loctime.tm_hour, loctime.tm_min);

  return(strdup(temp_str));
}
