// Author: Enrico Zini
// License: GPL


#include <ept/init.h>
#include <ept/cache/component/debtags/pkgidx.h>
#include <ept/cache/component/tags.h>

#include <iostream>

using namespace aptFront;
using namespace cache;
using namespace std;

void usage(const char* argv0, int res)
{
	cerr << "Usage: " << argv0 << " {pkgidx|voc|tagdb}" << endl;
	exit(res);
}

Cache& openCache()
{
	aptFront::init();
	Cache& c = cache::Global::get();
	c.open(cache::Cache::OpenDefault
			| cache::Cache::OpenReadOnly
			| cache::Cache::OpenDebtags);
	return c;
}

int main(int argc, char* argv[])
{
	if (argc == 1)
		usage(argv[0], 1);

	string cmd(argv[1]);

	if (cmd == "pkgidx")
	{
		Cache& c = openCache();
		component::debtags::PkgIdx& p = c.pkgidx();
		cout << "PkgIdx size: " << p.size() << endl;
		for (size_t i = 0; i < p.size(); i++)
			cout << i << "[" << p.size(i) << "]: '" << p.name(i) << "'" << endl;
	}
	else if (cmd == "voc")
	{
		Cache& c = openCache();
		component::Tags& t = c.tags();

		const component::Tags::FacetIndex& fi = t.facetIndex();
		cout << "FacetIndex size: " << fi.size() << endl;
		for (size_t i = 0; i < fi.size(); i++)
			cout << i << ": @" << fi.offset(i) << "+" << fi.size(i) << \
				", tags " << fi.firsttag(i) << "-" << fi.lasttag(i) << \
				" " << fi.name(i) << endl;

		const component::Tags::TagIndex& ti = t.tagIndex();
		cout << "TagIndex size: " << ti.size() << endl;
		for (size_t i = 0; i < ti.size(); i++)
			cout << i << ": @" << ti.offset(i) << "+" << ti.size(i) << \
				", facet " << ti.facet(i) << " " << ti.name(i) << endl;

	}
	else if (cmd == "tagdb")
	{
		Cache& c = openCache();
		//component::TagMap& p = c.debtags();
		cerr << "Not yet implemented." << endl;
	} 
	else
		usage(argv[0], 1);

	return 0;
}
