#include <ept/config.h>
#include <ept/tests/test-utils.h>
#include <ept/cache/package.h>
#include <ept/cache/debtags/vocabulary.h>
#include <ept/error.h>
#include <ept/cache/cache.h>
#include <ept/cache/version.h>

namespace tut {
using namespace ept;
using namespace configuration::apt;
using namespace cache;

struct cache_package_shar : common {
    Aggregator agg;
    Package a;
};

TESTGRP( cache_package );

template<> template<>
void to::test<1> ()
{
    a = agg.index().packageByName("postfix");
    ensure_equals( a.name(), "postfix" );
}

template<> template<>
void to::test<2> ()
{
    Package b;
    int check = 1;
    try {
        b.name();
        check = 2;
    } catch ( ... ) { // XXX catch specific exception
        check = 3;
    }
    ensure_equals( check, 3 );
}

template<> template<>
void to::test<3> ()
{
    a = agg.index().packageByName("prelink");
    Entity i, j;
    i = a;
    j = i;
    ensure( i == Entity( a ) );
    ensure( j == Entity( a ) );
    ensure( j == i );
}

template<> template<>
void to::test<4> ()
{
    a = agg.index().packageByName( "postfix" );
    wibble::Range< Version > vr = a.versions();
    ensure( !vr.empty() );
    Version v = vr.head();
    ensure_equals( v.versionString(), "2.1.4-5" );
}

template<> template<>
void to::test<5> ()
{
    a = agg.index().packageByName( "postfix" );
    Version v = a.versionByString( "2.1.4-5" );
    ensure( v.valid() );
    ensure_equals( v.versionString(), "2.1.4-5" );
}

template<> template<>
void to::test<6> ()
{
    a = agg.index().packageByName( "postfix" );
    wibble::Range< Version > _v1 = a.versions();
    wibble::Range< Version > _v3;
    _v3 = agg.index().packageByName( "exim4" ).versions();
    ensure( !_v1.empty() );
    ensure( !_v3.empty() );
    Version v1 = _v1.head();
    Version v2 = a.versionByString( v1.versionString() );
    Version v3 = _v3.head();
    ensure( v1 == v2 );
    ensure( v1 != v3 );
    ensure( v2 != v3 );
}

template<> template<>
void to::test<7>()
{
    Package P = agg.index().packageByName("postfix");
    ensure( P.hasVersion() );
}

template<> template<>
void to::test<8>()
{
    Package p = agg.index().packageByName("postfix");
    Entity e = p;
    // ensure( e.is< entity::Named >() );
    ensure( e.is< Package >() );
}

template<> template<>
void to::test<9>()
{
    Package p = agg.index().packageByName("postfix");
    ensure_equals( p.section(), "mail" );
}

template<> template<>
void to::test<10>()
{
    Package p = agg.index().packageByName( "postfix" );
    cache::Tag::Set ts = p.tags( cache::Tag::Set() );
    ensure( ts != cache::Tag::Set() );
    ensure( ts.find( agg.vocabulary().tagByName( "interface::daemon" ) ) != ts.end() );
    ensure( ts.find( agg.vocabulary().tagByName( "special::meta" ) ) == ts.end() );
}

#if 0 // stable package stuff

template<> template<>
void to::test<10>()
{
    Package::Stable p = c.packageByName("postfix");
    c.invalidate();
    ensure_equals( p.name(), "postfix" );
}

template<> template<>
void to::test<11>()
{
    Package::Stable p = c.packageByName( "postfix" );
    Package::Stable q = c.packageByName( "postfix" );
    ensure_equals( p.name(), q.name() );
    ensure( p == q );
    c.invalidate();
    ensure_equals( p.name(), q.name() );
    ensure( p == q );
}

template<> template<>
void to::test<12>()
{
    Package::Stable p = c.packageByName( "postfix" );
    Package::Stable q = c.packageByName( "exim4" );
    ensure( p != q );
    c.invalidate();
    ensure( p != q );
}

#endif

template<> template<>
void to::test<13>()
{
    Package p = agg.index().packageByName( "postfix" );
    Package q = agg.index().packageByName( "exim4" );
    ensure( p != q );
}

template<> template<>
void to::test<14>()
{
    Package p = agg.index().packageByName( "postfix" );
    Package q = agg.index().packageByName( "postfix" );
    ensure( p == q );
    ensure_equals( p.name(), q.name() );
    ensure_equals( p.anyVersion().completeRecord(), q.anyVersion().completeRecord() );
}

#if 0
template<> template<>
void to::test<1> ()
{
    a = c.packageByName("postfix");
    ensure( a.pointer().package() );
    // ensure (a.pkgPtr());
}
#endif

#if 0
template<> template<>
void to::test<21>()
{
    Entity i;
    entity::Package p;
    entity::StablePackage s;
    i = p;
    s = i;
}

template<> template<>
void to::test<22>()
{
    Cache *_c = new Cache;
    // cache::Global::setCache( _c );
    // _c->open( Cache::OpenDefault | Cache::OpenReadOnly );
    a = _c->packages().packageByName("postfix");
	ensure( a.valid() );
	// If the package is valid, it should not throw
	// FIXME: it actually might, if the component is not there
	//a.tags();

	// Check that the invalid package returns the default tags
	a = Package<>();
	Tagcoll::OpSet<entity::Tag> defaultts;
	defaultts += entity::Tag();
	Tagcoll::OpSet<entity::Tag> ts = a.tags(defaultts);
	ensure( defaultts == ts );

	// FIXME: what else can I assume about availability of tag data and
	// vocabulary here?  Do we have something already, or should I setup some
	// data for Debtags tests?
}
#endif

#if 0
template<> template<>
void to::test<6> ()
{
    vector<entity::Package> l;
    c.packages(back_inserter( l ));
    pkgCache::PkgIterator P = *l.begin();
    entity::Package i = P;
    ensure( P == i );
    for (int j = 0; j < 1024; j ++) {
        ++ P;
        i = i.nextInCache();
        ensure( P == i );
    }
}
#endif

#if 0

template<> template<>
void to::test<9> ()
{
    entity::StablePackage P = c.packages().packageByName("postfix");
    entity::Package _P = P;
    c.open( Cache::OpenDefault | Cache::OpenReadOnly );
    ensure_equals(P.name(), "postfix");
}

template<> template<>
void to::test<10> ()
{
    entity::StablePackage P (&c);
    P = c.packages().packageByName("postfix");
    c.open( Cache::OpenDefault | Cache::OpenReadOnly );
    ensure_equals(P.name(), "postfix");
}

template<> template<>
void to::test<11> ()
{
    entity::Package P;
    P = c.packages().packageByName("postfix");
    Entity i = P.stable();
    entity::StablePackage Q( i );
    P = i;
    ensure_equals(P.name(), "postfix");
    ensure_equals(Q.name(), "postfix");
    ensure(Q == P);
}

template<> template<>
void to::test<12> ()
{
    entity::Package P;
    P = c.packages().packageByName("postfix");
    entity::StablePackage i( P.stable() );
    c.open( Cache::OpenDefault | Cache::OpenReadOnly );
    P = i;
    ensure_equals(P.name(), "postfix");
}

template<> template<>
void to::test<13> ()
{
    entity::Package P;
    P = c.packages().packageByName("postfix");
    Entity i = P.stable();
    c.open( Cache::OpenDefault | Cache::OpenReadOnly );
    entity::StablePackage j( i );
    P = j;
    ensure_equals(P.name(), "postfix");
}

template<> template<>
void to::test<14> ()
{
    entity::Package P;
    P = c.packages().packageByName("postfix");
    Entity i = P.stable();
    c.open( Cache::OpenDefault | Cache::OpenReadOnly );
    P = i;
    ensure_equals(P.name(), "postfix");
}

template<> template<>
void to::test<15> ()
{
    entity::StablePackage P( &c );
    P = c.packages().packageByName("postfix");
    c.open( Cache::OpenDefault | Cache::OpenReadOnly );
    entity::Package Q;
    entity::Package R = P;
    Q = c.packages().packageByName( "postfix" );
    ensure( R == Q );
}

template<> template<>
void to::test<16> ()
{
    entity::StablePackage P (&c);
    P = c.packages().packageByName("postfix");
    c.open( Cache::OpenDefault | Cache::OpenReadOnly );
    entity::Package Q;
    Q = c.packages().packageByName("postfix");
    ensure( P == Q );
}

template<> template<>
void to::test<17> ()
{
    cache::Cache c2;
    c.open( Cache::OpenDefault | Cache::OpenReadOnly );
    entity::StablePackage P1 (&c);
    entity::StablePackage P2 (&c2);
    P1 = c.packages().packageByName("postfix");
    P2 = P1;
    c.open( Cache::OpenDefault | Cache::OpenReadOnly );
    entity::Package Q, R;
    Q = c.packages().packageByName("postfix");
    R = P2;
    ensure_equals( R.name(), Q.name() );
    ensure_equals( R.name(), "postfix" );
}

template<> template<>
void to::test<18> ()
{
    int i = 0;
    try {
        a = c.packages().packageByName("postfix");
        i = 1;
        ensure( a.pointer().package() );
        // ensure (a.pkgPtr());
        i = 2;
    } catch ( std::out_of_range ) {
        // cerr << "out of bounds!" << endl;
        i = 3;
    /* } catch ( NullPointerError ) {
        cerr << "null pointer!" << endl;
        i = 4; */
    } catch ( std::bad_cast ) {
        // cerr << "type error!" << endl;
        i = 5;
    }
    ensure_equals( i, 2 );
}
#endif

#if 0
template<> template<>
void to::test<19> ()
{
    Cache *_c = new Cache;
    cache::Global::setCache( _c );
    _c->open( Cache::OpenDefault | Cache::OpenReadOnly );
    a = _c->packages().packageByName("postfix");
    entity::Package p( 0, a.pointer().package() );
    entity::Package q( _c, a.pointer().package() );
    ensure( a == p );
    ensure( a == q );
    ensure( p == q );
    cache::Global::setCache( 0 );
}
#endif

}

#include <ept/cache/apt/packages.tcc>
// vim:set ts=4 sw=4:
