/*

    Mutex class, header
    Copyright (C) 1999-2000 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <pthread.h>


#ifndef MUTEX_HH
    #define MUTEX_HH

    class clMutex
    {
            pthread_mutex_t pthmMutex;
        public:
            clMutex () { pthread_mutex_init(&pthmMutex, NULL); }
            ~clMutex () { pthread_mutex_destroy(&pthmMutex); }
            bool Wait ()
                { 
                    if (pthread_mutex_lock(&pthmMutex) != 0)
                        return false;
                    return true;
                }
            bool Release ()
                { 
                    if (pthread_mutex_unlock(&pthmMutex) != 0)
                        return false;
                    return true;
                }
            bool TryLock ()
                {
                    if (pthread_mutex_trylock(&pthmMutex) != 0)
                        return false;
                    return true;
                }
            pthread_mutex_t *GetPtr () { return (&pthmMutex); }
    };

#endif
