/* 
 * $Id: ctkvseparator.c,v 1.5 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"

/* Initialize the VSeparator Widget */
void
    ctk_vseparator_init(CtkVSeparator *vseparator)
{
	ctk_separator_init(&vseparator->separator);
}

/* Make a new VSeparator Widget */
CtkWidget *
    ctk_vseparator_new()
{
	CtkVSeparator *vseparator;
	
	vseparator = g_malloc(sizeof(CtkVSeparator));
	
	ctk_vseparator_init(vseparator);
	
	((CtkObject *)vseparator)->type = CtkTypeVSeparator;
	((CtkWidget *)vseparator)->width = 1;
	((CtkWidget *)vseparator)->orig_width = 1;
	((CtkWidget *)vseparator)->height = 1;
	((CtkWidget *)vseparator)->orig_height = 1;
		
	return (CtkWidget *)vseparator;
}
